/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFactories;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.ver1.PcepCloseMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepErrorMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepInitiateMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepKeepaliveMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepLabelRangeResvMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepLabelUpdateMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepOpenMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepReportMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepTEReportMsgVer1;
import org.onosproject.pcepio.protocol.ver1.PcepUpdateMsgVer1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PcepMessageVer1 {
    protected static final Logger log = LoggerFactory.getLogger(PcepFactories.class);
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 4;
    static final int PACKET_VERSION = 1;
    static final byte OPEN_MSG_TYPE = 1;
    static final byte KEEPALIVE_MSG_TYPE = 2;
    static final byte REPORT_MSG_TYPE = 10;
    static final byte TE_REPORT_MSG_TYPE = 14;
    static final byte UPDATE_MSG_TYPE = 11;
    static final byte INITIATE_MSG_TYPE = 12;
    static final byte CLOSE_MSG_TYPE = 7;
    static final byte ERROR_MSG_TYPE = 6;
    static final byte LABEL_UPDATE_MSG_TYPE = 13;
    static final byte LABEL_RANGE_RESV_MSG_TYPE = 15;
    public static final int SHIFT_FLAG = 5;
    static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    public static final Reader READER = new Reader();

    static class Reader
    implements PcepMessageReader<PcepMessage> {
        Reader() {
        }

        @Override
        public PcepMessage readFrom(ChannelBuffer cb) throws PcepParseException {
            if (cb.readableBytes() < 4) {
                throw new PcepParseException("Packet should have minimum length: 4");
            }
            try {
                int start = cb.readerIndex();
                byte version = cb.readByte();
                version = (byte)(version >> 5);
                if (version != 1) {
                    throw new PcepParseException("Wrong version. Expected=PcepVersion.Message_1(1), got=" + version);
                }
                byte type = cb.readByte();
                short length = cb.readShort();
                cb.readerIndex(start);
                switch (type) {
                    case 1: {
                        log.debug("OPEN MESSAGE is received");
                        return PcepOpenMsgVer1.READER.readFrom(cb.readBytes((int)length));
                    }
                    case 2: {
                        log.debug("KEEPALIVE MESSAGE is received");
                        return PcepKeepaliveMsgVer1.READER.readFrom(cb.readBytes((int)length));
                    }
                    case 6: {
                        log.debug("ERROR MESSAGE is received");
                        return PcepErrorMsgVer1.READER.readFrom(cb.readBytes((int)length));
                    }
                    case 10: {
                        log.debug("REPORT MESSAGE is received");
                        return PcepReportMsgVer1.READER.readFrom(cb.readBytes((int)length));
                    }
                    case 11: {
                        log.debug("UPDATE MESSAGE is received");
                        return PcepUpdateMsgVer1.READER.readFrom(cb.readBytes((int)length));
                    }
                    case 12: {
                        log.debug("INITIATE MESSAGE is received");
                        return PcepInitiateMsgVer1.READER.readFrom(cb.readBytes((int)length));
                    }
                    case 7: {
                        log.debug("CLOSE MESSAGE is received");
                        return PcepCloseMsgVer1.READER.readFrom(cb.readBytes((int)length));
                    }
                    case 14: {
                        log.debug("TE REPORT MESSAGE is received");
                        return PcepTEReportMsgVer1.READER.readFrom(cb.readBytes((int)length));
                    }
                    case 13: {
                        log.debug("LABEL UPDATE MESSAGE is received");
                        return PcepLabelUpdateMsgVer1.READER.readFrom(cb.readBytes((int)length));
                    }
                    case 15: {
                        log.debug("LABEL RANGE RESERVE MESSAGE is received");
                        return PcepLabelRangeResvMsgVer1.READER.readFrom(cb.readBytes((int)length));
                    }
                }
                throw new PcepParseException("ERROR: UNKNOWN MESSAGE is received. Msg Type: " + type);
            }
            catch (IndexOutOfBoundsException e) {
                throw new PcepParseException(1, 1);
            }
        }
    }
}

