/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepRPObject;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepRPObjectVer1
implements PcepRPObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepRPObjectVer1.class);
    public static final byte RP_OBJ_TYPE = 1;
    public static final byte RP_OBJ_CLASS = 2;
    public static final byte RP_OBJECT_VERSION = 1;
    public static final short RP_OBJ_MINIMUM_LENGTH = 12;
    public static final int DEFAULT_REQUEST_ID_NUM = 0;
    public static final boolean DEFAULT_OFLAG = false;
    public static final boolean DEFAULT_BFLAG = false;
    public static final boolean DEFAULT_RFLAG = false;
    public static final byte DEFAULT_PRIFLAG = 0;
    public static final int OBJECT_HEADER_LENGTH = 4;
    public static final int OFLAG_SHIFT_VALUE = 5;
    public static final int BFLAG_SHIFT_VALUE = 4;
    public static final int RFLAG_SHIFT_VALUE = 3;
    public static final int OFLAG_TEMP_SHIFT_VALUE = 32;
    public static final int BFLAG_TEMP_SHIFT_VALUE = 16;
    public static final int RFLAG_TEMP_SHIFT_VALUE = 8;
    public static final int PRIFLAG_TEMP_SHIFT_VALUE = 7;
    public static final int BIT_SET = 1;
    public static final int BIT_RESET = 0;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    public static final PcepObjectHeader DEFAULT_RP_OBJECT_HEADER = new PcepObjectHeader(2, 1, false, false, 12);
    private PcepObjectHeader rpObjHeader;
    private int iRequestIdNum;
    private boolean bOFlag;
    private boolean bBFlag;
    private boolean bRFlag;
    private byte yPriFlag;
    private LinkedList<PcepValueType> llOptionalTlv;

    public PcepRPObjectVer1(PcepObjectHeader rpObjHeader, int iRequestIdNum, boolean bOFlag, boolean bBFlag, boolean bRFlag, byte yPriFlag, LinkedList<PcepValueType> llOptionalTlv) {
        this.rpObjHeader = rpObjHeader;
        this.iRequestIdNum = iRequestIdNum;
        this.bOFlag = bOFlag;
        this.bBFlag = bBFlag;
        this.bRFlag = bRFlag;
        this.yPriFlag = yPriFlag;
        this.llOptionalTlv = llOptionalTlv;
    }

    public void setRPObjHeader(PcepObjectHeader obj) {
        this.rpObjHeader = obj;
    }

    @Override
    public void setRequestIdNum(int iRequestIdNum) {
        this.iRequestIdNum = iRequestIdNum;
    }

    @Override
    public void setOFlag(boolean bOFlag) {
        this.bOFlag = bOFlag;
    }

    @Override
    public void setBFlag(boolean bBFlag) {
        this.bBFlag = bBFlag;
    }

    @Override
    public void setRFlag(boolean bRFlag) {
        this.bRFlag = bRFlag;
    }

    @Override
    public void setPriFlag(byte yPriFlag) {
        this.yPriFlag = yPriFlag;
    }

    public PcepObjectHeader getRPObjHeader() {
        return this.rpObjHeader;
    }

    @Override
    public int getRequestIdNum() {
        return this.iRequestIdNum;
    }

    @Override
    public boolean getOFlag() {
        return this.bOFlag;
    }

    @Override
    public boolean getBFlag() {
        return this.bBFlag;
    }

    @Override
    public boolean getRFlag() {
        return this.bRFlag;
    }

    @Override
    public byte getPriFlag() {
        return this.yPriFlag;
    }

    public static PcepRPObject read(ChannelBuffer cb) throws PcepParseException {
        log.debug("read");
        LinkedList<PcepValueType> llOptionalTlv = new LinkedList();
        PcepObjectHeader rpObjHeader = PcepObjectHeader.read(cb);
        ChannelBuffer tempCb = cb.readBytes(rpObjHeader.getObjLen() - 4);
        int iTemp = tempCb.readInt();
        byte yPriFlag = (byte)(iTemp & 7);
        boolean bOFlag = (iTemp & 0x20) == 32;
        boolean bBFlag = (iTemp & 0x10) == 16;
        boolean bRFlag = (iTemp & 8) == 8;
        int iRequestIdNum = tempCb.readInt();
        llOptionalTlv = PcepRPObjectVer1.parseOptionalTlv(tempCb);
        return new PcepRPObjectVer1(rpObjHeader, iRequestIdNum, bOFlag, bBFlag, bRFlag, yPriFlag, llOptionalTlv);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.rpObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException("ObjectLength Index is " + objLenIndex);
        }
        int iTemp = this.yPriFlag;
        iTemp = this.bOFlag ? iTemp | 5 : iTemp;
        iTemp = this.bBFlag ? iTemp | 4 : iTemp;
        iTemp = this.bRFlag ? iTemp | 3 : iTemp;
        cb.writeInt(iTemp);
        cb.writeInt(this.iRequestIdNum);
        this.packOptionalTlv(cb);
        int length = cb.writerIndex() - objStartIndex;
        this.rpObjHeader.setObjLen((short)length);
        cb.setShort(objLenIndex, (int)((short)length));
        return cb.writerIndex();
    }

    protected static LinkedList<PcepValueType> parseOptionalTlv(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOutOptionalTlv = new LinkedList<PcepValueType>();
        return llOutOptionalTlv;
    }

    protected int packOptionalTlv(ChannelBuffer cb) {
        ListIterator listIterator = this.llOptionalTlv.listIterator();
        while (listIterator.hasNext()) {
            ((PcepValueType)listIterator.next()).write(cb);
        }
        return cb.writerIndex();
    }

    @Override
    public LinkedList<PcepValueType> getOptionalTlv() {
        return this.llOptionalTlv;
    }

    @Override
    public void setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
        this.llOptionalTlv = llOptionalTlv;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ObjectHeader", (Object)this.rpObjHeader).add("OFlag", this.bOFlag ? 1 : 0).add("BFlag", this.bBFlag ? 1 : 0).add("RFlag", this.bRFlag ? 1 : 0).add("PriFlag", (int)this.yPriFlag).add("RequestIdNumber", this.iRequestIdNum).add("OptionalTlv", this.llOptionalTlv).toString();
    }

    public static class Builder
    implements PcepRPObject.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsRequestIdNumSet = false;
        private boolean bIsOFlagSet = false;
        private boolean bIsRFlagset = false;
        private boolean bIsBFlagSet = false;
        private boolean bIsPriFlagSet = false;
        private PcepObjectHeader rpObjHeader;
        private int requestIdNum;
        private boolean bOFlag;
        private boolean bBFlag;
        private boolean bRFlag;
        private byte yPriFlag;
        private LinkedList<PcepValueType> llOptionalTlv = new LinkedList();
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepRPObject build() {
            byte yPriFlag;
            PcepObjectHeader lspObjHeader = this.bIsHeaderSet ? this.rpObjHeader : DEFAULT_RP_OBJECT_HEADER;
            int requestIdNum = this.bIsRequestIdNumSet ? this.requestIdNum : 0;
            boolean bOFlag = this.bIsOFlagSet ? this.bOFlag : false;
            boolean bBFlag = this.bIsBFlagSet ? this.bBFlag : false;
            boolean bRFlag = this.bIsRFlagset ? this.bRFlag : false;
            byte by = yPriFlag = this.bIsPriFlagSet ? this.yPriFlag : (byte)0;
            if (this.bIsPFlagSet) {
                lspObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                lspObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepRPObjectVer1(lspObjHeader, requestIdNum, bOFlag, bBFlag, bRFlag, yPriFlag, this.llOptionalTlv);
        }

        @Override
        public PcepObjectHeader getRPObjHeader() {
            return this.rpObjHeader;
        }

        @Override
        public Builder setRPObjHeader(PcepObjectHeader obj) {
            this.rpObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public int getRequestIdNum() {
            return this.requestIdNum;
        }

        @Override
        public Builder setRequestIdNum(int value) {
            this.requestIdNum = value;
            this.bIsRequestIdNumSet = true;
            return this;
        }

        @Override
        public Builder setOFlag(boolean value) {
            this.bOFlag = value;
            this.bIsOFlagSet = true;
            return this;
        }

        @Override
        public boolean getBFlag() {
            return this.bBFlag;
        }

        @Override
        public Builder setBFlag(boolean value) {
            this.bBFlag = value;
            this.bIsBFlagSet = true;
            return this;
        }

        @Override
        public boolean getRFlag() {
            return this.bRFlag;
        }

        @Override
        public Builder setRFlag(boolean value) {
            this.bRFlag = value;
            this.bIsRFlagset = true;
            return this;
        }

        @Override
        public byte getPriFlag() {
            return this.yPriFlag;
        }

        @Override
        public Builder setPriFlag(byte value) {
            this.yPriFlag = value;
            this.bIsPriFlagSet = true;
            return this;
        }

        @Override
        public Builder setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
            this.llOptionalTlv = llOptionalTlv;
            return this;
        }

        @Override
        public LinkedList<PcepValueType> getOptionalTlv() {
            return this.llOptionalTlv;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }

        @Override
        public boolean getOFlag() {
            return this.bOFlag;
        }
    }
}

