/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepAttribute;
import org.onosproject.pcepio.protocol.PcepBandwidthObject;
import org.onosproject.pcepio.protocol.PcepEroObject;
import org.onosproject.pcepio.protocol.PcepLspObject;
import org.onosproject.pcepio.protocol.PcepRroObject;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.protocol.PcepStateReport;
import org.onosproject.pcepio.protocol.ver1.PcepAttributeVer1;
import org.onosproject.pcepio.protocol.ver1.PcepBandwidthObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepEroObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepRroObjectVer1;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepStateReportVer1
implements PcepStateReport {
    protected static final Logger log = LoggerFactory.getLogger(PcepStateReport.class);
    public static final int OBJECT_HEADER_LENGTH = 4;
    private PcepSrpObject srpObject;
    private PcepLspObject lspObject;
    private PcepStateReport.PcepMsgPath msgPath;

    public PcepStateReportVer1() {
        this.srpObject = null;
        this.lspObject = null;
        this.msgPath = null;
    }

    public PcepStateReportVer1(PcepSrpObject srpObject, PcepLspObject lspObject, PcepStateReport.PcepMsgPath msgPath) {
        this.srpObject = srpObject;
        this.lspObject = lspObject;
        this.msgPath = msgPath;
    }

    @Override
    public PcepSrpObject getSrpObject() {
        return this.srpObject;
    }

    @Override
    public PcepLspObject getLspObject() {
        return this.lspObject;
    }

    @Override
    public PcepStateReport.PcepMsgPath getMsgPath() {
        return this.msgPath;
    }

    @Override
    public void setSrpObject(PcepSrpObject srpObj) {
        this.srpObject = srpObj;
    }

    @Override
    public void setLspObject(PcepLspObject lspObject) {
        this.lspObject = lspObject;
    }

    @Override
    public void setMsgPath(PcepStateReport.PcepMsgPath msgPath) {
        this.msgPath = msgPath;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("SrpObject", (Object)this.srpObject).add("LspObject", (Object)this.lspObject).add("MsgPath", (Object)this.msgPath).toString();
    }

    public static class Builder
    implements PcepStateReport.Builder {
        private boolean bIsSRPObjectSet = false;
        private boolean bIsLSPObjectSet = false;
        private boolean bIsPcepMsgPathSet = false;
        private PcepSrpObject srpObject;
        private PcepLspObject lspObject;
        private PcepStateReport.PcepMsgPath msgPath;

        @Override
        public PcepStateReport build() throws PcepParseException {
            PcepSrpObject srpObject = null;
            PcepLspObject lspObject = null;
            PcepStateReport.PcepMsgPath msgPath = null;
            if (this.bIsSRPObjectSet) {
                srpObject = this.srpObject;
            }
            if (!this.bIsLSPObjectSet) {
                throw new PcepParseException(" LSP Object NOT Set while building PcepStateReport.");
            }
            lspObject = this.lspObject;
            if (!this.bIsPcepMsgPathSet) {
                throw new PcepParseException(" Message Path NOT Set while building PcepStateReport.");
            }
            msgPath = this.msgPath;
            return new PcepStateReportVer1(srpObject, lspObject, msgPath);
        }

        @Override
        public PcepSrpObject getSrpObject() {
            return this.srpObject;
        }

        @Override
        public PcepLspObject getLspObject() {
            return this.lspObject;
        }

        @Override
        public PcepStateReport.PcepMsgPath getMsgPath() {
            return this.msgPath;
        }

        @Override
        public Builder setSrpObject(PcepSrpObject srpobj) {
            this.srpObject = srpobj;
            this.bIsSRPObjectSet = true;
            return this;
        }

        @Override
        public Builder setLspObject(PcepLspObject lspObject) {
            this.lspObject = lspObject;
            this.bIsLSPObjectSet = true;
            return this;
        }

        @Override
        public Builder setMsgPath(PcepStateReport.PcepMsgPath msgPath) {
            this.msgPath = msgPath;
            this.bIsPcepMsgPathSet = true;
            return this;
        }
    }

    public class PcepMsgPath
    implements PcepStateReport.PcepMsgPath {
        private PcepEroObject eroObj;
        private boolean isEroObjectSet;
        private PcepAttribute attrList;
        private boolean isAttributeListSet;
        private PcepRroObject rroObj;
        private boolean isRroObjectSet;
        private PcepBandwidthObject bandwidth;
        private boolean isBandwidthObjectSet;

        public PcepMsgPath() {
            this.eroObj = null;
            this.attrList = null;
            this.rroObj = null;
            this.isEroObjectSet = false;
            this.isAttributeListSet = false;
            this.isRroObjectSet = false;
            this.isBandwidthObjectSet = false;
        }

        public PcepMsgPath(PcepEroObject eroObj, PcepAttribute attrList, PcepRroObject rroObj, PcepBandwidthObject bandwidth) {
            this.eroObj = eroObj;
            this.attrList = attrList;
            this.rroObj = rroObj;
            this.bandwidth = bandwidth;
            this.isRroObjectSet = rroObj != null;
            this.isEroObjectSet = eroObj != null;
            this.isAttributeListSet = attrList != null;
            this.isBandwidthObjectSet = bandwidth != null;
        }

        @Override
        public PcepEroObject getEroObject() {
            return this.eroObj;
        }

        @Override
        public PcepAttribute getPcepAttribute() {
            return this.attrList;
        }

        @Override
        public PcepRroObject getRroObject() {
            return this.rroObj;
        }

        @Override
        public PcepBandwidthObject getBandwidthObject() {
            return this.bandwidth;
        }

        @Override
        public void setEroObject(PcepEroObject eroObj) {
            this.eroObj = eroObj;
        }

        @Override
        public void setPcepAttribute(PcepAttribute attrList) {
            this.attrList = attrList;
        }

        @Override
        public void setRroObject(PcepRroObject rroObj) {
            this.rroObj = rroObj;
        }

        @Override
        public void setBandwidthObject(PcepBandwidthObject bandwidth) {
            this.bandwidth = bandwidth;
        }

        @Override
        public PcepMsgPath read(ChannelBuffer bb) throws PcepParseException {
            PcepRroObject rroObj = null;
            PcepBandwidthObject bandwidth = null;
            PcepEroObject eroObj = PcepEroObjectVer1.read(bb);
            PcepAttribute attrList = PcepAttributeVer1.read(bb);
            boolean bBreakWhile = false;
            while (0 < bb.readableBytes() && bb.readableBytes() >= 4) {
                bb.markReaderIndex();
                PcepObjectHeader tempObjHeader = PcepObjectHeader.read(bb);
                bb.resetReaderIndex();
                byte yObjClass = tempObjHeader.getObjClass();
                switch (yObjClass) {
                    case 8: {
                        rroObj = PcepRroObjectVer1.read(bb);
                        break;
                    }
                    case 18: {
                        bb.skipBytes((int)tempObjHeader.getObjLen());
                        break;
                    }
                    case 5: {
                        bandwidth = PcepBandwidthObjectVer1.read(bb);
                        break;
                    }
                    default: {
                        bBreakWhile = true;
                    }
                }
                if (!bBreakWhile) continue;
                break;
            }
            return new PcepMsgPath(eroObj, attrList, rroObj, bandwidth);
        }

        @Override
        public int write(ChannelBuffer bb) throws PcepParseException {
            int iLenStartIndex = bb.writerIndex();
            if (!this.isEroObjectSet) {
                throw new PcepParseException("Ero object is not set in path");
            }
            this.eroObj.write(bb);
            if (this.isAttributeListSet) {
                this.attrList.write(bb);
            }
            if (this.isRroObjectSet) {
                this.rroObj.write(bb);
                if (this.isBandwidthObjectSet) {
                    this.bandwidth.write(bb);
                }
            }
            return bb.writerIndex() - iLenStartIndex;
        }

        public String toString() {
            MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper(this.getClass());
            if (this.attrList != null) {
                toStrHelper.add("AttributeList", (Object)this.attrList);
            }
            if (this.rroObj instanceof PcepRroObjectVer1) {
                toStrHelper.add("RroObject", (Object)this.rroObj);
            }
            if (this.bandwidth instanceof PcepBandwidthObjectVer1) {
                toStrHelper.add("bandwidthObject", (Object)this.bandwidth);
            }
            return toStrHelper.toString();
        }
    }
}

