/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepLspObject;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepMessageWriter;
import org.onosproject.pcepio.protocol.PcepMsgPath;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepUpdateMsg;
import org.onosproject.pcepio.protocol.PcepUpdateRequest;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.protocol.ver1.PcepLspObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepMsgPathVer1;
import org.onosproject.pcepio.protocol.ver1.PcepSrpObjectVer1;
import org.onosproject.pcepio.protocol.ver1.PcepUpdateRequestVer1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PcepUpdateMsgVer1
implements PcepUpdateMsg {
    protected static final Logger log = LoggerFactory.getLogger(PcepUpdateMsgVer1.class);
    public static final byte PACKET_VERSION = 1;
    public static final short PACKET_MINIMUM_LENGTH = 36;
    public static final PcepType MSG_TYPE = PcepType.UPDATE;
    private LinkedList<PcepUpdateRequest> llUpdateRequestList;
    public static final Reader READER = new Reader();
    static final Writer WRITER = new Writer();

    PcepUpdateMsgVer1(LinkedList<PcepUpdateRequest> llUpdateRequestList) {
        this.llUpdateRequestList = llUpdateRequestList;
    }

    @Override
    public void writeTo(ChannelBuffer cb) throws PcepParseException {
        WRITER.write(cb, this);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public PcepType getType() {
        return MSG_TYPE;
    }

    @Override
    public LinkedList<PcepUpdateRequest> getUpdateRequestList() {
        return this.llUpdateRequestList;
    }

    @Override
    public void setUpdateRequestList(LinkedList<PcepUpdateRequest> llUpdateRequestList) {
        this.llUpdateRequestList = llUpdateRequestList;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("UpdateRequestList", this.llUpdateRequestList).toString();
    }

    static class Writer
    implements PcepMessageWriter<PcepUpdateMsgVer1> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer cb, PcepUpdateMsgVer1 message) throws PcepParseException {
            int startIndex = cb.writerIndex();
            cb.writeByte(32);
            cb.writeByte((int)MSG_TYPE.getType());
            int msgLenIndex = cb.writerIndex();
            cb.writeShort(0);
            ListIterator listIterator = message.llUpdateRequestList.listIterator();
            while (listIterator.hasNext()) {
                PcepUpdateRequest updateReq = (PcepUpdateRequest)listIterator.next();
                PcepSrpObject srpObj = updateReq.getSrpObject();
                srpObj.write(cb);
                PcepLspObject lspObj = updateReq.getLspObject();
                lspObj.write(cb);
                PcepMsgPath msgPath = updateReq.getMsgPath();
                msgPath.write(cb);
            }
            int length = cb.writerIndex() - startIndex;
            cb.setShort(msgLenIndex, (int)((short)length));
        }
    }

    static class Builder
    implements PcepUpdateMsg.Builder {
        LinkedList<PcepUpdateRequest> llUpdateRequestList;

        Builder() {
        }

        @Override
        public PcepVersion getVersion() {
            return PcepVersion.PCEP_1;
        }

        @Override
        public PcepType getType() {
            return PcepType.UPDATE;
        }

        @Override
        public PcepUpdateMsg build() {
            return new PcepUpdateMsgVer1(this.llUpdateRequestList);
        }

        @Override
        public LinkedList<PcepUpdateRequest> getUpdateRequestList() {
            return this.llUpdateRequestList;
        }

        @Override
        public Builder setUpdateRequestList(LinkedList<PcepUpdateRequest> llUpdateRequestList) {
            this.llUpdateRequestList = llUpdateRequestList;
            return this;
        }
    }

    static class Reader
    implements PcepMessageReader<PcepUpdateMsg> {
        LinkedList<PcepUpdateRequest> llUpdateRequestList;

        Reader() {
        }

        @Override
        public PcepUpdateMsg readFrom(ChannelBuffer cb) throws PcepParseException {
            if (cb.readableBytes() < 36) {
                throw new PcepParseException("Readable bytes is less than update message minimum length");
            }
            this.llUpdateRequestList = new LinkedList();
            byte version = cb.readByte();
            if ((version = (byte)(version >> 5)) != 1) {
                throw new PcepParseException("Wrong version. Expected=PcepVersion.PCEP_1(1), got=" + version);
            }
            byte type = cb.readByte();
            if (type != MSG_TYPE.getType()) {
                throw new PcepParseException("Wrong type. Expected=PcepType.UPDATE(11), got=" + type);
            }
            short length = cb.readShort();
            if (length < 36) {
                throw new PcepParseException("Wrong length. Expected to be >= 36, was: " + length);
            }
            log.debug("reading update message of length " + length);
            if (!this.parseUpdateRequestList(cb)) {
                throw new PcepParseException("parsing Update Request List Failed.");
            }
            return new PcepUpdateMsgVer1(this.llUpdateRequestList);
        }

        public boolean parseUpdateRequestList(ChannelBuffer cb) throws PcepParseException {
            while (0 < cb.readableBytes()) {
                PcepUpdateRequestVer1 pceUpdateReq = new PcepUpdateRequestVer1();
                PcepSrpObject srpObj = PcepSrpObjectVer1.read(cb);
                pceUpdateReq.setSrpObject(srpObj);
                PcepLspObject lspObj = PcepLspObjectVer1.read(cb);
                pceUpdateReq.setLspObject(lspObj);
                PcepMsgPath msgPath = new PcepMsgPathVer1().read(cb);
                pceUpdateReq.setMsgPath(msgPath);
                this.llUpdateRequestList.add(pceUpdateReq);
            }
            return true;
        }
    }
}

