/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutonomousSystemTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(AutonomousSystemTlv.class);
    public static final short TYPE = 100;
    public static final short LENGTH = 4;
    private final int rawValue;

    public AutonomousSystemTlv(int rawValue) {
        this.rawValue = rawValue;
    }

    public static AutonomousSystemTlv of(int raw) {
        return new AutonomousSystemTlv(raw);
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 100;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        return Objects.hash(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AutonomousSystemTlv) {
            AutonomousSystemTlv other = (AutonomousSystemTlv)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(100);
        c.writeShort(4);
        c.writeInt(this.rawValue);
        return c.writerIndex() - iLenStartIndex;
    }

    public static AutonomousSystemTlv read(ChannelBuffer c) {
        return AutonomousSystemTlv.of(c.readInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("TYPE", 100).add("Length", 4).add("value", this.rawValue).toString();
    }
}

