/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv6TERouterIdofLocalNodeTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(IPv6TERouterIdofLocalNodeTlv.class);
    public static final short TYPE = 140;
    public static final short LENGTH = 20;
    public static final byte VALUE_LENGTH = 18;
    private static final byte[] NONE_VAL = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final IPv6TERouterIdofLocalNodeTlv NONE = new IPv6TERouterIdofLocalNodeTlv(NONE_VAL);
    private static final byte[] NO_MASK_VAL = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final IPv6TERouterIdofLocalNodeTlv NO_MASK = new IPv6TERouterIdofLocalNodeTlv(NO_MASK_VAL);
    public static final IPv6TERouterIdofLocalNodeTlv FULL_MASK = NONE;
    private final byte[] rawValue;

    public IPv6TERouterIdofLocalNodeTlv(byte[] rawValue) {
        this.rawValue = rawValue;
    }

    public static IPv6TERouterIdofLocalNodeTlv of(byte[] raw) {
        boolean bFoundNONE = true;
        for (int i = 2; i < 20; ++i) {
            if (NONE_VAL[i] == raw[i]) continue;
            bFoundNONE = false;
        }
        if (bFoundNONE) {
            return NONE;
        }
        boolean bFoundNoMask = true;
        for (int i = 2; i < 20; ++i) {
            if (255 == raw[i]) continue;
            bFoundNoMask = false;
        }
        if (bFoundNoMask) {
            return NO_MASK;
        }
        return new IPv6TERouterIdofLocalNodeTlv(raw);
    }

    public byte[] getBytes() {
        return this.rawValue;
    }

    public byte[] getValue() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 140;
    }

    @Override
    public short getLength() {
        return 20;
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IPv6TERouterIdofLocalNodeTlv) {
            IPv6TERouterIdofLocalNodeTlv other = (IPv6TERouterIdofLocalNodeTlv)obj;
            return Arrays.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iStartIndex = c.writerIndex();
        c.writeShort(140);
        c.writeShort(20);
        c.writeBytes(this.rawValue);
        return c.writerIndex() - iStartIndex;
    }

    public static IPv6TERouterIdofLocalNodeTlv read20Bytes(ChannelBuffer c) {
        byte[] yTemp = new byte[20];
        c.readBytes(yTemp, 0, 20);
        return IPv6TERouterIdofLocalNodeTlv.of(yTemp);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper(this.getClass());
        toStrHelper.add("Type", 140);
        toStrHelper.add("Length", 20);
        StringBuffer result = new StringBuffer();
        for (byte b : this.rawValue) {
            result.append(String.format("%02X ", b));
        }
        toStrHelper.add("Value", (Object)result);
        return toStrHelper.toString();
    }
}

