/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkNameTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(LinkNameTlv.class);
    public static final short TYPE = 1098;
    private short hLength;
    private final byte[] rawValue;

    public LinkNameTlv(byte[] rawValue, short hLength) {
        this.rawValue = rawValue;
        this.hLength = 0 == hLength ? (short)rawValue.length : hLength;
    }

    public static LinkNameTlv of(byte[] raw, short hLength) {
        return new LinkNameTlv(raw, hLength);
    }

    public byte[] getValue() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 1098;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinkNameTlv) {
            LinkNameTlv other = (LinkNameTlv)obj;
            return Arrays.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(1098);
        c.writeShort((int)this.hLength);
        c.writeBytes(this.rawValue);
        return c.writerIndex() - iLenStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short hLength) {
        byte[] linkName = new byte[hLength];
        c.readBytes(linkName, 0, (int)hLength);
        return new LinkNameTlv(linkName, hLength);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper(this.getClass());
        toStrHelper.add("Type", 1098);
        toStrHelper.add("Length", (int)this.hLength);
        StringBuffer result = new StringBuffer();
        for (byte b : this.rawValue) {
            result.append(String.format("%02X ", b));
        }
        toStrHelper.add("Value", (Object)result);
        return toStrHelper.toString();
    }
}

