/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeFlagBitsTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(NodeFlagBitsTlv.class);
    public static final short TYPE = 14;
    public static final short LENGTH = 1;
    public static final int SET = 1;
    public static final byte OFLAG_SET = -128;
    public static final byte TFLAG_SET = 64;
    public static final byte EFLAG_SET = 32;
    public static final byte BFLAG_SET = 16;
    private final byte rawValue;
    private final boolean bOFlag;
    private final boolean bTFlag;
    private final boolean bEFlag;
    private final boolean bBFlag;
    private final boolean isRawValueSet;

    public NodeFlagBitsTlv(byte rawValue) {
        this.rawValue = rawValue;
        this.isRawValueSet = true;
        this.bOFlag = (rawValue & 0xFFFFFF80) == -128;
        this.bTFlag = (rawValue & 0x40) == 64;
        this.bEFlag = (rawValue & 0x20) == 32;
        this.bBFlag = (rawValue & 0x10) == 16;
    }

    public NodeFlagBitsTlv(boolean bOFlag, boolean bTFlag, boolean bEFlag, boolean bBFlag) {
        this.bOFlag = bOFlag;
        this.bTFlag = bTFlag;
        this.bEFlag = bEFlag;
        this.bBFlag = bBFlag;
        this.rawValue = 0;
        this.isRawValueSet = false;
    }

    public static NodeFlagBitsTlv of(byte raw) {
        return new NodeFlagBitsTlv(raw);
    }

    public byte getbyte() {
        return this.rawValue;
    }

    public boolean getOFlag() {
        return this.bOFlag;
    }

    public boolean getTFlag() {
        return this.bTFlag;
    }

    public boolean getEFlag() {
        return this.bEFlag;
    }

    public boolean getBFlag() {
        return this.bBFlag;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 14;
    }

    @Override
    public short getLength() {
        return 1;
    }

    public int hashCode() {
        if (this.isRawValueSet) {
            return Objects.hash(this.rawValue);
        }
        return Objects.hash(this.bOFlag, this.bTFlag, this.bEFlag, this.bBFlag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeFlagBitsTlv) {
            NodeFlagBitsTlv other = (NodeFlagBitsTlv)obj;
            if (this.isRawValueSet) {
                return Objects.equals(this.rawValue, other.rawValue);
            }
            return Objects.equals(this.bOFlag, other.bOFlag) && Objects.equals(this.bTFlag, other.bTFlag) && Objects.equals(this.bEFlag, other.bEFlag) && Objects.equals(this.bBFlag, other.bBFlag);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(14);
        c.writeShort(1);
        if (this.isRawValueSet) {
            c.writeByte((int)this.rawValue);
        } else {
            int temp = 0;
            if (this.bOFlag) {
                temp = (byte)(temp | 0xFFFFFF80);
            }
            if (this.bTFlag) {
                temp = (byte)(temp | 0x40);
            }
            if (this.bEFlag) {
                temp = (byte)(temp | 0x20);
            }
            if (this.bBFlag) {
                temp = (byte)(temp | 0x10);
            }
            c.writeByte(temp);
        }
        return c.writerIndex() - iLenStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c) {
        return NodeFlagBitsTlv.of(c.readByte());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 14).add("Length", 1).add("OFlag", this.bOFlag ? 1 : 0).add("TFlag", this.bTFlag ? 1 : 0).add("EFlag", this.bEFlag ? 1 : 0).add("BFlag", this.bBFlag ? 1 : 0).toString();
    }
}

