/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepNai;

public class PcepNaiUnnumberedAdjacencyIpv4
implements PcepNai {
    public static final byte ST_TYPE = 5;
    private final int localNodeId;
    private final int localInterfaceId;
    private final int remoteNodeId;
    private final int remoteInterfaceId;

    public PcepNaiUnnumberedAdjacencyIpv4(int localNodeId, int localInterfaceId, int remoteNodeId, int remoteInterfaceId) {
        this.localNodeId = localNodeId;
        this.localInterfaceId = localInterfaceId;
        this.remoteNodeId = remoteNodeId;
        this.remoteInterfaceId = remoteInterfaceId;
    }

    public static PcepNaiUnnumberedAdjacencyIpv4 of(int localNodeId, int localInterfaceId, int remoteNodeId, int remoteInterfaceId) {
        return new PcepNaiUnnumberedAdjacencyIpv4(localNodeId, localInterfaceId, remoteNodeId, remoteInterfaceId);
    }

    @Override
    public byte getType() {
        return 5;
    }

    @Override
    public int write(ChannelBuffer bb) {
        int iLenStartIndex = bb.writerIndex();
        bb.writeInt(this.localNodeId);
        bb.writeInt(this.localInterfaceId);
        bb.writeInt(this.remoteNodeId);
        bb.writeInt(this.remoteInterfaceId);
        return bb.writerIndex() - iLenStartIndex;
    }

    public static PcepNaiUnnumberedAdjacencyIpv4 read(ChannelBuffer bb) {
        int localNodeId = bb.readInt();
        int localInterfaceId = bb.readInt();
        int remoteNodeId = bb.readInt();
        int remoteInterfaceId = bb.readInt();
        return new PcepNaiUnnumberedAdjacencyIpv4(localNodeId, localInterfaceId, remoteNodeId, remoteInterfaceId);
    }

    public int hashCode() {
        return Objects.hash(this.localNodeId, this.localInterfaceId, this.remoteNodeId, this.remoteInterfaceId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PcepNaiUnnumberedAdjacencyIpv4) {
            PcepNaiUnnumberedAdjacencyIpv4 other = (PcepNaiUnnumberedAdjacencyIpv4)obj;
            return Objects.equals(this.localNodeId, other.localNodeId) && Objects.equals(this.localInterfaceId, other.localInterfaceId) && Objects.equals(this.remoteNodeId, other.remoteNodeId) && Objects.equals(this.remoteInterfaceId, other.remoteInterfaceId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("localNodeId", this.localNodeId).add("localInterfaceId", this.localInterfaceId).add("remoteNodeId", this.remoteNodeId).add("remoteInterfaceId", this.remoteInterfaceId).toString();
    }
}

