/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.AutonomousSystemTlv;
import org.onosproject.pcepio.types.BGPLSidentifierTlv;
import org.onosproject.pcepio.types.OSPFareaIDsubTlv;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.RouterIDSubTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTENodeDescriptorsTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(RemoteTENodeDescriptorsTlv.class);
    public static final short TYPE = 1003;
    public short hLength;
    public static final int TLV_HEADER_LENGTH = 4;
    private LinkedList<PcepValueType> llRemoteTENodeDescriptorSubTLVs;

    public RemoteTENodeDescriptorsTlv(LinkedList<PcepValueType> llRemoteTENodeDescriptorSubTLVs) {
        this.llRemoteTENodeDescriptorSubTLVs = llRemoteTENodeDescriptorSubTLVs;
    }

    public static RemoteTENodeDescriptorsTlv of(LinkedList<PcepValueType> llRemoteTENodeDescriptorSubTLVs) {
        return new RemoteTENodeDescriptorsTlv(llRemoteTENodeDescriptorSubTLVs);
    }

    public LinkedList<PcepValueType> getllRemoteTENodeDescriptorSubTLVs() {
        return this.llRemoteTENodeDescriptorSubTLVs;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 1003;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(this.llRemoteTENodeDescriptorSubTLVs.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RemoteTENodeDescriptorsTlv) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            RemoteTENodeDescriptorsTlv other = (RemoteTENodeDescriptorsTlv)obj;
            Iterator objListIterator = ((RemoteTENodeDescriptorsTlv)obj).llRemoteTENodeDescriptorSubTLVs.iterator();
            countObjSubTlv = ((RemoteTENodeDescriptorsTlv)obj).llRemoteTENodeDescriptorSubTLVs.size();
            if (countObjSubTlv != (countOtherSubTlv = other.llRemoteTENodeDescriptorSubTLVs.size())) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                PcepValueType subTlv = (PcepValueType)objListIterator.next();
                isCommonSubTlv = Objects.equals(this.llRemoteTENodeDescriptorSubTLVs.contains(subTlv), other.llRemoteTENodeDescriptorSubTLVs.contains(subTlv));
            }
            return isCommonSubTlv;
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int tlvStartIndex = c.writerIndex();
        c.writeShort(1003);
        int tlvLenIndex = c.writerIndex();
        this.hLength = 0;
        c.writeShort((int)this.hLength);
        ListIterator listIterator = this.llRemoteTENodeDescriptorSubTLVs.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            if (tlv == null) {
                log.debug("TLV is null from subTlv list");
                continue;
            }
            tlv.write(c);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                c.writeByte(0);
            }
        }
        this.hLength = (short)(c.writerIndex() - tlvStartIndex);
        c.setShort(tlvLenIndex, this.hLength - 4);
        return c.writerIndex() - tlvStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short length) throws PcepParseException {
        LinkedList<PcepValueType> llRemoteTENodeDescriptorSubTLVs = new LinkedList<PcepValueType>();
        ChannelBuffer tempCb = c.readBytes((int)length);
        while (4 <= tempCb.readableBytes()) {
            PcepValueType tlv;
            short hType = tempCb.readShort();
            int iValue = 0;
            short hLength = tempCb.readShort();
            switch (hType) {
                case 100: {
                    iValue = tempCb.readInt();
                    tlv = new AutonomousSystemTlv(iValue);
                    break;
                }
                case 17: {
                    iValue = tempCb.readInt();
                    tlv = new BGPLSidentifierTlv(iValue);
                    break;
                }
                case 600: {
                    iValue = tempCb.readInt();
                    tlv = new OSPFareaIDsubTlv(iValue);
                    break;
                }
                case 1000: {
                    tlv = RouterIDSubTlv.read(tempCb, hLength);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported Sub TLV type :" + hType);
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= tempCb.readableBytes()) {
                tempCb.skipBytes(pad);
            }
            llRemoteTENodeDescriptorSubTLVs.add(tlv);
        }
        if (0 < tempCb.readableBytes()) {
            throw new PcepParseException("Sub Tlv parsing error. Extra bytes received.");
        }
        return new RemoteTENodeDescriptorsTlv(llRemoteTENodeDescriptorSubTLVs);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 1003).add("Length", (int)this.hLength).add("RemoteTeNodeDescriptorSubTLVs", this.llRemoteTENodeDescriptorSubTLVs).toString();
    }
}

