/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepNai;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepNaiIpv4Adjacency;
import org.onosproject.pcepio.types.PcepNaiIpv4NodeId;
import org.onosproject.pcepio.types.PcepNaiIpv6Adjacency;
import org.onosproject.pcepio.types.PcepNaiIpv6NodeId;
import org.onosproject.pcepio.types.PcepNaiUnnumberedAdjacencyIpv4;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrEroSubObject
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(SrEroSubObject.class);
    public static final short TYPE = 96;
    public static final short LENGTH = 12;
    public static final short VALUE_LENGTH = 10;
    public static final int SET = 1;
    public static final byte MFLAG_SET = 1;
    public static final byte CFLAG_SET = 2;
    public static final byte SFLAG_SET = 4;
    public static final byte FFLAG_SET = 8;
    public static final byte SHIFT_ST = 12;
    private final boolean bFFlag;
    private final boolean bSFlag;
    private final boolean bCFlag;
    private final boolean bMFlag;
    private final byte st;
    private final int sID;
    private final PcepNai nai;

    public SrEroSubObject(byte st, boolean bFFlag, boolean bSFlag, boolean bCFlag, boolean bMFlag, int sID, PcepNai nai) {
        this.st = st;
        this.bFFlag = bFFlag;
        this.bSFlag = bSFlag;
        this.bCFlag = bCFlag;
        this.bMFlag = bMFlag;
        this.sID = sID;
        this.nai = nai;
    }

    public static SrEroSubObject of(byte st, boolean bFFlag, boolean bSFlag, boolean bCFlag, boolean bMFlag, int sID, PcepNai nai) {
        return new SrEroSubObject(st, bFFlag, bSFlag, bCFlag, bMFlag, sID, nai);
    }

    public byte getSt() {
        return this.st;
    }

    public boolean getFFlag() {
        return this.bFFlag;
    }

    public boolean getSFlag() {
        return this.bSFlag;
    }

    public boolean getCFlag() {
        return this.bCFlag;
    }

    public boolean getMFlag() {
        return this.bMFlag;
    }

    public int getSID() {
        return this.sID;
    }

    public PcepNai getNai() {
        return this.nai;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 96;
    }

    @Override
    public short getLength() {
        return 12;
    }

    public int hashCode() {
        return Objects.hash(this.st, this.bFFlag, this.bSFlag, this.bCFlag, this.bMFlag, this.sID, this.nai);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SrEroSubObject) {
            SrEroSubObject other = (SrEroSubObject)obj;
            return Objects.equals(this.st, other.st) && Objects.equals(this.bFFlag, other.bFFlag) && Objects.equals(this.bSFlag, other.bSFlag) && Objects.equals(this.bCFlag, other.bCFlag) && Objects.equals(this.bMFlag, other.bMFlag) && Objects.equals(this.sID, other.sID) && Objects.equals(this.nai, other.nai);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(96);
        c.writeShort(12);
        short temp = 0;
        if (this.bMFlag) {
            temp = (short)(temp | 1);
        }
        if (this.bCFlag) {
            temp = (short)(temp | 2);
        }
        if (this.bSFlag) {
            temp = (short)(temp | 4);
        }
        if (this.bFFlag) {
            temp = (short)(temp | 8);
        }
        short tempST = (short)(this.st << 12);
        temp = (short)(temp | tempST);
        c.writeShort((int)temp);
        c.writeInt(this.sID);
        this.nai.write(c);
        return c.writerIndex() - iLenStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c) {
        short temp = c.readShort();
        PcepNai nai = null;
        boolean bMFlag = (temp & 1) == 1;
        boolean bCFlag = (temp & 2) == 2;
        boolean bSFlag = (temp & 4) == 4;
        boolean bFFlag = (temp & 8) == 8;
        byte st = (byte)(temp >> 12);
        int sID = c.readInt();
        switch (st) {
            case 1: {
                nai = PcepNaiIpv4NodeId.read(c);
                break;
            }
            case 2: {
                nai = PcepNaiIpv6NodeId.read(c);
                break;
            }
            case 3: {
                nai = PcepNaiIpv4Adjacency.read(c);
                break;
            }
            case 4: {
                nai = PcepNaiIpv6Adjacency.read(c);
                break;
            }
            case 5: {
                nai = PcepNaiUnnumberedAdjacencyIpv4.read(c);
                break;
            }
            default: {
                nai = null;
            }
        }
        return new SrEroSubObject(st, bFFlag, bSFlag, bCFlag, bMFlag, sID, nai);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 96).add("Length", 12).add("st", (int)this.st).add("bFflag", this.bFFlag).add("bSFlag", this.bSFlag).add("bCFlag", this.bCFlag).add("bMFlag", this.bMFlag).add("sID", this.sID).add("nAI", (Object)this.nai).toString();
    }
}

