/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulLspDbVerTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(StatefulLspDbVerTlv.class);
    public static final short TYPE = 23;
    public static final short LENGTH = 8;
    private final long rawValue;

    public StatefulLspDbVerTlv(long rawValue) {
        this.rawValue = rawValue;
    }

    public static StatefulLspDbVerTlv of(long raw) {
        return new StatefulLspDbVerTlv(raw);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    public long getLong() {
        return this.rawValue;
    }

    @Override
    public short getLength() {
        return 8;
    }

    @Override
    public short getType() {
        return 23;
    }

    public int hashCode() {
        return Objects.hash(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StatefulLspDbVerTlv) {
            StatefulLspDbVerTlv other = (StatefulLspDbVerTlv)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        c.writeShort(23);
        c.writeShort(8);
        c.writeLong(this.rawValue);
        return c.writerIndex();
    }

    public static StatefulLspDbVerTlv read(ChannelBuffer c) {
        return StatefulLspDbVerTlv.of(c.readLong());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 23).add("Length", 8).add("Value", this.rawValue).toString();
    }
}

