/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.IPv4InterfaceAddressTlv;
import org.onosproject.pcepio.types.IPv4NeighborAddressTlv;
import org.onosproject.pcepio.types.IPv6InterfaceAddressTlv;
import org.onosproject.pcepio.types.IPv6NeighborAddressTlv;
import org.onosproject.pcepio.types.LinkLocalRemoteIdentifiersTlv;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TELinkDescriptorsTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(TELinkDescriptorsTlv.class);
    public static final short TYPE = 1070;
    public short hLength;
    public static final int TLV_HEADER_LENGTH = 4;
    private LinkedList<PcepValueType> llLinkDescriptorsSubTLVs;

    public TELinkDescriptorsTlv(LinkedList<PcepValueType> llLinkDescriptorsSubTLVs) {
        this.llLinkDescriptorsSubTLVs = llLinkDescriptorsSubTLVs;
    }

    public static TELinkDescriptorsTlv of(LinkedList<PcepValueType> llLinkDescriptorsSubTLVs) {
        return new TELinkDescriptorsTlv(llLinkDescriptorsSubTLVs);
    }

    public LinkedList<PcepValueType> getllLinkDescriptorsSubTLVs() {
        return this.llLinkDescriptorsSubTLVs;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 1070;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(this.llLinkDescriptorsSubTLVs.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TELinkDescriptorsTlv) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            TELinkDescriptorsTlv other = (TELinkDescriptorsTlv)obj;
            Iterator objListIterator = ((TELinkDescriptorsTlv)obj).llLinkDescriptorsSubTLVs.iterator();
            countObjSubTlv = ((TELinkDescriptorsTlv)obj).llLinkDescriptorsSubTLVs.size();
            if (countObjSubTlv != (countOtherSubTlv = other.llLinkDescriptorsSubTLVs.size())) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                PcepValueType subTlv = (PcepValueType)objListIterator.next();
                isCommonSubTlv = Objects.equals(this.llLinkDescriptorsSubTLVs.contains(subTlv), other.llLinkDescriptorsSubTLVs.contains(subTlv));
            }
            return isCommonSubTlv;
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int tlvStartIndex = c.writerIndex();
        c.writeShort(1070);
        int tlvLenIndex = c.writerIndex();
        this.hLength = 0;
        c.writeShort((int)this.hLength);
        ListIterator listIterator = this.llLinkDescriptorsSubTLVs.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            tlv.write(c);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                c.writeByte(0);
            }
        }
        this.hLength = (short)(c.writerIndex() - tlvStartIndex);
        c.setShort(tlvLenIndex, this.hLength - 4);
        return c.writerIndex() - tlvStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short length) throws PcepParseException {
        LinkedList<PcepValueType> llLinkDescriptorsSubTLVs = new LinkedList<PcepValueType>();
        ChannelBuffer tempCb = c.readBytes((int)length);
        while (4 <= tempCb.readableBytes()) {
            PcepValueType tlv;
            short hType = tempCb.readShort();
            int iValue = 0;
            short hLength = tempCb.readShort();
            log.debug("sub Tlv Length" + hLength);
            switch (hType) {
                case 4: {
                    tlv = LinkLocalRemoteIdentifiersTlv.read(tempCb);
                    break;
                }
                case 6: {
                    iValue = tempCb.readInt();
                    tlv = new IPv4InterfaceAddressTlv(iValue);
                    break;
                }
                case 8: {
                    iValue = tempCb.readInt();
                    tlv = new IPv4NeighborAddressTlv(iValue);
                    break;
                }
                case 12: {
                    byte[] ipv6Value = new byte[18];
                    tempCb.readBytes(ipv6Value, 0, 18);
                    tlv = new IPv6InterfaceAddressTlv(ipv6Value);
                    break;
                }
                case 13: {
                    byte[] ipv6NeighborAdd = new byte[18];
                    tempCb.readBytes(ipv6NeighborAdd, 0, 18);
                    tlv = new IPv6NeighborAddressTlv(ipv6NeighborAdd);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported Sub TLV type:" + hType);
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= tempCb.readableBytes()) {
                tempCb.skipBytes(pad);
            }
            llLinkDescriptorsSubTLVs.add(tlv);
        }
        if (0 < tempCb.readableBytes()) {
            throw new PcepParseException("Sub Tlv parsing error. Extra bytes received.");
        }
        return new TELinkDescriptorsTlv(llLinkDescriptorsSubTLVs);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 1070).add("Length", (int)this.hLength).add("LinkDescriptorsSubTLVs", this.llLinkDescriptorsSubTLVs).toString();
    }
}

