/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Test;
import org.onosproject.pcepio.exceptions.PcepOutOfBoundMessageException;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFactories;
import org.onosproject.pcepio.protocol.PcepLSReportMsg;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepMessageReader;

public class PcepLSReportMsgTest {
    @Test
    public void lsReportMessageTest1() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 44, -32, 16, 0, 40, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 8, 0, 1, 0, 4, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest2() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 44, -32, 16, 0, 40, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 8, 0, 1, 0, 4, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest3() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 32, -32, 16, 0, 28, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest4() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 72, -32, 16, 0, 68, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest5() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 64, -32, 16, 0, 60, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 28, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest6() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 56, -32, 16, 0, 52, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 20, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest7() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 48, -32, 16, 0, 44, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 12, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest8() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 36, -32, 16, 0, 32, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest9() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 112, -32, 16, 0, 108, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest10() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 104, -32, 16, 0, 100, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 28, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest11() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 96, -32, 16, 0, 92, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 20, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest12() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 88, -32, 16, 0, 84, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 12, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest13() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 76, -32, 16, 0, 72, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest14() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, -112, -32, 16, 0, -116, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 4, 0, 28, 0, 6, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 7, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest15() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, -124, -32, 16, 0, -128, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 4, 0, 16, 0, 7, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest16() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 124, -32, 16, 0, 120, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 4, 0, 8, 0, 8, 0, 4, 1, 17, 1, 16};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest17() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, 116, -32, 16, 0, 112, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 4, 0, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest18() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, -60, -32, 16, 0, -64, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 4, 0, 28, 0, 6, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 7, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, -1, 5, 0, 48, 0, 13, 0, 1, -112, 0, 0, 0, 0, 14, 0, 4, 1, 17, 1, 16, 0, 15, 0, 8, 8, 0, 1, 9, 8, 0, 1, 9, 0, 16, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, 17, 0, 4, 0, 1, 1, 2};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest19() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, -60, -32, 16, 0, -64, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 4, 0, 28, 0, 6, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 7, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, -1, 5, 0, 48, 0, 13, 0, 1, -112, 0, 0, 0, 0, 14, 0, 4, 1, 17, 1, 16, 0, 15, 0, 8, 8, 0, 1, 9, 8, 0, 1, 9, 0, 16, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, 17, 0, 4, 0, 1, 1, 2};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest20() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, -68, -32, 16, 0, -72, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 4, 0, 28, 0, 6, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 7, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, -1, 5, 0, 40, 0, 14, 0, 4, 1, 17, 1, 16, 0, 15, 0, 8, 8, 0, 1, 9, 8, 0, 1, 9, 0, 16, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, 17, 0, 4, 0, 1, 1, 2};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest21() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, -80, -32, 16, 0, -84, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 4, 0, 28, 0, 6, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 7, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, -1, 5, 0, 28, 0, 14, 0, 4, 1, 17, 1, 16, 0, 16, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, 17, 0, 4, 0, 1, 1, 2};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest22() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 1, 24, -32, 16, 1, 20, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 4, 0, 28, 0, 6, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 7, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, -1, 5, 0, 28, 0, 14, 0, 4, 1, 17, 1, 16, 0, 16, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, 17, 0, 4, 0, 1, 1, 2, -1, 6, 0, 100, 0, 19, 0, 4, 0, 7, 8, 0, 0, 22, 0, 4, 0, 9, 8, 0, 0, 23, 0, 4, 0, 9, 0, 0, 0, 24, 0, 4, 0, 16, 0, 0, 0, 25, 0, 4, 0, 0, -112, 0, 0, 26, 0, 4, 0, -103, 9, 0, 0, 27, 0, 2, 9, 0, 0, 0, 0, 28, 0, 1, -128, 0, 0, 0, 0, 29, 0, 4, 9, -119, 7, 0, 0, 30, 0, 4, 4, 71, 0, 3, 0, 31, 0, 8, 4, 73, 0, 4, 4, 71, 0, 3, 0, 32, 0, 4, 4, 71, 0, 3};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest23() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 1, 16, -32, 16, 1, 12, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 4, 0, 28, 0, 6, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 7, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, -1, 5, 0, 28, 0, 14, 0, 4, 1, 17, 1, 16, 0, 16, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, 17, 0, 4, 0, 1, 1, 2, -1, 6, 0, 92, 0, 19, 0, 4, 0, 7, 8, 0, 0, 22, 0, 4, 0, 9, 8, 0, 0, 23, 0, 4, 0, 9, 0, 0, 0, 24, 0, 4, 0, 16, 0, 0, 0, 25, 0, 4, 0, 0, -112, 0, 0, 26, 0, 4, 0, -103, 9, 0, 0, 27, 0, 2, 9, 0, 0, 0, 0, 28, 0, 1, -128, 0, 0, 0, 0, 29, 0, 4, 9, -119, 7, 0, 0, 30, 0, 4, 4, 71, 0, 3, 0, 31, 0, 8, 4, 73, 0, 4, 4, 71, 0, 3};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest24() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 1, 8, -32, 16, 1, 4, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 4, 0, 28, 0, 6, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 7, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, -1, 5, 0, 28, 0, 14, 0, 4, 1, 17, 1, 16, 0, 16, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, 17, 0, 4, 0, 1, 1, 2, -1, 6, 0, 84, 0, 19, 0, 4, 0, 7, 8, 0, 0, 22, 0, 4, 0, 9, 8, 0, 0, 23, 0, 4, 0, 9, 0, 0, 0, 24, 0, 4, 0, 16, 0, 0, 0, 25, 0, 4, 0, 0, -112, 0, 0, 26, 0, 4, 0, -103, 9, 0, 0, 27, 0, 2, 9, 0, 0, 0, 0, 28, 0, 1, -128, 0, 0, 0, 0, 29, 0, 4, 9, -119, 7, 0, 0, 30, 0, 8, 4, 71, 0, 3, 4, 71, 0, 3};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }

    @Test
    public void lsReportMessageTest25() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] lsReportMsg = new byte[]{32, -32, 0, -4, -32, 16, 0, -8, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 16, -1, 1, 0, 8, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 3, 0, 36, 0, 1, 0, 4, 0, 0, 0, 17, 0, 2, 0, 4, 0, 0, 0, 17, 0, 3, 0, 4, 0, 0, 0, 17, 0, 4, 0, 8, 0, 0, 0, 17, 0, 0, 0, 17, -1, 4, 0, 28, 0, 6, 0, 8, 1, 17, 0, 9, 1, 33, 0, 9, 0, 7, 0, 4, 1, 1, 1, 1, 0, 8, 0, 4, 1, 17, 1, 16, -1, 5, 0, 28, 0, 14, 0, 4, 1, 17, 1, 16, 0, 16, 0, 8, 32, 1, 34, 1, 32, 1, 34, 1, 0, 17, 0, 4, 0, 1, 1, 2, -1, 6, 0, 72, 0, 19, 0, 4, 0, 7, 8, 0, 0, 22, 0, 4, 0, 9, 8, 0, 0, 23, 0, 4, 0, 9, 0, 0, 0, 24, 0, 4, 0, 16, 0, 0, 0, 25, 0, 4, 0, 0, -112, 0, 0, 26, 0, 4, 0, -103, 9, 0, 0, 27, 0, 2, 9, 0, 0, 0, 0, 28, 0, 1, -128, 0, 0, 0, 0, 29, 0, 4, 9, -119, 7, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(lsReportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        byte[] testReportMsg = new byte[]{0};
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepLSReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)lsReportMsg));
    }
}

