/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Test;
import org.onosproject.pcepio.exceptions.PcepOutOfBoundMessageException;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFactories;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepReportMsg;

public class PcepReportMsgTest {
    @Test
    public void reportMessageTest1() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 36, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 4};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest2() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 124, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 2, 2, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest3() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 112, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 2, 2, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest4() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 100, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest5() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 80, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest6() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 108, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 4, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 2, 2, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest7() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 88, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 8, 0, 0, 16, 3, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 2, 2, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest8() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 112, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest9() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 68, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest10() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 116, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 28, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest11() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 104, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest12() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 96, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 8, 0, 0, 16, 3, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 31, 4, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest13() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 104, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest14() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 96, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 8, 0, 0, 16, 3, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest15() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 124, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest16() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 112, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 5, 32, 0, 8, 0, 0, 0, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest17() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 116, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 8, 0, 0, 16, 3, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest18() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 104, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 8, 0, 0, 16, 3, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 5, 32, 0, 8, 0, 0, 0, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest19() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 108, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 8, 0, 0, 16, 3, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest20() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, -120, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 8, 0, 0, 16, 3, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest21() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, -84, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest22() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, -96, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest23() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, -116, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest24() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, -124, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest25() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, -116, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest26() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 88, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest27() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 68, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest28() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 108, 32, 16, 0, 44, 0, 0, 16, 3, 0, 18, 0, 16, -74, 2, 78, 31, 0, 1, -128, 1, -74, 2, 78, 31, -74, 2, 78, 32, 0, 17, 0, 2, 84, 49, 0, 0, 0, 20, 0, 4, 0, 0, 0, 8, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest29() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, 116, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest30() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, -28, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest31() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 1, 0, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest32() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 1, 20, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest33() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 1, 28, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 8, 16, 0, 52, 1, 8, 17, 1, 1, 1, 4, 0, 1, 8, 17, 1, 1, 2, 4, 0, 1, 8, 6, 6, 6, 6, 4, 0, 1, 8, 18, 1, 1, 2, 4, 0, 1, 8, 18, 1, 1, 1, 4, 0, 1, 8, 5, 5, 5, 5, 4, 0};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest34() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, -76, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 4, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }

    @Test
    public void reportMessageTest35() throws PcepParseException, PcepOutOfBoundMessageException {
        byte[] reportMsg = new byte[]{32, 10, 0, -116, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 33, 16, 0, 12, 0, 0, 0, 0, 0, 0, 0, 1, 32, 16, 0, 16, 0, 0, 16, 3, 0, 17, 0, 2, 84, 49, 0, 0, 7, 16, 0, 20, 1, 8, -74, 2, 78, 31, 4, 0, 1, 8, -74, 2, 78, 32, 4, 0, 9, 16, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 32, 0, 8, 0, 0, 0, 0, 6, 16, 0, 12, 0, 0, 1, 3, 0, 0, 0, 32};
        byte[] testReportMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(reportMsg);
        PcepMessageReader reader = PcepFactories.getGenericReader();
        PcepMessage message = null;
        message = (PcepMessage)reader.readFrom(buffer);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(PcepReportMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        testReportMsg = new byte[readLen];
        buf.readBytes(testReportMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testReportMsg, (Matcher)Is.is((Object)reportMsg));
    }
}

