/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepEroObject;
import org.onosproject.pcepio.types.AutonomousSystemNumberSubObject;
import org.onosproject.pcepio.types.IPv4SubObject;
import org.onosproject.pcepio.types.IPv6SubObject;
import org.onosproject.pcepio.types.PathKeySubObject;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.SrEroSubObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepEroObjectVer1
implements PcepEroObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepEroObjectVer1.class);
    public static final byte ERO_OBJ_TYPE = 1;
    public static final byte ERO_OBJ_CLASS = 7;
    public static final byte ERO_OBJECT_VERSION = 1;
    public static final short ERO_OBJ_MINIMUM_LENGTH = 12;
    public static final byte IPV4_TYPE = 1;
    public static final byte PATH_KEY_32_BIT_SUB_OBJ_TYPE = 64;
    public static final int LABEL_SUB_OBJ_TYPE = 3;
    public static final int SR_ERO_SUB_OBJ_TYPE = 96;
    public static final int OBJECT_HEADER_LENGTH = 4;
    public static final int TYPE_SHIFT_VALUE = 127;
    public static final PcepObjectHeader DEFAULT_ERO_OBJECT_HEADER = new PcepObjectHeader(7, 1, false, false, 12);
    private PcepObjectHeader eroObjHeader;
    private LinkedList<PcepValueType> subObjectList = new LinkedList();

    public PcepEroObjectVer1() {
        this.eroObjHeader = null;
        this.subObjectList = null;
    }

    public PcepEroObjectVer1(PcepObjectHeader eroObjHeader, LinkedList<PcepValueType> subObjectList) {
        this.eroObjHeader = eroObjHeader;
        this.subObjectList = subObjectList;
    }

    public PcepObjectHeader getEroObjHeader() {
        return this.eroObjHeader;
    }

    public void setEroObjHeader(PcepObjectHeader obj) {
        this.eroObjHeader = obj;
    }

    @Override
    public LinkedList<PcepValueType> getSubObjects() {
        return this.subObjectList;
    }

    @Override
    public void setSubObjects(LinkedList<PcepValueType> subObjectList) {
        this.subObjectList = subObjectList;
    }

    public static PcepEroObject read(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> subObjectList = new LinkedList<PcepValueType>();
        PcepObjectHeader eroObjHeader = PcepObjectHeader.read(cb);
        if (eroObjHeader.getObjClass() != 7) {
            log.debug("ErrorType:6 ErrorValue:9");
            throw new PcepParseException(6, 9);
        }
        if (eroObjHeader.getObjLen() > 4) {
            ChannelBuffer tempCb = cb.readBytes(eroObjHeader.getObjLen() - 4);
            subObjectList = PcepEroObjectVer1.parseSubObjects(tempCb);
        }
        return new PcepEroObjectVer1(eroObjHeader, subObjectList);
    }

    protected static LinkedList<PcepValueType> parseSubObjects(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> subObjectList = new LinkedList<PcepValueType>();
        while (0 < cb.readableBytes()) {
            PcepValueType subObj;
            short type = cb.readByte();
            type = (short)(type & 0x7F);
            byte hLength = cb.readByte();
            switch (type) {
                case 1: {
                    subObj = IPv4SubObject.read(cb);
                    break;
                }
                case 2: {
                    byte[] ipv6Value = new byte[18];
                    cb.readBytes(ipv6Value, 0, 18);
                    subObj = new IPv6SubObject(ipv6Value);
                    break;
                }
                case 50: {
                    subObj = AutonomousSystemNumberSubObject.read(cb);
                    break;
                }
                case 64: {
                    subObj = PathKeySubObject.read(cb);
                    break;
                }
                case 96: {
                    subObj = SrEroSubObject.read(cb);
                    break;
                }
                default: {
                    throw new PcepParseException("Unexpected sub object. Type: " + type);
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= cb.readableBytes()) {
                cb.skipBytes(pad);
            }
            subObjectList.add(subObj);
        }
        if (0 < cb.readableBytes()) {
            throw new PcepParseException("Subobject parsing error. Extra bytes received.");
        }
        return subObjectList;
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.eroObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException("Failed to write ERO object header. Index " + objLenIndex);
        }
        ListIterator listIterator = this.subObjectList.listIterator();
        while (listIterator.hasNext()) {
            ((PcepValueType)listIterator.next()).write(cb);
        }
        int length = cb.writerIndex() - objStartIndex;
        cb.setShort(objLenIndex, (int)((short)length));
        this.eroObjHeader.setObjLen((short)length);
        int pad = length % 4;
        if (pad != 0) {
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                cb.writeByte(0);
            }
            length += pad;
        }
        objLenIndex = cb.writerIndex();
        return objLenIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("EroObjHeader", (Object)this.eroObjHeader).add("SubObjects", this.subObjectList).toString();
    }

    public static class Builder
    implements PcepEroObject.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;
        private PcepObjectHeader eroObjHeader;
        LinkedList<PcepValueType> subObjectList = new LinkedList();

        @Override
        public PcepEroObject build() {
            PcepObjectHeader eroObjHeader;
            PcepObjectHeader pcepObjectHeader = eroObjHeader = this.bIsHeaderSet ? this.eroObjHeader : DEFAULT_ERO_OBJECT_HEADER;
            if (this.bIsPFlagSet) {
                eroObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                eroObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepEroObjectVer1(eroObjHeader, this.subObjectList);
        }

        @Override
        public PcepObjectHeader getEroObjHeader() {
            return this.eroObjHeader;
        }

        @Override
        public Builder setEroObjHeader(PcepObjectHeader obj) {
            this.eroObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public LinkedList<PcepValueType> getSubObjects() {
            return this.subObjectList;
        }

        @Override
        public Builder setSubObjects(LinkedList<PcepValueType> subObjectList) {
            this.subObjectList = subObjectList;
            return this;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

