/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFecObjectIPv4;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepFecObjectIPv4Ver1
implements PcepFecObjectIPv4 {
    protected static final Logger log = LoggerFactory.getLogger(PcepFecObjectIPv4Ver1.class);
    public static final byte FEC_OBJ_TYPE = 1;
    public static final byte FEC_OBJ_CLASS = -30;
    public static final byte FEC_OBJECT_VERSION = 1;
    public static final short FEC_OBJ_MINIMUM_LENGTH = 8;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    static final PcepObjectHeader DEFAULT_FEC_OBJECT_HEADER = new PcepObjectHeader(-30, 1, false, false, 8);
    private PcepObjectHeader fecObjHeader;
    private int nodeID;

    public PcepFecObjectIPv4Ver1(PcepObjectHeader fecObjHeader, int nodeID) {
        this.fecObjHeader = fecObjHeader;
        this.nodeID = nodeID;
    }

    public void setFecIpv4ObjHeader(PcepObjectHeader obj) {
        this.fecObjHeader = obj;
    }

    @Override
    public void setNodeID(int nodeID) {
        this.nodeID = nodeID;
    }

    public PcepObjectHeader getFecIpv4ObjHeader() {
        return this.fecObjHeader;
    }

    @Override
    public int getNodeID() {
        return this.nodeID;
    }

    public static PcepFecObjectIPv4 read(ChannelBuffer cb) throws PcepParseException {
        PcepObjectHeader fecObjHeader = PcepObjectHeader.read(cb);
        int nodeID = cb.readInt();
        return new PcepFecObjectIPv4Ver1(fecObjHeader, nodeID);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.fecObjHeader.write(cb);
        cb.writeInt(this.nodeID);
        cb.setShort(objLenIndex, (int)((short)(cb.writerIndex() - objStartIndex)));
        return cb.writerIndex();
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public int getType() {
        return 1;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("fecObjHeader", (Object)this.fecObjHeader).add("nodeID: ", this.nodeID).toString();
    }

    public static class Builder
    implements PcepFecObjectIPv4.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsNodeIdset = false;
        private PcepObjectHeader fecObjHeader;
        private int nodeID;
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepFecObjectIPv4 build() throws PcepParseException {
            PcepObjectHeader fecObjHeader;
            PcepObjectHeader pcepObjectHeader = fecObjHeader = this.bIsHeaderSet ? this.fecObjHeader : DEFAULT_FEC_OBJECT_HEADER;
            if (!this.bIsNodeIdset) {
                throw new PcepParseException("NodeID not set while building PcepFecObjectIPv4 object.");
            }
            if (this.bIsPFlagSet) {
                fecObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                fecObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepFecObjectIPv4Ver1(fecObjHeader, this.nodeID);
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }

        @Override
        public PcepObjectHeader getFecIpv4ObjHeader() {
            return this.fecObjHeader;
        }

        @Override
        public Builder setFecIpv4ObjHeader(PcepObjectHeader obj) {
            this.fecObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public int getNodeID() {
            return this.nodeID;
        }

        @Override
        public Builder setNodeID(int value) {
            this.nodeID = value;
            this.bIsNodeIdset = true;
            return this;
        }
    }
}

