/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepFecObjectIPv6Adjacency;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepFecObjectIPv6AdjacencyVer1
implements PcepFecObjectIPv6Adjacency {
    protected static final Logger log = LoggerFactory.getLogger(PcepFecObjectIPv6AdjacencyVer1.class);
    public static final byte FEC_OBJ_TYPE = 4;
    public static final byte FEC_OBJ_CLASS = -30;
    public static final byte FEC_OBJECT_VERSION = 1;
    public static final short FEC_OBJ_MINIMUM_LENGTH = 36;
    public static final int MINIMUM_COMMON_HEADER_LENGTH = 4;
    public static final int IPV6_ADDRESS_LENGTH = 16;
    static final PcepObjectHeader DEFAULT_FEC_OBJECT_HEADER = new PcepObjectHeader(-30, 4, false, false, 36);
    private PcepObjectHeader fecObjHeader;
    private byte[] localIPv6Address = new byte[16];
    private byte[] remoteIPv6Address = new byte[16];

    public PcepFecObjectIPv6AdjacencyVer1(PcepObjectHeader fecObjHeader, byte[] localIPv6Address, byte[] remoteIPv6Address) {
        this.fecObjHeader = fecObjHeader;
        this.localIPv6Address = localIPv6Address;
        this.remoteIPv6Address = remoteIPv6Address;
    }

    public void setFecIpv4ObjHeader(PcepObjectHeader obj) {
        this.fecObjHeader = obj;
    }

    @Override
    public byte[] getLocalIPv6Address() {
        return this.localIPv6Address;
    }

    @Override
    public void seLocalIPv6Address(byte[] value) {
        this.localIPv6Address = value;
    }

    @Override
    public byte[] getRemoteIPv6Address() {
        return this.remoteIPv6Address;
    }

    @Override
    public void seRemoteIPv6Address(byte[] value) {
        this.remoteIPv6Address = value;
    }

    public static PcepFecObjectIPv6Adjacency read(ChannelBuffer cb) throws PcepParseException {
        byte[] localIPv6Address = new byte[16];
        byte[] remoteIPv6Address = new byte[16];
        PcepObjectHeader fecObjHeader = PcepObjectHeader.read(cb);
        cb.readBytes(localIPv6Address, 0, 16);
        cb.readBytes(remoteIPv6Address, 0, 16);
        return new PcepFecObjectIPv6AdjacencyVer1(fecObjHeader, localIPv6Address, remoteIPv6Address);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.fecObjHeader.write(cb);
        cb.writeBytes(this.localIPv6Address);
        cb.writeBytes(this.remoteIPv6Address);
        cb.setShort(objLenIndex, (int)((short)(cb.writerIndex() - objStartIndex)));
        return cb.writerIndex();
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public int getType() {
        return 4;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("localIPv6Address", (Object)this.localIPv6Address).add("remoteIPv6Address: ", (Object)this.remoteIPv6Address).toString();
    }

    public static class Builder
    implements PcepFecObjectIPv6Adjacency.Builder {
        private boolean bIsHeaderSet = false;
        private boolean bIsLocalIPv6Addressset = false;
        private boolean bIsRemoteIPv6Addressset = false;
        private PcepObjectHeader fecObjHeader;
        byte[] localIPv6Address = new byte[16];
        byte[] remoteIPv6Address = new byte[16];
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepFecObjectIPv6Adjacency build() throws PcepParseException {
            PcepObjectHeader fecObjHeader;
            PcepObjectHeader pcepObjectHeader = fecObjHeader = this.bIsHeaderSet ? this.fecObjHeader : DEFAULT_FEC_OBJECT_HEADER;
            if (!this.bIsLocalIPv6Addressset) {
                throw new PcepParseException("Local IPv6 Address not set while building PcepFecObjectIPv6Adjacency object.");
            }
            if (!this.bIsRemoteIPv6Addressset) {
                throw new PcepParseException("Remote IPv6 Address not set while building PcepFecObjectIPv6Adjacency object.");
            }
            if (this.bIsPFlagSet) {
                fecObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                fecObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepFecObjectIPv6AdjacencyVer1(fecObjHeader, this.localIPv6Address, this.remoteIPv6Address);
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }

        @Override
        public PcepObjectHeader getFecIpv6AdjacencyObjHeader() {
            return this.fecObjHeader;
        }

        @Override
        public Builder setFecIpv6AdjacencyObjHeader(PcepObjectHeader obj) {
            this.fecObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public byte[] getLocalIPv6Address() {
            return this.localIPv6Address;
        }

        @Override
        public Builder setLocalIPv6Address(byte[] value) {
            this.localIPv6Address = value;
            this.bIsLocalIPv6Addressset = true;
            return this;
        }

        @Override
        public byte[] getRemoteIPv6Address() {
            return this.remoteIPv6Address;
        }

        @Override
        public Builder setRemoteIPv6Address(byte[] value) {
            this.remoteIPv6Address = value;
            this.bIsRemoteIPv6Addressset = true;
            return this;
        }
    }
}

