/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepLSObject;
import org.onosproject.pcepio.protocol.PcepLSReportMsg;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepMessageWriter;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.protocol.ver1.PcepLSObjectVer1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PcepLSReportMsgVer1
implements PcepLSReportMsg {
    private static final Logger log = LoggerFactory.getLogger(PcepLSReportMsgVer1.class);
    public static final int PACKET_MINIMUM_LENGTH = 16;
    public static final PcepType MSG_TYPE = PcepType.LS_REPORT;
    private List<PcepLSObject> lsReportList;
    public static final Reader READER = new Reader();
    static final Writer WRITER = new Writer();

    PcepLSReportMsgVer1(List<PcepLSObject> lsReportList) {
        this.lsReportList = lsReportList;
    }

    @Override
    public void writeTo(ChannelBuffer bb) throws PcepParseException {
        WRITER.write(bb, this);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public PcepType getType() {
        return MSG_TYPE;
    }

    @Override
    public List<PcepLSObject> getLSReportList() {
        return this.lsReportList;
    }

    @Override
    public void setLSReportList(List<PcepLSObject> ll) {
        this.lsReportList = ll;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("LSReportList", this.lsReportList).toString();
    }

    static class Writer
    implements PcepMessageWriter<PcepLSReportMsgVer1> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, PcepLSReportMsgVer1 message) throws PcepParseException {
            int startIndex = bb.writerIndex();
            bb.writeByte(32);
            bb.writeByte((int)MSG_TYPE.getType());
            int msgLenIndex = bb.writerIndex();
            bb.writeShort(0);
            ListIterator listIterator = message.lsReportList.listIterator();
            while (listIterator.hasNext()) {
                PcepLSObject lsObj = (PcepLSObject)listIterator.next();
                lsObj.write(bb);
            }
            int length = bb.writerIndex() - startIndex;
            bb.setShort(msgLenIndex, (int)((short)length));
        }
    }

    static class Builder
    implements PcepLSReportMsg.Builder {
        List<PcepLSObject> lsReportList;

        Builder() {
        }

        @Override
        public PcepVersion getVersion() {
            return PcepVersion.PCEP_1;
        }

        @Override
        public PcepType getType() {
            return PcepType.LS_REPORT;
        }

        @Override
        public PcepLSReportMsg build() {
            return new PcepLSReportMsgVer1(this.lsReportList);
        }

        @Override
        public List<PcepLSObject> getLSReportList() {
            return this.lsReportList;
        }

        @Override
        public Builder setLSReportList(List<PcepLSObject> ll) {
            this.lsReportList = ll;
            return this;
        }
    }

    static class Reader
    implements PcepMessageReader<PcepLSReportMsg> {
        List<PcepLSObject> lsReportList;

        Reader() {
        }

        @Override
        public PcepLSReportMsg readFrom(ChannelBuffer cb) throws PcepParseException {
            if (cb.readableBytes() < 16) {
                return null;
            }
            this.lsReportList = new LinkedList<PcepLSObject>();
            byte version = cb.readByte();
            if ((version = (byte)(version >> 5)) != 1) {
                throw new PcepParseException("Wrong version. Expected=PcepVersion.PCEP_1(1), got=" + version);
            }
            byte type = cb.readByte();
            if (type != MSG_TYPE.getType()) {
                throw new PcepParseException("Wrong type. Expected=PcepType.LS_REPORT(224), got=" + type);
            }
            short length = cb.readShort();
            if (length < 16) {
                throw new PcepParseException("Wrong length. Expected to be >= 16, is: " + length);
            }
            this.parseLSReportList(cb);
            return new PcepLSReportMsgVer1(this.lsReportList);
        }

        public void parseLSReportList(ChannelBuffer cb) throws PcepParseException {
            while (0 < cb.readableBytes()) {
                if (this.lsReportList.add(PcepLSObjectVer1.read(cb))) continue;
                throw new PcepParseException("Failed to add LS object to LS-Report list");
            }
        }
    }
}

