/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepLabelRange;
import org.onosproject.pcepio.protocol.PcepLabelRangeResvMsg;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepMessageWriter;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.protocol.ver1.PcepLabelRangeVer1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PcepLabelRangeResvMsgVer1
implements PcepLabelRangeResvMsg {
    protected static final Logger log = LoggerFactory.getLogger(PcepLabelRangeResvMsgVer1.class);
    public static final byte PACKET_VERSION = 1;
    public static final int PACKET_MINIMUM_LENGTH = 28;
    public static final PcepType MSG_TYPE = PcepType.LABEL_RANGE_RESERV;
    PcepLabelRange labelRange;
    public static final Reader READER = new Reader();
    static final Writer WRITER = new Writer();

    PcepLabelRangeResvMsgVer1(PcepLabelRange labelRange) {
        this.labelRange = labelRange;
    }

    @Override
    public void writeTo(ChannelBuffer cb) throws PcepParseException {
        WRITER.write(cb, this);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public PcepType getType() {
        return MSG_TYPE;
    }

    @Override
    public PcepLabelRange getLabelRange() {
        return this.labelRange;
    }

    @Override
    public void setLabelRange(PcepLabelRange lr) {
        this.labelRange = lr;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("labelRange", (Object)this.labelRange).toString();
    }

    static class Writer
    implements PcepMessageWriter<PcepLabelRangeResvMsgVer1> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer cb, PcepLabelRangeResvMsgVer1 message) throws PcepParseException {
            int startIndex = cb.writerIndex();
            cb.writeByte(32);
            cb.writeByte((int)MSG_TYPE.getType());
            int msgLenIndex = cb.writerIndex();
            cb.writeShort(0);
            message.labelRange.write(cb);
            int length = cb.writerIndex() - startIndex;
            cb.setShort(msgLenIndex, (int)((short)length));
        }
    }

    static class Builder
    implements PcepLabelRangeResvMsg.Builder {
        PcepLabelRange labelRange = new PcepLabelRangeVer1();

        Builder() {
        }

        @Override
        public PcepVersion getVersion() {
            return PcepVersion.PCEP_1;
        }

        @Override
        public PcepType getType() {
            return PcepType.LABEL_RANGE_RESERV;
        }

        @Override
        public PcepLabelRangeResvMsg build() {
            return new PcepLabelRangeResvMsgVer1(this.labelRange);
        }

        @Override
        public PcepLabelRange getLabelRange() {
            return this.labelRange;
        }

        @Override
        public Builder setLabelRange(PcepLabelRange labelRange) {
            this.labelRange = labelRange;
            return this;
        }
    }

    static class Reader
    implements PcepMessageReader<PcepLabelRangeResvMsg> {
        Reader() {
        }

        @Override
        public PcepLabelRangeResvMsg readFrom(ChannelBuffer cb) throws PcepParseException {
            if (cb.readableBytes() < 28) {
                throw new PcepParseException("Channel buffer has less readable bytes than Packet minimum length.");
            }
            byte version = cb.readByte();
            if ((version = (byte)(version >> 5)) != 1) {
                throw new PcepParseException("Wrong version. Expected=PcepVersion.PCEP_1(1), got=" + version);
            }
            byte type = cb.readByte();
            if (type != MSG_TYPE.getType()) {
                throw new PcepParseException("Wrong type. Expected=PcepType.LABEL_RANGE_RESERV(15), got=" + type);
            }
            short length = cb.readShort();
            if (length < 28) {
                throw new PcepParseException("Wrong length.Expected to be >= 28, is: " + length);
            }
            PcepLabelRange labelRange = PcepLabelRangeVer1.read(cb);
            return new PcepLabelRangeResvMsgVer1(labelRange);
        }
    }
}

