/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepLabelUpdate;
import org.onosproject.pcepio.protocol.PcepLabelUpdateMsg;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepMessageWriter;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.protocol.ver1.PcepLabelUpdateVer1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PcepLabelUpdateMsgVer1
implements PcepLabelUpdateMsg {
    protected static final Logger log = LoggerFactory.getLogger(PcepLabelUpdateMsgVer1.class);
    public static final byte PACKET_VERSION = 1;
    public static final int PACKET_MINIMUM_LENGTH = 36;
    public static final PcepType MSG_TYPE = PcepType.LABEL_UPDATE;
    private LinkedList<PcepLabelUpdate> llPcLabelUpdateList;
    static final Reader READER = new Reader();
    static final Writer WRITER = new Writer();

    PcepLabelUpdateMsgVer1(LinkedList<PcepLabelUpdate> llPcLabelUpdateList) {
        this.llPcLabelUpdateList = llPcLabelUpdateList;
    }

    @Override
    public void writeTo(ChannelBuffer cb) throws PcepParseException {
        WRITER.write(cb, this);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public PcepType getType() {
        return MSG_TYPE;
    }

    @Override
    public LinkedList<PcepLabelUpdate> getPcLabelUpdateList() {
        return this.llPcLabelUpdateList;
    }

    @Override
    public void setPcLabelUpdateList(LinkedList<PcepLabelUpdate> ll) {
        this.llPcLabelUpdateList = ll;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("PcLabelUpdateList", this.llPcLabelUpdateList).toString();
    }

    static class Writer
    implements PcepMessageWriter<PcepLabelUpdateMsgVer1> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer cb, PcepLabelUpdateMsgVer1 message) throws PcepParseException {
            int startIndex = cb.writerIndex();
            cb.writeByte(32);
            cb.writeByte((int)MSG_TYPE.getType());
            int msgLenIndex = cb.writerIndex();
            cb.writeShort(0);
            ListIterator listIterator = message.llPcLabelUpdateList.listIterator();
            while (listIterator.hasNext()) {
                PcepLabelUpdate labelUpdate = (PcepLabelUpdate)listIterator.next();
                labelUpdate.write(cb);
            }
            int length = cb.writerIndex() - startIndex;
            cb.setShort(msgLenIndex, (int)((short)length));
        }
    }

    static class Builder
    implements PcepLabelUpdateMsg.Builder {
        LinkedList<PcepLabelUpdate> llPcLabelUpdateList;

        Builder() {
        }

        @Override
        public PcepVersion getVersion() {
            return PcepVersion.PCEP_1;
        }

        @Override
        public PcepType getType() {
            return PcepType.LABEL_UPDATE;
        }

        @Override
        public PcepLabelUpdateMsg build() {
            return new PcepLabelUpdateMsgVer1(this.llPcLabelUpdateList);
        }

        @Override
        public LinkedList<PcepLabelUpdate> getPcLabelUpdateList() {
            return this.llPcLabelUpdateList;
        }

        @Override
        public Builder setPcLabelUpdateList(LinkedList<PcepLabelUpdate> ll) {
            this.llPcLabelUpdateList = ll;
            return this;
        }
    }

    static class Reader
    implements PcepMessageReader<PcepLabelUpdateMsg> {
        Reader() {
        }

        @Override
        public PcepLabelUpdateMsg readFrom(ChannelBuffer cb) throws PcepParseException {
            if (cb.readableBytes() < 36) {
                throw new PcepParseException("Readable bytes are less than Packet minimum length.");
            }
            byte version = cb.readByte();
            if ((version = (byte)(version >> 5)) != 1) {
                throw new PcepParseException("Wrong version.Expected=PcepVersion.PCEP_1(1), got=" + version);
            }
            byte type = cb.readByte();
            if (type != MSG_TYPE.getType()) {
                throw new PcepParseException("Wrong type. Expected=PcepType.LABEL_UPDATE(13), got=" + type);
            }
            short length = cb.readShort();
            if (length < 36) {
                throw new PcepParseException("Wrong length. Expected to be >= 36, is: " + length);
            }
            LinkedList<PcepLabelUpdate> llPcLabelUpdateList = this.parsePcLabelUpdateList(cb);
            return new PcepLabelUpdateMsgVer1(llPcLabelUpdateList);
        }

        public LinkedList<PcepLabelUpdate> parsePcLabelUpdateList(ChannelBuffer cb) throws PcepParseException {
            LinkedList<PcepLabelUpdate> llPcLabelUpdateList = new LinkedList<PcepLabelUpdate>();
            while (0 < cb.readableBytes()) {
                llPcLabelUpdateList.add(PcepLabelUpdateVer1.read(cb));
            }
            return llPcLabelUpdateList;
        }
    }
}

