/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepLspaObject;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepLspaObjectVer1
implements PcepLspaObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepLspaObjectVer1.class);
    public static final byte LSPA_OBJ_TYPE = 1;
    public static final byte LSPA_OBJ_CLASS = 9;
    public static final byte LSPA_OBJECT_VERSION = 1;
    public static final short LSPA_OBJ_MINIMUM_LENGTH = 20;
    public static final int OBJECT_HEADER_LENGTH = 4;
    static final PcepObjectHeader DEFAULT_LSPA_OBJECT_HEADER = new PcepObjectHeader(9, 1, false, false, 20);
    public static final int SETUP_PRIORITY_SHIFT_VALUE = 24;
    public static final int HOLD_PRIORITY_SHIFT_VALUE = 16;
    public static final int BFLAG_SHIFT_VALUE = 8;
    public static final int LFLAG_SET = 1;
    public static final int LFLAG_RESET = 0;
    private PcepObjectHeader lspaObjHeader;
    private int iExcludeAny;
    private int iIncludeAny;
    private int iIncludeAll;
    private byte cSetupPriority;
    private byte cHoldPriority;
    private boolean bLFlag;
    private LinkedList<PcepValueType> llOptionalTlv;

    public PcepLspaObjectVer1(PcepObjectHeader lspaObjHeader, boolean bLFlag, int iExcludeAny, int iIncludeAny, int iIncludeAll, byte cSetupPriority, byte cHoldPriority, LinkedList<PcepValueType> llOptionalTlv) {
        this.lspaObjHeader = lspaObjHeader;
        this.bLFlag = bLFlag;
        this.iExcludeAny = iExcludeAny;
        this.iIncludeAny = iIncludeAny;
        this.iIncludeAll = iIncludeAll;
        this.cSetupPriority = cSetupPriority;
        this.cHoldPriority = cHoldPriority;
        this.llOptionalTlv = llOptionalTlv;
    }

    public void setLspaObjHeader(PcepObjectHeader obj) {
        this.lspaObjHeader = obj;
    }

    @Override
    public void setExcludeAny(int iExcludeAny) {
        this.iExcludeAny = iExcludeAny;
    }

    @Override
    public void setIncludeAny(int iIncludeAny) {
        this.iIncludeAny = iIncludeAny;
    }

    @Override
    public void setSetupPriority(byte cSetupPriority) {
        this.cSetupPriority = cSetupPriority;
    }

    @Override
    public void setHoldPriority(byte cHoldPriority) {
        this.cHoldPriority = cHoldPriority;
    }

    @Override
    public void setLFlag(boolean bLFlag) {
        this.bLFlag = bLFlag;
    }

    public PcepObjectHeader getLspaObjHeader() {
        return this.lspaObjHeader;
    }

    @Override
    public int getExcludeAny() {
        return this.iExcludeAny;
    }

    @Override
    public int getIncludeAny() {
        return this.iIncludeAny;
    }

    @Override
    public int getIncludeAll() {
        return this.iIncludeAll;
    }

    @Override
    public byte getSetupPriority() {
        return this.cSetupPriority;
    }

    @Override
    public byte getHoldPriority() {
        return this.cHoldPriority;
    }

    @Override
    public boolean getLFlag() {
        return this.bLFlag;
    }

    @Override
    public void setIncludeAll(int value) {
        this.iIncludeAll = value;
    }

    @Override
    public LinkedList<PcepValueType> getOptionalTlv() {
        return this.llOptionalTlv;
    }

    @Override
    public void setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
        this.llOptionalTlv = llOptionalTlv;
    }

    public static PcepLspaObject read(ChannelBuffer cb) throws PcepParseException {
        log.debug("LspaObject::read");
        PcepObjectHeader lspaObjHeader = PcepObjectHeader.read(cb);
        ChannelBuffer tempCb = cb.readBytes(lspaObjHeader.getObjLen() - 4);
        int iExcludeAny = tempCb.readInt();
        int iIncludeAny = tempCb.readInt();
        int iIncludeAll = tempCb.readInt();
        byte cSetupPriority = tempCb.readByte();
        byte cHoldPriority = tempCb.readByte();
        byte flags = tempCb.readByte();
        tempCb.readByte();
        boolean bLFlag = (flags & 1) == 1;
        LinkedList<PcepValueType> llOptionalTlv = PcepLspaObjectVer1.parseOptionalTlv(tempCb);
        return new PcepLspaObjectVer1(lspaObjHeader, bLFlag, iExcludeAny, iIncludeAny, iIncludeAll, cSetupPriority, cHoldPriority, llOptionalTlv);
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.lspaObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException("Failed to write lspa object header. Index " + objLenIndex);
        }
        cb.writeInt(this.iExcludeAny);
        cb.writeInt(this.iIncludeAny);
        cb.writeInt(this.iIncludeAll);
        int iTemp = this.cSetupPriority << 24;
        iTemp |= this.cHoldPriority << 16;
        int bFlag = this.bLFlag ? 1 : 0;
        cb.writeInt(iTemp |= bFlag << 8);
        if (!this.packOptionalTlv(cb)) {
            throw new PcepParseException("Faild to write lspa objects tlv to channel buffer");
        }
        short length = (short)(cb.writerIndex() - objStartIndex);
        this.lspaObjHeader.setObjLen(length);
        int pad = length % 4;
        if (pad != 0) {
            pad = (short)(4 - pad);
            for (int i = 0; i < pad; ++i) {
                cb.writeByte(0);
            }
            length = (short)(length + pad);
        }
        cb.setShort(objLenIndex, (int)length);
        return cb.writerIndex();
    }

    public static LinkedList<PcepValueType> parseOptionalTlv(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOutOptionalTlv = new LinkedList<PcepValueType>();
        return llOutOptionalTlv;
    }

    protected boolean packOptionalTlv(ChannelBuffer cb) {
        ListIterator listIterator = this.llOptionalTlv.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            if (tlv == null) {
                log.debug("Warning: tlv is null from OptionalTlv list");
                continue;
            }
            short hTlvType = tlv.getType();
            short hTlvLength = tlv.getLength();
            if (0 == hTlvLength) {
                log.debug("Warning: invalid length in tlv of OptionalTlv list");
                continue;
            }
            cb.writeShort((int)hTlvType);
            cb.writeShort((int)hTlvLength);
            switch (hTlvType) {
                default: 
            }
            log.debug("Warning: PcepLspaObject: unknown tlv");
            int pad = hTlvLength % 4;
            if (0 >= pad || (pad = 4 - pad) > cb.readableBytes()) continue;
            cb.skipBytes(pad);
        }
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("LFlag", this.bLFlag).add("SetupPriority", (int)this.cSetupPriority).add("HoldPriority", (int)this.cHoldPriority).add("IncludeAll", this.iIncludeAll).add("IncludeAny", this.iIncludeAny).add("ExcludeAny", this.iExcludeAny).add("OptionalTlvList", this.llOptionalTlv).toString();
    }

    public static class Builder
    implements PcepLspaObject.Builder {
        private boolean bIsHeaderSet = false;
        private PcepObjectHeader lspaObjHeader;
        private boolean bLFlag;
        private int iExcludeAny;
        private boolean bIsExcludeAnySet = false;
        private int iIncludeAny;
        private boolean bIsIncludeAnySet = false;
        private int iIncludeAll;
        private boolean bIsIncludeAllSet = false;
        private byte cSetupPriority;
        private boolean bIsSetupPrioritySet = false;
        private byte cHoldPriority;
        private boolean bIsHoldPrioritySet = false;
        private LinkedList<PcepValueType> llOptionalTlv;
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepLspaObject build() throws PcepParseException {
            PcepObjectHeader lspaObjHeader;
            PcepObjectHeader pcepObjectHeader = lspaObjHeader = this.bIsHeaderSet ? this.lspaObjHeader : DEFAULT_LSPA_OBJECT_HEADER;
            if (!this.bIsExcludeAnySet) {
                throw new PcepParseException("ExcludeAny NOT Set while building PcepLspaObject.");
            }
            if (!this.bIsIncludeAnySet) {
                throw new PcepParseException("IncludeAny NOT Set while building PcepLspaObject.");
            }
            if (!this.bIsIncludeAllSet) {
                throw new PcepParseException("IncludeAll NOT Set while building PcepLspaObject.");
            }
            if (!this.bIsSetupPrioritySet) {
                throw new PcepParseException("Setup Priority NOT Set while building PcepLspaObject.");
            }
            if (!this.bIsHoldPrioritySet) {
                throw new PcepParseException("Hold Priority NOT Set while building PcepLspaObject.");
            }
            if (this.bIsPFlagSet) {
                lspaObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                lspaObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepLspaObjectVer1(lspaObjHeader, this.bLFlag, this.iExcludeAny, this.iIncludeAny, this.iIncludeAll, this.cSetupPriority, this.cHoldPriority, this.llOptionalTlv);
        }

        @Override
        public PcepObjectHeader getLspaObjHeader() {
            return this.lspaObjHeader;
        }

        @Override
        public Builder setLspaObjHeader(PcepObjectHeader obj) {
            this.lspaObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public boolean getLFlag() {
            return this.bLFlag;
        }

        @Override
        public Builder setLFlag(boolean value) {
            this.bLFlag = value;
            return this;
        }

        @Override
        public int getExcludeAny() {
            return this.iExcludeAny;
        }

        @Override
        public Builder setExcludeAny(int value) {
            this.iExcludeAny = value;
            this.bIsExcludeAnySet = true;
            return this;
        }

        @Override
        public int getIncludeAny() {
            return this.iIncludeAny;
        }

        @Override
        public Builder setIncludeAny(int value) {
            this.iIncludeAny = value;
            this.bIsIncludeAnySet = true;
            return this;
        }

        @Override
        public int getIncludeAll() {
            return this.iIncludeAll;
        }

        @Override
        public Builder setIncludeAll(int value) {
            this.iIncludeAll = value;
            this.bIsIncludeAllSet = true;
            return this;
        }

        @Override
        public byte getSetupPriority() {
            return this.cSetupPriority;
        }

        @Override
        public Builder setSetupPriority(byte value) {
            this.cSetupPriority = value;
            this.bIsSetupPrioritySet = true;
            return this;
        }

        @Override
        public byte getHoldPriority() {
            return this.cHoldPriority;
        }

        @Override
        public Builder setHoldPriority(byte value) {
            this.cHoldPriority = value;
            this.bIsHoldPrioritySet = true;
            return this;
        }

        @Override
        public LinkedList<PcepValueType> getOptionalTlv() {
            return this.llOptionalTlv;
        }

        @Override
        public Builder setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
            this.llOptionalTlv = llOptionalTlv;
            return this;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

