/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepMessageReader;
import org.onosproject.pcepio.protocol.PcepMessageWriter;
import org.onosproject.pcepio.protocol.PcepOpenMsg;
import org.onosproject.pcepio.protocol.PcepOpenObject;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.protocol.ver1.PcepOpenObjectVer1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepOpenMsgVer1
implements PcepOpenMsg {
    protected static final Logger log = LoggerFactory.getLogger(PcepOpenMsgVer1.class);
    public static final byte PACKET_VERSION = 1;
    public static final int PACKET_MINIMUM_LENGTH = 12;
    public static final PcepType MSG_TYPE = PcepType.OPEN;
    private PcepOpenObject pcepOpenObj;
    public static final Reader READER = new Reader();
    public static final Writer WRITER = new Writer();

    public PcepOpenMsgVer1(PcepOpenObject pcepOpenObj) {
        this.pcepOpenObj = pcepOpenObj;
    }

    @Override
    public PcepOpenObject getPcepOpenObject() {
        return this.pcepOpenObj;
    }

    @Override
    public void setPcepOpenObject(PcepOpenObject pcepOpenObj) {
        this.pcepOpenObj = pcepOpenObj;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public PcepType getType() {
        return MSG_TYPE;
    }

    @Override
    public void writeTo(ChannelBuffer cb) throws PcepParseException {
        WRITER.write(cb, this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("OpenObject", (Object)this.pcepOpenObj).toString();
    }

    public static class Writer
    implements PcepMessageWriter<PcepOpenMsgVer1> {
        @Override
        public void write(ChannelBuffer cb, PcepOpenMsgVer1 message) throws PcepParseException {
            int startIndex = cb.writerIndex();
            cb.writeByte(32);
            cb.writeByte((int)MSG_TYPE.getType());
            int msgLenIndex = cb.writerIndex();
            cb.writeShort(0);
            message.getPcepOpenObject().write(cb);
            int iLength = cb.writerIndex() - startIndex;
            cb.setShort(msgLenIndex, (int)((short)iLength));
        }
    }

    static class Builder
    implements PcepOpenMsg.Builder {
        private PcepOpenObject pcepOpenObj;

        Builder() {
        }

        @Override
        public PcepOpenMsg build() throws PcepParseException {
            if (!(this.pcepOpenObj instanceof PcepOpenObjectVer1)) {
                throw new NullPointerException("PcepOpenObject is null.");
            }
            return new PcepOpenMsgVer1(this.pcepOpenObj);
        }

        @Override
        public PcepVersion getVersion() {
            return PcepVersion.PCEP_1;
        }

        @Override
        public PcepType getType() {
            return PcepType.OPEN;
        }

        @Override
        public PcepOpenObject getPcepOpenObj() {
            return this.pcepOpenObj;
        }

        @Override
        public Builder setPcepOpenObj(PcepOpenObject obj) {
            this.pcepOpenObj = obj;
            return this;
        }
    }

    public static class Reader
    implements PcepMessageReader<PcepOpenMsg> {
        @Override
        public PcepOpenMsg readFrom(ChannelBuffer cb) throws PcepParseException {
            if (cb.readableBytes() < 12) {
                throw new PcepParseException("Packet size is less than the minimum length.");
            }
            byte version = cb.readByte();
            if ((version = (byte)(version >> 5)) != 1) {
                log.error("[readFrom] Invalid version: " + version);
                throw new PcepParseException(1, 1);
            }
            byte type = cb.readByte();
            if (type != MSG_TYPE.getType()) {
                log.error("[readFrom] Unexpected type: " + type);
                throw new PcepParseException(1, 1);
            }
            short length = cb.readShort();
            if (length < 12) {
                throw new PcepParseException("Wrong length: Expected to be >= 12, was: " + length);
            }
            return new PcepOpenMsgVer1(PcepOpenObjectVer1.read(cb));
        }
    }
}

