/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepOpenObject;
import org.onosproject.pcepio.protocol.PcepType;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.GmplsCapabilityTlv;
import org.onosproject.pcepio.types.LsCapabilityTlv;
import org.onosproject.pcepio.types.PceccCapabilityTlv;
import org.onosproject.pcepio.types.PcepLabelDbVerTlv;
import org.onosproject.pcepio.types.PcepObjectHeader;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.StatefulLspDbVerTlv;
import org.onosproject.pcepio.types.StatefulPceCapabilityTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepOpenObjectVer1
implements PcepOpenObject {
    protected static final Logger log = LoggerFactory.getLogger(PcepOpenObjectVer1.class);
    public static final PcepType MSG_TYPE = PcepType.OPEN;
    public static final byte OPEN_OBJECT_VERSION = 1;
    public static final byte OPEN_OBJ_TYPE = 1;
    public static final byte OPEN_OBJ_CLASS = 1;
    public static final byte DEFAULT_KEEPALIVE_TIME = 30;
    public static final byte DEFAULT_DEAD_TIME = 120;
    public static final short OPEN_OBJ_MINIMUM_LENGTH = 8;
    public static final int DEFAULT_GMPLS_CAPABILITY_TLV_IVALUE = 0;
    public static final int DEFAULT_STATEFUL_PCE_CAPABILITY_TLV_IVALUE = 15;
    public static final int DEFAULT_PCECC_CAPABILITY_TLV_IVALUE = 7;
    public static final int DEFAULT_PCEP_LABEL_DB_VER_TLV_IVALUE = 0;
    public static final PcepObjectHeader DEFAULT_OPEN_HEADER = new PcepObjectHeader(1, 1, false, false, 8);
    private PcepObjectHeader openObjHeader;
    private byte keepAliveTime;
    private byte deadTime;
    private byte sessionId;
    private LinkedList<PcepValueType> llOptionalTlv;

    public PcepOpenObjectVer1() {
        this.openObjHeader = null;
        this.keepAliveTime = 0;
        this.deadTime = 0;
        this.sessionId = 0;
        this.llOptionalTlv = null;
    }

    public PcepOpenObjectVer1(PcepObjectHeader openObjHeader, byte keepAliveTime, byte deadTime, byte sessionID, LinkedList<PcepValueType> llOptionalTlv) {
        this.openObjHeader = openObjHeader;
        this.keepAliveTime = keepAliveTime;
        this.deadTime = deadTime;
        this.sessionId = sessionID;
        this.llOptionalTlv = llOptionalTlv;
    }

    @Override
    public PcepObjectHeader getOpenObjHeader() {
        return this.openObjHeader;
    }

    @Override
    public void setOpenObjHeader(PcepObjectHeader obj) {
        this.openObjHeader = obj;
    }

    @Override
    public byte getKeepAliveTime() {
        return this.keepAliveTime;
    }

    @Override
    public void setKeepAliveTime(byte value) {
        this.keepAliveTime = value;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public byte getDeadTime() {
        return this.deadTime;
    }

    @Override
    public void setDeadTime(byte value) {
        this.deadTime = value;
    }

    @Override
    public byte getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(byte value) {
        this.sessionId = value;
    }

    @Override
    public LinkedList<PcepValueType> getOptionalTlv() {
        return this.llOptionalTlv;
    }

    @Override
    public void setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
        this.llOptionalTlv = llOptionalTlv;
    }

    public static PcepOpenObject read(ChannelBuffer cb) throws PcepParseException {
        PcepObjectHeader openObjHeader = PcepObjectHeader.read(cb);
        byte version = cb.readByte();
        if ((version = (byte)(version >> 5)) != 1) {
            throw new PcepParseException("Wrong version: Expected=PcepVersion.PCEP_1(1), got=" + version);
        }
        byte keepAliveTime = cb.readByte();
        byte deadTime = cb.readByte();
        byte sessionID = cb.readByte();
        LinkedList<PcepValueType> llOptionalTlv = PcepOpenObjectVer1.parseOptionalTlv(cb);
        return new PcepOpenObjectVer1(openObjHeader, keepAliveTime, deadTime, sessionID, llOptionalTlv);
    }

    protected static LinkedList<PcepValueType> parseOptionalTlv(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llOptionalTlv = new LinkedList<PcepValueType>();
        block8: while (4 <= cb.readableBytes()) {
            PcepValueType tlv;
            short hType = cb.readShort();
            short hLength = cb.readShort();
            switch (hType) {
                case 14: {
                    log.debug("GmplsCapabilityTlv");
                    if (4 != hLength) {
                        throw new PcepParseException("Invalid length received for Gmpls_Capability_Tlv.");
                    }
                    int iValue = cb.readInt();
                    tlv = new GmplsCapabilityTlv(iValue);
                    break;
                }
                case 16: {
                    log.debug("StatefulPceCapabilityTlv");
                    if (4 != hLength) {
                        throw new PcepParseException("Invalid length received for StatefulPceCapabilityTlv.");
                    }
                    tlv = StatefulPceCapabilityTlv.read(cb);
                    break;
                }
                case 32: {
                    log.debug("PceccCapabilityTlv");
                    if (4 != hLength) {
                        throw new PcepParseException("Invalid length for PceccCapabilityTlv.");
                    }
                    int iValue = cb.readInt();
                    tlv = new PceccCapabilityTlv(iValue);
                    break;
                }
                case 23: {
                    log.debug("StatefulLspDbVerTlv");
                    if (8 != hLength) {
                        throw new PcepParseException("Invalid length received for StatefulLspDbVerTlv.");
                    }
                    long lValue = cb.readLong();
                    tlv = new StatefulLspDbVerTlv(lValue);
                    break;
                }
                case -256: {
                    log.debug("LsCapabilityTlv");
                    if (4 != hLength) {
                        throw new PcepParseException("Invalid length received for LsCapabilityTlv.");
                    }
                    int iValue = cb.readInt();
                    tlv = new LsCapabilityTlv(iValue);
                    break;
                }
                case 34: {
                    log.debug("PcepLabelDbVerTlv");
                    if (8 != hLength) {
                        throw new PcepParseException("Invalid length received for PcepLabelDbVerTlv.");
                    }
                    long lValue = cb.readLong();
                    tlv = new PcepLabelDbVerTlv(lValue);
                    break;
                }
                default: {
                    log.debug("Unsupported TLV: " + hType);
                    cb.skipBytes((int)hLength);
                    continue block8;
                }
            }
            llOptionalTlv.add(tlv);
        }
        if (0 < cb.readableBytes()) {
            throw new PcepParseException("Optional Tlv parsing error. Extra bytes received.");
        }
        return llOptionalTlv;
    }

    @Override
    public int write(ChannelBuffer cb) throws PcepParseException {
        int objStartIndex = cb.writerIndex();
        int objLenIndex = this.openObjHeader.write(cb);
        if (objLenIndex <= 0) {
            throw new PcepParseException("Unable to write Open object header.");
        }
        cb.writeByte(32);
        cb.writeByte((int)this.keepAliveTime);
        cb.writeByte((int)this.deadTime);
        cb.writeByte((int)this.sessionId);
        this.packOptionalTlv(cb);
        int length = cb.writerIndex() - objStartIndex;
        cb.setShort(objLenIndex, (int)((short)length));
        this.openObjHeader.setObjLen((short)length);
        return length;
    }

    protected int packOptionalTlv(ChannelBuffer cb) {
        int startIndex = cb.writerIndex();
        LinkedList<PcepValueType> llOptionalTlv = this.llOptionalTlv;
        ListIterator listIterator = llOptionalTlv.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = (PcepValueType)listIterator.next();
            if (tlv == null) {
                log.debug("TLV is null from OptionalTlv list");
                continue;
            }
            tlv.write(cb);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                cb.writeByte(0);
            }
        }
        return cb.writerIndex() - startIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ObjectHeader", (Object)this.openObjHeader).add("Keepalive", (int)this.keepAliveTime).add("DeadTimer", (int)this.deadTime).add("SessionId", (int)this.sessionId).add("OptionalTlv", this.llOptionalTlv).toString();
    }

    public static class Builder
    implements PcepOpenObject.Builder {
        private boolean bIsHeaderSet = false;
        private PcepObjectHeader openObjHeader;
        private boolean bIsKeepAliveTimeSet = false;
        private byte keepAliveTime;
        private boolean bIsDeadTimeSet = false;
        private byte deadTime;
        private boolean bIsSessionIDSet = false;
        private byte sessionID;
        private boolean bIsOptionalTlvSet = false;
        private LinkedList<PcepValueType> llOptionalTlv = new LinkedList();
        private boolean bIsPFlagSet = false;
        private boolean bPFlag;
        private boolean bIsIFlagSet = false;
        private boolean bIFlag;

        @Override
        public PcepOpenObject build() throws PcepParseException {
            byte deadTime;
            PcepObjectHeader openObjHeader = this.bIsHeaderSet ? this.openObjHeader : DEFAULT_OPEN_HEADER;
            byte keepAliveTime = this.bIsKeepAliveTimeSet ? (byte)this.keepAliveTime : (byte)30;
            byte by = deadTime = this.bIsDeadTimeSet ? (byte)this.deadTime : (byte)120;
            if (!this.bIsSessionIDSet) {
                throw new PcepParseException("SessionID is not set (mandatory)");
            }
            if (!this.bIsOptionalTlvSet) {
                int iValue = 0;
                PcepValueType tlv = new GmplsCapabilityTlv(iValue);
                this.llOptionalTlv.add(tlv);
                iValue = 15;
                tlv = new StatefulPceCapabilityTlv(iValue);
                this.llOptionalTlv.add(tlv);
            }
            if (this.bIsPFlagSet) {
                openObjHeader.setPFlag(this.bPFlag);
            }
            if (this.bIsIFlagSet) {
                openObjHeader.setIFlag(this.bIFlag);
            }
            return new PcepOpenObjectVer1(openObjHeader, keepAliveTime, deadTime, this.sessionID, this.llOptionalTlv);
        }

        @Override
        public PcepObjectHeader getOpenObjHeader() {
            return this.openObjHeader;
        }

        @Override
        public Builder setOpenObjHeader(PcepObjectHeader obj) {
            this.openObjHeader = obj;
            this.bIsHeaderSet = true;
            return this;
        }

        @Override
        public byte getKeepAliveTime() {
            return this.keepAliveTime;
        }

        @Override
        public Builder setKeepAliveTime(byte value) {
            this.keepAliveTime = value;
            this.bIsKeepAliveTimeSet = true;
            return this;
        }

        @Override
        public byte getDeadTime() {
            return this.deadTime;
        }

        @Override
        public Builder setDeadTime(byte value) {
            this.deadTime = value;
            this.bIsDeadTimeSet = true;
            return this;
        }

        @Override
        public byte getSessionId() {
            return this.sessionID;
        }

        @Override
        public Builder setSessionId(byte value) {
            this.sessionID = value;
            this.bIsSessionIDSet = true;
            return this;
        }

        @Override
        public Builder setOptionalTlv(LinkedList<PcepValueType> llOptionalTlv) {
            this.llOptionalTlv = llOptionalTlv;
            this.bIsOptionalTlvSet = true;
            return this;
        }

        @Override
        public LinkedList<PcepValueType> getOptionalTlv() {
            return this.llOptionalTlv;
        }

        @Override
        public Builder setPFlag(boolean value) {
            this.bPFlag = value;
            this.bIsPFlagSet = true;
            return this;
        }

        @Override
        public Builder setIFlag(boolean value) {
            this.bIFlag = value;
            this.bIsIFlagSet = true;
            return this;
        }
    }
}

