/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.protocol.ver1;

import com.google.common.base.MoreObjects;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepLspObject;
import org.onosproject.pcepio.protocol.PcepMsgPath;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.protocol.PcepUpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepUpdateRequestVer1
implements PcepUpdateRequest {
    protected static final Logger log = LoggerFactory.getLogger(PcepUpdateRequestVer1.class);
    private PcepSrpObject srpObject;
    private PcepLspObject lspObject;
    private PcepMsgPath msgPath;

    public PcepUpdateRequestVer1() {
        this.srpObject = null;
        this.lspObject = null;
        this.msgPath = null;
    }

    public PcepUpdateRequestVer1(PcepSrpObject srpObject, PcepLspObject lspObject, PcepMsgPath msgPath) {
        this.srpObject = srpObject;
        this.lspObject = lspObject;
        this.msgPath = msgPath;
    }

    @Override
    public PcepSrpObject getSrpObject() {
        return this.srpObject;
    }

    @Override
    public PcepLspObject getLspObject() {
        return this.lspObject;
    }

    @Override
    public PcepMsgPath getMsgPath() {
        return this.msgPath;
    }

    @Override
    public void setSrpObject(PcepSrpObject srpObject) {
        this.srpObject = srpObject;
    }

    @Override
    public void setLspObject(PcepLspObject lspObject) {
        this.lspObject = lspObject;
    }

    @Override
    public void setMsgPath(PcepMsgPath msgPath) {
        this.msgPath = msgPath;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("SrpObject", (Object)this.srpObject).add("LspObject", (Object)this.lspObject).add("MsgPath", (Object)this.msgPath).toString();
    }

    public static class Builder
    implements PcepUpdateRequest.Builder {
        private boolean bIsSrpObjectSet = false;
        private boolean bIsLspObjectSet = false;
        private boolean bIsPcepMsgPathSet = false;
        private PcepSrpObject srpObject;
        private PcepLspObject lspObject;
        private PcepMsgPath msgPath;

        @Override
        public PcepUpdateRequest build() throws PcepParseException {
            PcepSrpObject srpObject = null;
            PcepLspObject lspObject = null;
            PcepMsgPath msgPath = null;
            if (!this.bIsSrpObjectSet) {
                throw new PcepParseException(" SRP Object NOT Set while building PcepUpdateRequest.");
            }
            srpObject = this.srpObject;
            if (!this.bIsLspObjectSet) {
                throw new PcepParseException(" LSP Object NOT Set while building PcepUpdateRequest.");
            }
            lspObject = this.lspObject;
            if (!this.bIsPcepMsgPathSet) {
                throw new PcepParseException(" Msg Path NOT Set while building PcepUpdateRequest.");
            }
            msgPath = this.msgPath;
            return new PcepUpdateRequestVer1(srpObject, lspObject, msgPath);
        }

        @Override
        public PcepSrpObject getSrpObject() {
            return this.srpObject;
        }

        @Override
        public PcepLspObject getLspObject() {
            return this.lspObject;
        }

        @Override
        public PcepMsgPath getMsgPath() {
            return this.msgPath;
        }

        @Override
        public Builder setSrpObject(PcepSrpObject srpobj) {
            this.srpObject = srpobj;
            this.bIsSrpObjectSet = true;
            return this;
        }

        @Override
        public Builder setLspObject(PcepLspObject lspObject) {
            this.lspObject = lspObject;
            this.bIsLspObjectSet = true;
            return this;
        }

        @Override
        public Builder setMsgPath(PcepMsgPath msgPath) {
            this.msgPath = msgPath;
            this.bIsPcepMsgPathSet = true;
            return this;
        }
    }
}

