/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv4SubObject
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(IPv4SubObject.class);
    public static final byte TYPE = 1;
    public static final byte LENGTH = 8;
    public static final byte VALUE_LENGTH = 6;
    public static final byte OBJ_LENGTH = 8;
    public static final byte LBIT = 0;
    public static final int SHIFT_LBIT_POSITION = 7;
    private int ipAddress;
    private byte prefixLen;
    private byte resvd;

    public IPv4SubObject(int ipAddr) {
        this.ipAddress = ipAddr;
    }

    public IPv4SubObject(int ipAddress, byte prefixLen, byte resvd) {
        this.ipAddress = ipAddress;
        this.prefixLen = prefixLen;
        this.resvd = resvd;
    }

    public static IPv4SubObject of(int ipAddress, byte prefixLen, byte resvd) {
        return new IPv4SubObject(ipAddress, prefixLen, resvd);
    }

    public byte getPrefixLen() {
        return this.prefixLen;
    }

    public int getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 1;
    }

    @Override
    public short getLength() {
        return 8;
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.prefixLen, this.resvd);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IPv4SubObject) {
            IPv4SubObject other = (IPv4SubObject)obj;
            return Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.prefixLen, other.prefixLen) && Objects.equals(this.resvd, other.resvd);
        }
        return false;
    }

    public static PcepValueType read(ChannelBuffer c) {
        int ipAddess = c.readInt();
        byte prefixLen = c.readByte();
        byte resvd = c.readByte();
        return new IPv4SubObject(ipAddess, prefixLen, resvd);
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        int bValue = 0;
        bValue = (byte)(bValue << 7);
        bValue = (byte)(bValue | 1);
        c.writeByte(bValue);
        c.writeByte(8);
        c.writeInt(this.ipAddress);
        c.writeByte((int)this.prefixLen);
        c.writeByte((int)this.resvd);
        return c.writerIndex() - iLenStartIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 1).add("Length", 8).add("IPv4Address", this.ipAddress).add("PrefixLength", (int)this.prefixLen).toString();
    }
}

