/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv6InterfaceAddressSubTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(IPv6InterfaceAddressSubTlv.class);
    public static final short TYPE = 9;
    public static final short LENGTH = 20;
    public static final byte VALUE_LENGTH = 18;
    private static final byte[] NONE_VAL = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final IPv6InterfaceAddressSubTlv NONE = new IPv6InterfaceAddressSubTlv(NONE_VAL);
    private static final byte[] NO_MASK_VAL = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final IPv6InterfaceAddressSubTlv NO_MASK = new IPv6InterfaceAddressSubTlv(NO_MASK_VAL);
    public static final IPv6InterfaceAddressSubTlv FULL_MASK = NONE;
    private final byte[] rawValue;

    public IPv6InterfaceAddressSubTlv(byte[] rawValue) {
        log.debug("IPv6InterfaceAddressTlv");
        this.rawValue = rawValue;
    }

    public static IPv6InterfaceAddressSubTlv of(byte[] raw) {
        boolean bFoundNone = true;
        for (int i = 2; i < 20; ++i) {
            if (NONE_VAL[i] == raw[i]) continue;
            bFoundNone = false;
        }
        if (bFoundNone) {
            return NONE;
        }
        boolean bFoundNoMask = true;
        for (int i = 2; i < 20; ++i) {
            if (255 == raw[i]) continue;
            bFoundNoMask = false;
        }
        if (bFoundNoMask) {
            return NO_MASK;
        }
        return new IPv6InterfaceAddressSubTlv(raw);
    }

    public byte[] getBytes() {
        return this.rawValue;
    }

    public byte[] getValue() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 9;
    }

    @Override
    public short getLength() {
        return 20;
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IPv6InterfaceAddressSubTlv) {
            IPv6InterfaceAddressSubTlv other = (IPv6InterfaceAddressSubTlv)obj;
            return Arrays.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(9);
        c.writeShort(20);
        c.writeBytes(this.rawValue);
        return c.writerIndex() - iLenStartIndex;
    }

    public static IPv6InterfaceAddressSubTlv read20Bytes(ChannelBuffer c) {
        byte[] yTemp = new byte[20];
        c.readBytes(yTemp, 0, 20);
        return IPv6InterfaceAddressSubTlv.of(yTemp);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper(this.getClass());
        toStrHelper.add("Type", 9);
        toStrHelper.add("Length", 20);
        StringBuffer result = new StringBuffer();
        for (byte b : this.rawValue) {
            result.append(String.format("%02X ", b));
        }
        toStrHelper.add("Value", (Object)result);
        return toStrHelper.toString();
    }
}

