/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.IPv4InterfaceAddressSubTlv;
import org.onosproject.pcepio.types.IPv4NeighborAddressSubTlv;
import org.onosproject.pcepio.types.IPv6InterfaceAddressSubTlv;
import org.onosproject.pcepio.types.IPv6NeighborAddressSubTlv;
import org.onosproject.pcepio.types.LinkLocalRemoteIdentifiersSubTlv;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkDescriptorsTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(LinkDescriptorsTlv.class);
    public static final short TYPE = -252;
    public short hLength;
    public static final int TLV_HEADER_LENGTH = 4;
    private List<PcepValueType> llLinkDescriptorsSubTLVs;

    public LinkDescriptorsTlv(List<PcepValueType> llLinkDescriptorsSubTLVs) {
        this.llLinkDescriptorsSubTLVs = llLinkDescriptorsSubTLVs;
    }

    public static LinkDescriptorsTlv of(List<PcepValueType> llLinkDescriptorsSubTLVs) {
        return new LinkDescriptorsTlv(llLinkDescriptorsSubTLVs);
    }

    public List<PcepValueType> getllLinkDescriptorsSubTLVs() {
        return this.llLinkDescriptorsSubTLVs;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return -252;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(this.llLinkDescriptorsSubTLVs.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinkDescriptorsTlv) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            LinkDescriptorsTlv other = (LinkDescriptorsTlv)obj;
            Iterator<PcepValueType> objListIterator = ((LinkDescriptorsTlv)obj).llLinkDescriptorsSubTLVs.iterator();
            countObjSubTlv = ((LinkDescriptorsTlv)obj).llLinkDescriptorsSubTLVs.size();
            if (countObjSubTlv != (countOtherSubTlv = other.llLinkDescriptorsSubTLVs.size())) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                PcepValueType subTlv = objListIterator.next();
                isCommonSubTlv = Objects.equals(this.llLinkDescriptorsSubTLVs.contains(subTlv), other.llLinkDescriptorsSubTLVs.contains(subTlv));
            }
            return isCommonSubTlv;
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int tlvStartIndex = c.writerIndex();
        c.writeShort(-252);
        int tlvLenIndex = c.writerIndex();
        this.hLength = 0;
        c.writeShort((int)this.hLength);
        ListIterator<PcepValueType> listIterator = this.llLinkDescriptorsSubTLVs.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = listIterator.next();
            tlv.write(c);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                c.writeByte(0);
            }
        }
        this.hLength = (short)(c.writerIndex() - tlvStartIndex);
        c.setShort(tlvLenIndex, this.hLength - 4);
        return c.writerIndex() - tlvStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short length) throws PcepParseException {
        LinkedList<PcepValueType> llLinkDescriptorsSubTLVs = new LinkedList<PcepValueType>();
        ChannelBuffer tempCb = c.readBytes((int)length);
        while (4 <= tempCb.readableBytes()) {
            PcepValueType tlv;
            short hType = tempCb.readShort();
            int iValue = 0;
            short hLength = tempCb.readShort();
            log.debug("sub Tlv Length" + hLength);
            switch (hType) {
                case 6: {
                    tlv = LinkLocalRemoteIdentifiersSubTlv.read(tempCb);
                    break;
                }
                case 7: {
                    iValue = tempCb.readInt();
                    tlv = new IPv4InterfaceAddressSubTlv(iValue);
                    break;
                }
                case 8: {
                    iValue = tempCb.readInt();
                    tlv = new IPv4NeighborAddressSubTlv(iValue);
                    break;
                }
                case 9: {
                    byte[] ipv6Value = new byte[18];
                    tempCb.readBytes(ipv6Value, 0, 18);
                    tlv = new IPv6InterfaceAddressSubTlv(ipv6Value);
                    break;
                }
                case 10: {
                    byte[] ipv6NeighborAdd = new byte[18];
                    tempCb.readBytes(ipv6NeighborAdd, 0, 18);
                    tlv = new IPv6NeighborAddressSubTlv(ipv6NeighborAdd);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported Sub TLV type:" + hType);
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= tempCb.readableBytes()) {
                tempCb.skipBytes(pad);
            }
            llLinkDescriptorsSubTLVs.add(tlv);
        }
        if (0 < tempCb.readableBytes()) {
            throw new PcepParseException("Sub Tlv parsing error. Extra bytes received.");
        }
        return new LinkDescriptorsTlv(llLinkDescriptorsSubTLVs);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", -252).add("Length", (int)this.hLength).add("LinkDescriptorsSubTLVs", this.llLinkDescriptorsSubTLVs).toString();
    }
}

