/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkProtectionTypeSubTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(LinkProtectionTypeSubTlv.class);
    public static final short TYPE = 27;
    public static final short LENGTH = 2;
    private final byte protectionCap;
    private final byte reserved;

    public LinkProtectionTypeSubTlv(byte protectionCap) {
        this.protectionCap = protectionCap;
        this.reserved = 0;
    }

    public LinkProtectionTypeSubTlv(byte protectionCap, byte reserved) {
        this.protectionCap = protectionCap;
        this.reserved = reserved;
    }

    public byte getProtectionCap() {
        return this.protectionCap;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 27;
    }

    @Override
    public short getLength() {
        return 2;
    }

    public int hashCode() {
        return Objects.hash(this.protectionCap, this.reserved);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinkProtectionTypeSubTlv) {
            LinkProtectionTypeSubTlv other = (LinkProtectionTypeSubTlv)obj;
            return Objects.equals(this.protectionCap, other.protectionCap) && Objects.equals(this.reserved, other.reserved);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(27);
        c.writeShort(2);
        c.writeByte((int)this.protectionCap);
        c.writeByte((int)this.reserved);
        return c.writerIndex() - iLenStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c) {
        byte protectionCap = c.readByte();
        byte reserved = c.readByte();
        return new LinkProtectionTypeSubTlv(protectionCap, reserved);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 27).add("Length", 2).add("ProtectionCap", (int)this.protectionCap).toString();
    }
}

