/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.AutonomousSystemSubTlv;
import org.onosproject.pcepio.types.BgpLsIdentifierSubTlv;
import org.onosproject.pcepio.types.IgpRouterIdSubTlv;
import org.onosproject.pcepio.types.OspfAreaIdSubTlv;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalNodeDescriptorsTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(LocalNodeDescriptorsTlv.class);
    public static final short TYPE = -254;
    public short hLength;
    public static final int TLV_HEADER_LENGTH = 4;
    private List<PcepValueType> llNodeDescriptorSubTLVs;

    public LocalNodeDescriptorsTlv(List<PcepValueType> llNodeDescriptorSubTLVs) {
        this.llNodeDescriptorSubTLVs = llNodeDescriptorSubTLVs;
    }

    public static LocalNodeDescriptorsTlv of(List<PcepValueType> llNodeDescriptorSubTLVs) {
        return new LocalNodeDescriptorsTlv(llNodeDescriptorSubTLVs);
    }

    public List<PcepValueType> getllNodeDescriptorSubTLVs() {
        return this.llNodeDescriptorSubTLVs;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return -254;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(this.llNodeDescriptorSubTLVs.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocalNodeDescriptorsTlv) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            LocalNodeDescriptorsTlv other = (LocalNodeDescriptorsTlv)obj;
            Iterator<PcepValueType> objListIterator = ((LocalNodeDescriptorsTlv)obj).llNodeDescriptorSubTLVs.iterator();
            countObjSubTlv = ((LocalNodeDescriptorsTlv)obj).llNodeDescriptorSubTLVs.size();
            if (countObjSubTlv != (countOtherSubTlv = other.llNodeDescriptorSubTLVs.size())) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                PcepValueType subTlv = objListIterator.next();
                isCommonSubTlv = Objects.equals(this.llNodeDescriptorSubTLVs.contains(subTlv), other.llNodeDescriptorSubTLVs.contains(subTlv));
            }
            return isCommonSubTlv;
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int tlvStartIndex = c.writerIndex();
        c.writeShort(-254);
        int tlvLenIndex = c.writerIndex();
        this.hLength = 0;
        c.writeShort(0);
        ListIterator<PcepValueType> listIterator = this.llNodeDescriptorSubTLVs.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = listIterator.next();
            if (tlv == null) {
                log.debug("TLV is null from subTlv list");
                continue;
            }
            tlv.write(c);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                c.writeByte(0);
            }
        }
        this.hLength = (short)(c.writerIndex() - tlvStartIndex);
        c.setShort(tlvLenIndex, this.hLength - 4);
        return c.writerIndex() - tlvStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short hLength) throws PcepParseException {
        LinkedList<PcepValueType> llNodeDescriptorSubTLVs = new LinkedList<PcepValueType>();
        ChannelBuffer tempCb = c.readBytes((int)hLength);
        while (4 <= tempCb.readableBytes()) {
            PcepValueType tlv;
            short hType = tempCb.readShort();
            int iValue = 0;
            short length = tempCb.readShort();
            switch (hType) {
                case 1: {
                    iValue = tempCb.readInt();
                    tlv = new AutonomousSystemSubTlv(iValue);
                    break;
                }
                case 2: {
                    iValue = tempCb.readInt();
                    tlv = new BgpLsIdentifierSubTlv(iValue);
                    break;
                }
                case 3: {
                    iValue = tempCb.readInt();
                    tlv = new OspfAreaIdSubTlv(iValue);
                    break;
                }
                case 4: {
                    tlv = IgpRouterIdSubTlv.read(tempCb, length);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported Sub TLV type :" + hType);
                }
            }
            int pad = length % 4;
            if (0 < pad && (pad = 4 - pad) <= tempCb.readableBytes()) {
                tempCb.skipBytes(pad);
            }
            llNodeDescriptorSubTLVs.add(tlv);
        }
        if (0 < tempCb.readableBytes()) {
            throw new PcepParseException("Sub Tlv parsing error. Extra bytes received.");
        }
        return new LocalNodeDescriptorsTlv(llNodeDescriptorSubTLVs);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", -254).add("Length", (int)this.hLength).add("NodeDescriptorSubTLVs", this.llNodeDescriptorSubTLVs).toString();
    }
}

