/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MplsProtocolMaskSubTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(MplsProtocolMaskSubTlv.class);
    public static final short TYPE = 28;
    public static final short LENGTH = 1;
    public static final byte LFLAG_SET = -128;
    public static final byte RFLAG_SET = 64;
    private final byte rawValue;
    private final boolean bLFlag;
    private final boolean bRFlag;
    private final boolean isRawValueSet;

    public MplsProtocolMaskSubTlv(byte rawValue) {
        this.rawValue = rawValue;
        this.isRawValueSet = true;
        this.bLFlag = (rawValue & 0xFFFFFF80) == -128;
        this.bRFlag = (rawValue & 0x40) == 64;
    }

    public MplsProtocolMaskSubTlv(boolean bLFlag, boolean bRFlag) {
        this.bLFlag = bLFlag;
        this.bRFlag = bRFlag;
        this.rawValue = 0;
        this.isRawValueSet = false;
    }

    public static MplsProtocolMaskSubTlv of(byte raw) {
        return new MplsProtocolMaskSubTlv(raw);
    }

    public boolean getbLFlag() {
        return this.bLFlag;
    }

    public boolean getbRFlag() {
        return this.bRFlag;
    }

    public byte getByte() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 28;
    }

    @Override
    public short getLength() {
        return 1;
    }

    public int hashCode() {
        if (this.isRawValueSet) {
            return Objects.hash(this.rawValue);
        }
        return Objects.hash(this.bLFlag, this.bRFlag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MplsProtocolMaskSubTlv) {
            MplsProtocolMaskSubTlv other = (MplsProtocolMaskSubTlv)obj;
            if (this.isRawValueSet) {
                return Objects.equals(this.rawValue, other.rawValue);
            }
            return Objects.equals(this.bLFlag, other.bLFlag) && Objects.equals(this.bRFlag, other.bRFlag);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(28);
        c.writeShort(1);
        if (this.isRawValueSet) {
            c.writeByte((int)this.rawValue);
        } else {
            int temp = 0;
            if (this.bLFlag) {
                temp = (byte)(temp | 0xFFFFFF80);
            }
            if (this.bRFlag) {
                temp = (byte)(temp | 0x40);
            }
            c.writeByte(temp);
        }
        return c.writerIndex() - iLenStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c) {
        byte temp = c.readByte();
        boolean bLFlag = (temp & 0xFFFFFF80) == -128;
        boolean bRFlag = (temp & 0x40) == 64;
        return new MplsProtocolMaskSubTlv(bLFlag, bRFlag);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 28).add("Length", 1).add("Value", (int)this.rawValue).toString();
    }
}

