/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexthopIPv6addressTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(NexthopIPv6addressTlv.class);
    public static final short TYPE = 100;
    public static final short LENGTH = 20;
    public static final short VALUE_LENGTH = 16;
    private static final byte[] NONE_VAL = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final NexthopIPv6addressTlv NONE = new NexthopIPv6addressTlv(NONE_VAL);
    private static final byte[] NO_MASK_VAL = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final NexthopIPv6addressTlv NO_MASK = new NexthopIPv6addressTlv(NO_MASK_VAL);
    public static final NexthopIPv6addressTlv FULL_MASK = NONE;
    private final byte[] rawValue;

    public NexthopIPv6addressTlv(byte[] rawValue) {
        log.debug("NexthopIPv6addressTlv");
        this.rawValue = rawValue;
    }

    public static NexthopIPv6addressTlv of(byte[] raw) {
        boolean bFoundNone = true;
        for (int i = 5; i < 20; ++i) {
            if (NONE_VAL[i] == raw[i]) continue;
            bFoundNone = false;
        }
        if (bFoundNone) {
            return NONE;
        }
        boolean bFoundNoMask = true;
        for (int i = 5; i < 20; ++i) {
            if (255 == raw[i]) continue;
            bFoundNoMask = false;
        }
        if (bFoundNoMask) {
            return NO_MASK;
        }
        return new NexthopIPv6addressTlv(raw);
    }

    public byte[] getBytes() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 100;
    }

    @Override
    public short getLength() {
        return 20;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rawValue});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NexthopIPv6addressTlv) {
            NexthopIPv6addressTlv other = (NexthopIPv6addressTlv)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iStartIndex = c.writerIndex();
        c.writeShort(100);
        c.writeShort(20);
        c.writeBytes(this.rawValue);
        return c.writerIndex() - iStartIndex;
    }

    public static NexthopIPv6addressTlv read(ChannelBuffer c) {
        byte[] yTemp = new byte[20];
        c.readBytes(yTemp, 0, 20);
        return NexthopIPv6addressTlv.of(yTemp);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStrHelper = MoreObjects.toStringHelper(this.getClass());
        toStrHelper.add("Type", 100);
        toStrHelper.add("Length", 20);
        StringBuffer result = new StringBuffer();
        for (byte b : this.rawValue) {
            result.append(String.format("%02X ", b));
        }
        toStrHelper.add("IpAddress", (Object)result);
        return toStrHelper.toString();
    }
}

