/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OspfAreaIdSubTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(OspfAreaIdSubTlv.class);
    public static final short TYPE = 3;
    public static final short LENGTH = 4;
    private final int rawValue;

    public OspfAreaIdSubTlv(int rawValue) {
        this.rawValue = rawValue;
    }

    public static OspfAreaIdSubTlv of(int raw) {
        return new OspfAreaIdSubTlv(raw);
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        return Objects.hash(this.rawValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OspfAreaIdSubTlv) {
            OspfAreaIdSubTlv other = (OspfAreaIdSubTlv)obj;
            return Objects.equals(this.rawValue, other.rawValue);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(3);
        c.writeShort(4);
        c.writeInt(this.rawValue);
        return c.writerIndex() - iLenStartIndex;
    }

    public static OspfAreaIdSubTlv read(ChannelBuffer c) {
        return OspfAreaIdSubTlv.of(c.readInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 3).add("Length", 4).add("Value", this.rawValue).toString();
    }
}

