/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathKeySubObject
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(PathKeySubObject.class);
    public static final byte TYPE = 64;
    public static final byte LENGTH = 8;
    private final short pathKey;
    private final int pceID;

    public PathKeySubObject(short pathKey, int pceID) {
        this.pathKey = pathKey;
        this.pceID = pceID;
    }

    public static PathKeySubObject of(short pathKey, int pceID) {
        return new PathKeySubObject(pathKey, pceID);
    }

    public short getPathKey() {
        return this.pathKey;
    }

    public int getPceId() {
        return this.pceID;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 64;
    }

    @Override
    public short getLength() {
        return 8;
    }

    public int hashCode() {
        return Objects.hash(this.pathKey, this.pceID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PathKeySubObject) {
            PathKeySubObject other = (PathKeySubObject)obj;
            return Objects.equals(this.pathKey, other.pathKey) && Objects.equals(this.pceID, other.pceID);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(64);
        c.writeShort(8);
        c.writeShort((int)this.pathKey);
        c.writeInt(this.pceID);
        return c.writerIndex() - iLenStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c) {
        Short pathKey = c.readShort();
        int pceID = c.readInt();
        return new PathKeySubObject(pathKey, pceID);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", 64).add("Length", 8).add("PathKey", (int)this.pathKey).add("PceID", this.pceID).toString();
    }
}

