/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepNai;

public class PcepNaiIpv6NodeId
implements PcepNai {
    public static final byte ST_TYPE = 2;
    public static final byte IPV6_LEN = 16;
    private final byte[] ipv6NodeId;

    public PcepNaiIpv6NodeId(byte[] value) {
        this.ipv6NodeId = value;
    }

    public static PcepNaiIpv6NodeId of(byte[] ipv6NodeId) {
        return new PcepNaiIpv6NodeId(ipv6NodeId);
    }

    @Override
    public byte getType() {
        return 2;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeBytes(this.ipv6NodeId);
        return cb.writerIndex() - iLenStartIndex;
    }

    public static PcepNaiIpv6NodeId read(ChannelBuffer cb) {
        byte[] ipv6NodeId = new byte[16];
        cb.readBytes(ipv6NodeId, 0, 16);
        return new PcepNaiIpv6NodeId(ipv6NodeId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ipv6NodeId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PcepNaiIpv6NodeId) {
            PcepNaiIpv6NodeId other = (PcepNaiIpv6NodeId)obj;
            return Objects.equals(this.ipv6NodeId, other.ipv6NodeId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("IPV6NodeID", (Object)this.ipv6NodeId).toString();
    }
}

