/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepRsvpErrorSpec;
import org.onosproject.pcepio.types.PcepRsvpSpecObjHeader;

public class PcepRsvpIpv4ErrorSpec
implements PcepRsvpErrorSpec {
    PcepRsvpSpecObjHeader objHeader;
    public static final byte CLASS_NUM = 6;
    public static final byte CLASS_TYPE = 1;
    public static final byte CLASS_LENGTH = 12;
    private int ipv4Addr;
    private byte flags;
    private byte errCode;
    private short errValue;

    public PcepRsvpIpv4ErrorSpec(PcepRsvpSpecObjHeader objHeader, int ipv4Addr, byte flags, byte errCode, short errValue) {
        this.objHeader = objHeader;
        this.ipv4Addr = ipv4Addr;
        this.flags = flags;
        this.errCode = errCode;
        this.errValue = errValue;
    }

    public PcepRsvpIpv4ErrorSpec(int ipv4Addr, byte flags, byte errCode, short errValue) {
        this.objHeader = new PcepRsvpSpecObjHeader(12, 6, 1);
        this.ipv4Addr = ipv4Addr;
        this.flags = flags;
        this.errCode = errCode;
        this.errValue = errValue;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int objLenIndex = this.objHeader.write(cb);
        cb.writeInt(this.ipv4Addr);
        cb.writeByte((int)this.flags);
        cb.writeByte((int)this.errCode);
        cb.writeShort((int)this.errValue);
        short objLen = (short)(cb.writerIndex() - objLenIndex);
        cb.setShort(objLenIndex, (int)objLen);
        return objLen;
    }

    public static PcepRsvpErrorSpec read(ChannelBuffer cb) {
        PcepRsvpSpecObjHeader objHeader = PcepRsvpSpecObjHeader.read(cb);
        int ipv4Addr = cb.readInt();
        byte flags = cb.readByte();
        byte errCode = cb.readByte();
        short errValue = cb.readShort();
        return new PcepRsvpIpv4ErrorSpec(objHeader, ipv4Addr, flags, errCode, errValue);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 21;
    }

    @Override
    public short getLength() {
        return 12;
    }

    @Override
    public byte getClassNum() {
        return 6;
    }

    @Override
    public byte getClassType() {
        return 1;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("IPv4Address", this.ipv4Addr).add("flags", (int)this.flags).add("errorCode", (int)this.errCode).add("errorValue", (int)this.errValue).toString();
    }
}

