/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepRsvpErrorSpec;
import org.onosproject.pcepio.types.PcepRsvpSpecObjHeader;

public class PcepRsvpIpv6ErrorSpec
implements PcepRsvpErrorSpec {
    PcepRsvpSpecObjHeader objHeader;
    public static final byte CLASS_NUM = 6;
    public static final byte CLASS_TYPE = 2;
    public static final byte CLASS_LENGTH = 24;
    public static final byte IPV6_LEN = 16;
    private byte[] ipv6Addr;
    private byte flags;
    private byte errCode;
    private short errValue;

    public PcepRsvpIpv6ErrorSpec(PcepRsvpSpecObjHeader objHeader, byte[] ipv6Addr, byte flags, byte errCode, short errValue) {
        this.objHeader = objHeader;
        this.ipv6Addr = ipv6Addr;
        this.flags = flags;
        this.errCode = errCode;
        this.errValue = errValue;
    }

    public PcepRsvpIpv6ErrorSpec(byte[] ipv6Addr, byte flags, byte errCode, short errValue) {
        this.objHeader = new PcepRsvpSpecObjHeader(24, 6, 2);
        this.ipv6Addr = ipv6Addr;
        this.flags = flags;
        this.errCode = errCode;
        this.errValue = errValue;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int objLenIndex = this.objHeader.write(cb);
        cb.writeBytes(this.ipv6Addr);
        cb.writeByte((int)this.flags);
        cb.writeByte((int)this.errCode);
        cb.writeShort((int)this.errValue);
        short objLen = (short)(cb.writerIndex() - objLenIndex);
        cb.setShort(objLenIndex, (int)objLen);
        return objLen;
    }

    public static PcepRsvpErrorSpec read(ChannelBuffer cb) {
        byte[] ipv6Addr = new byte[16];
        PcepRsvpSpecObjHeader objHeader = PcepRsvpSpecObjHeader.read(cb);
        cb.readBytes(ipv6Addr, 0, 16);
        byte flags = cb.readByte();
        byte errCode = cb.readByte();
        short errValue = cb.readShort();
        return new PcepRsvpIpv6ErrorSpec(objHeader, ipv6Addr, flags, errCode, errValue);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 21;
    }

    @Override
    public short getLength() {
        return 24;
    }

    @Override
    public byte getClassNum() {
        return 6;
    }

    @Override
    public byte getClassType() {
        return 2;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("IPv6Address", (Object)this.ipv6Addr).add("flags", (int)this.flags).add("errorCode", (int)this.errCode).add("errorValue", (int)this.errValue).toString();
    }
}

