/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepRsvpObjectHeader {
    protected static final Logger log = LoggerFactory.getLogger(PcepRsvpObjectHeader.class);
    public static final boolean REQ_OBJ_MUST_PROCESS = true;
    public static final boolean REQ_OBJ_OPTIONAL_PROCESS = false;
    public static final boolean RSP_OBJ_IGNORED = true;
    public static final boolean RSP_OBJ_PROCESSED = false;
    public static final int OBJECT_TYPE_SHIFT_VALUE = 4;
    private byte objClassNum;
    private byte objClassType;
    private short objLen;

    public PcepRsvpObjectHeader(byte objClassNum, byte objClassType, short objLen) {
        this.objClassNum = objClassNum;
        this.objClassType = objClassType;
        this.objLen = objLen;
    }

    public void setObjClassNum(byte value) {
        this.objClassNum = value;
    }

    public void setObjClassType(byte value) {
        this.objClassType = value;
    }

    public void setObjLen(short value) {
        this.objLen = value;
    }

    public short getObjLen() {
        return this.objLen;
    }

    public byte getObjClassNum() {
        return this.objClassNum;
    }

    public byte getObjClassType() {
        return this.objClassType;
    }

    public int write(ChannelBuffer cb) {
        int iLenStartIndex = cb.writerIndex();
        cb.writeShort(0);
        cb.writeByte((int)this.objClassNum);
        cb.writeByte((int)this.objClassType);
        return cb.writerIndex() - iLenStartIndex;
    }

    public static PcepRsvpObjectHeader read(ChannelBuffer cb) {
        log.debug("read ");
        short objLen = cb.readShort();
        byte objClassNum = cb.readByte();
        byte objClassType = cb.readByte();
        return new PcepRsvpObjectHeader(objClassNum, objClassType, objLen);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ObjectClassNum", (int)this.objClassNum).add("ObjectCType", (int)this.objClassType).add("ObjectLength", (int)this.objLen).toString();
    }
}

