/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcepRsvpSpecObjHeader {
    protected static final Logger log = LoggerFactory.getLogger(PcepRsvpSpecObjHeader.class);
    private short objLen;
    private byte objClassNum;
    private byte objClassType;

    public PcepRsvpSpecObjHeader(short objLen, byte objClassNum, byte objClassType) {
        this.objLen = objLen;
        this.objClassNum = objClassNum;
        this.objClassType = objClassType;
    }

    public void setObjClassNum(byte value) {
        this.objClassNum = value;
    }

    public void setObjClassType(byte value) {
        this.objClassType = value;
    }

    public void setObjLen(short value) {
        this.objLen = value;
    }

    public short getObjLen() {
        return this.objLen;
    }

    public byte getObjClassNum() {
        return this.objClassNum;
    }

    public byte getObjClassType() {
        return this.objClassType;
    }

    public int write(ChannelBuffer cb) {
        int objLenIndex = cb.writerIndex();
        this.objLen = 0;
        cb.writeShort((int)this.objLen);
        cb.writeByte((int)this.objClassNum);
        cb.writeByte((int)this.objClassType);
        return objLenIndex;
    }

    public static PcepRsvpSpecObjHeader read(ChannelBuffer cb) {
        short objLen = cb.readShort();
        byte objClassNum = cb.readByte();
        byte objClassType = cb.readByte();
        return new PcepRsvpSpecObjHeader(objLen, objClassNum, objClassType);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ObjectClassNum: ", (int)this.objClassNum).add("ObjectCType: ", (int)this.objClassType).add("ObjectLength: ", (int)this.objLen).toString();
    }
}

