/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.AutonomousSystemSubTlv;
import org.onosproject.pcepio.types.PcepRsvpErrorSpec;
import org.onosproject.pcepio.types.PcepRsvpSpecObjHeader;
import org.onosproject.pcepio.types.PcepValueType;

public class PcepRsvpUserErrorSpec
implements PcepRsvpErrorSpec {
    public static final byte CLASS_NUM = -62;
    public static final byte CLASS_TYPE = 1;
    private PcepRsvpSpecObjHeader objHeader;
    private int enterpriseNum;
    private byte subOrg;
    private byte errDescLen;
    private short userErrorValue;
    private byte[] errDesc;
    private LinkedList<PcepValueType> llRsvpUserSpecSubObj;

    public PcepRsvpUserErrorSpec(PcepRsvpSpecObjHeader objHeader, int enterpriseNum, byte subOrg, byte errDescLen, short userErrorValue, byte[] errDesc, LinkedList<PcepValueType> llRsvpUserSpecSubObj) {
        this.objHeader = objHeader;
        this.enterpriseNum = enterpriseNum;
        this.subOrg = subOrg;
        this.errDescLen = errDescLen;
        this.userErrorValue = userErrorValue;
        this.errDesc = errDesc;
        this.llRsvpUserSpecSubObj = llRsvpUserSpecSubObj;
    }

    @Override
    public int write(ChannelBuffer cb) {
        int objLenIndex = this.objHeader.write(cb);
        cb.writeInt(this.enterpriseNum);
        cb.writeByte((int)this.subOrg);
        cb.writeByte((int)this.errDescLen);
        cb.writeShort((int)this.userErrorValue);
        cb.writeBytes(this.errDesc);
        if (this.llRsvpUserSpecSubObj != null) {
            ListIterator listIterator = this.llRsvpUserSpecSubObj.listIterator();
            while (listIterator.hasNext()) {
                PcepValueType tlv = (PcepValueType)listIterator.next();
                if (tlv == null) continue;
                tlv.write(cb);
                int pad = tlv.getLength() % 4;
                if (0 == pad) continue;
                pad = 4 - pad;
                for (int i = 0; i < pad; ++i) {
                    cb.writeByte(0);
                }
            }
        }
        short objLen = (short)(cb.writerIndex() - objLenIndex);
        cb.setShort(objLenIndex, (int)objLen);
        return objLen;
    }

    public static PcepRsvpErrorSpec read(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llRsvpUserSpecSubObj = null;
        PcepRsvpSpecObjHeader objHeader = PcepRsvpSpecObjHeader.read(cb);
        if (objHeader.getObjClassNum() != -62 || objHeader.getObjClassType() != 1) {
            throw new PcepParseException("Expected PcepRsvpUserErrorSpec object.");
        }
        int enterpriseNum = cb.readInt();
        byte subOrg = cb.readByte();
        byte errDescLen = cb.readByte();
        short userErrorValue = cb.readShort();
        byte[] errDesc = new byte[errDescLen];
        cb.readBytes(errDesc, 0, (int)errDescLen);
        llRsvpUserSpecSubObj = PcepRsvpUserErrorSpec.parseErrSpecSubObj(cb);
        return new PcepRsvpUserErrorSpec(objHeader, enterpriseNum, subOrg, errDescLen, userErrorValue, errDesc, llRsvpUserSpecSubObj);
    }

    private static LinkedList<PcepValueType> parseErrSpecSubObj(ChannelBuffer cb) throws PcepParseException {
        LinkedList<PcepValueType> llRsvpUserSpecSubObj = new LinkedList<PcepValueType>();
        while (0 < cb.readableBytes()) {
            AutonomousSystemSubTlv tlv = null;
            short hType = cb.readShort();
            int iValue = 0;
            switch (hType) {
                case 1: {
                    iValue = cb.readInt();
                    tlv = new AutonomousSystemSubTlv(iValue);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported Sub TLV type :" + hType);
                }
            }
            llRsvpUserSpecSubObj.add(tlv);
        }
        return llRsvpUserSpecSubObj;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 21;
    }

    @Override
    public short getLength() {
        return this.objHeader.getObjLen();
    }

    @Override
    public byte getClassNum() {
        return -62;
    }

    @Override
    public byte getClassType() {
        return 1;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("enterpriseNumber", this.enterpriseNum).add("subOrganization", (int)this.subOrg).add("errDescLength", (int)this.errDescLen).add("userErrorValue", (int)this.userErrorValue).add("errDesc", (Object)this.errDesc).add("RsvpUserSpecSubObject", this.llRsvpUserSpecSubObj).toString();
    }
}

