/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.AutonomousSystemSubTlv;
import org.onosproject.pcepio.types.BgpLsIdentifierSubTlv;
import org.onosproject.pcepio.types.IgpRouterIdSubTlv;
import org.onosproject.pcepio.types.OspfAreaIdSubTlv;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteNodeDescriptorsTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(RemoteNodeDescriptorsTlv.class);
    public static final short TYPE = -253;
    public short hLength;
    public static final int TLV_HEADER_LENGTH = 4;
    private List<PcepValueType> llRemoteTENodeDescriptorSubTLVs;

    public RemoteNodeDescriptorsTlv(List<PcepValueType> llRemoteTENodeDescriptorSubTLVs) {
        this.llRemoteTENodeDescriptorSubTLVs = llRemoteTENodeDescriptorSubTLVs;
    }

    public static RemoteNodeDescriptorsTlv of(List<PcepValueType> llRemoteTENodeDescriptorSubTLVs) {
        return new RemoteNodeDescriptorsTlv(llRemoteTENodeDescriptorSubTLVs);
    }

    public List<PcepValueType> getllRemoteTENodeDescriptorSubTLVs() {
        return this.llRemoteTENodeDescriptorSubTLVs;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return -253;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public int hashCode() {
        return Objects.hash(this.llRemoteTENodeDescriptorSubTLVs.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RemoteNodeDescriptorsTlv) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            RemoteNodeDescriptorsTlv other = (RemoteNodeDescriptorsTlv)obj;
            Iterator<PcepValueType> objListIterator = ((RemoteNodeDescriptorsTlv)obj).llRemoteTENodeDescriptorSubTLVs.iterator();
            countObjSubTlv = ((RemoteNodeDescriptorsTlv)obj).llRemoteTENodeDescriptorSubTLVs.size();
            if (countObjSubTlv != (countOtherSubTlv = other.llRemoteTENodeDescriptorSubTLVs.size())) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                PcepValueType subTlv = objListIterator.next();
                isCommonSubTlv = Objects.equals(this.llRemoteTENodeDescriptorSubTLVs.contains(subTlv), other.llRemoteTENodeDescriptorSubTLVs.contains(subTlv));
            }
            return isCommonSubTlv;
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int tlvStartIndex = c.writerIndex();
        c.writeShort(-253);
        int tlvLenIndex = c.writerIndex();
        this.hLength = 0;
        c.writeShort((int)this.hLength);
        ListIterator<PcepValueType> listIterator = this.llRemoteTENodeDescriptorSubTLVs.listIterator();
        while (listIterator.hasNext()) {
            PcepValueType tlv = listIterator.next();
            if (tlv == null) {
                log.debug("TLV is null from subTlv list");
                continue;
            }
            tlv.write(c);
            int pad = tlv.getLength() % 4;
            if (0 == pad) continue;
            pad = 4 - pad;
            for (int i = 0; i < pad; ++i) {
                c.writeByte(0);
            }
        }
        this.hLength = (short)(c.writerIndex() - tlvStartIndex);
        c.setShort(tlvLenIndex, this.hLength - 4);
        return c.writerIndex() - tlvStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c, short length) throws PcepParseException {
        LinkedList<PcepValueType> llRemoteTENodeDescriptorSubTLVs = new LinkedList<PcepValueType>();
        ChannelBuffer tempCb = c.readBytes((int)length);
        while (4 <= tempCb.readableBytes()) {
            PcepValueType tlv;
            short hType = tempCb.readShort();
            int iValue = 0;
            short hLength = tempCb.readShort();
            switch (hType) {
                case 1: {
                    iValue = tempCb.readInt();
                    tlv = new AutonomousSystemSubTlv(iValue);
                    break;
                }
                case 2: {
                    iValue = tempCb.readInt();
                    tlv = new BgpLsIdentifierSubTlv(iValue);
                    break;
                }
                case 3: {
                    iValue = tempCb.readInt();
                    tlv = new OspfAreaIdSubTlv(iValue);
                    break;
                }
                case 4: {
                    tlv = IgpRouterIdSubTlv.read(tempCb, hLength);
                    break;
                }
                default: {
                    throw new PcepParseException("Unsupported Sub TLV type :" + hType);
                }
            }
            int pad = hLength % 4;
            if (0 < pad && (pad = 4 - pad) <= tempCb.readableBytes()) {
                tempCb.skipBytes(pad);
            }
            llRemoteTENodeDescriptorSubTLVs.add(tlv);
        }
        if (0 < tempCb.readableBytes()) {
            throw new PcepParseException("Sub Tlv parsing error. Extra bytes received.");
        }
        return new RemoteNodeDescriptorsTlv(llRemoteTENodeDescriptorSubTLVs);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type", -253).add("Length", (int)this.hLength).add("RemoteTeNodeDescriptorSubTLVs", this.llRemoteTENodeDescriptorSubTLVs).toString();
    }
}

