/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulIPv4LspIdentidiersTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(StatefulIPv4LspIdentidiersTlv.class);
    public static final short TYPE = 18;
    public static final short LENGTH = 16;
    public static final int VALUE_LENGTH = 16;
    private final int ipv4IngressAddress;
    private final short lspId;
    private final short tunnelId;
    private final int extendedTunnelId;
    private final int ipv4EgressAddress;

    public StatefulIPv4LspIdentidiersTlv(int ipv4IngressAddress, short lspId, short tunnelId, int extendedTunnelId, int ipv4EgressAddress) {
        this.ipv4IngressAddress = ipv4IngressAddress;
        this.lspId = lspId;
        this.tunnelId = tunnelId;
        this.extendedTunnelId = extendedTunnelId;
        this.ipv4EgressAddress = ipv4EgressAddress;
    }

    public static StatefulIPv4LspIdentidiersTlv of(int ipv4IngressAddress, short lspId, short tunnelId, int extendedTunnelId, int ipv4EgressAddress) {
        return new StatefulIPv4LspIdentidiersTlv(ipv4IngressAddress, lspId, tunnelId, extendedTunnelId, ipv4EgressAddress);
    }

    public short getTunnelId() {
        return this.tunnelId;
    }

    public int getextendedTunnelId() {
        return this.extendedTunnelId;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    public int getIpv4IngressAddress() {
        return this.ipv4IngressAddress;
    }

    public int getIpv4EgressAddress() {
        return this.ipv4EgressAddress;
    }

    @Override
    public short getType() {
        return 18;
    }

    @Override
    public short getLength() {
        return 16;
    }

    public int hashCode() {
        return Objects.hash(this.ipv4IngressAddress, this.lspId, this.tunnelId, this.extendedTunnelId, this.ipv4EgressAddress);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StatefulIPv4LspIdentidiersTlv) {
            StatefulIPv4LspIdentidiersTlv other = (StatefulIPv4LspIdentidiersTlv)obj;
            return Objects.equals(this.ipv4IngressAddress, other.ipv4IngressAddress) && Objects.equals(this.lspId, other.lspId) && Objects.equals(this.tunnelId, other.tunnelId) && Objects.equals(this.extendedTunnelId, other.extendedTunnelId) && Objects.equals(this.ipv4EgressAddress, other.ipv4EgressAddress);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(18);
        c.writeShort(16);
        c.writeInt(this.ipv4IngressAddress);
        c.writeShort((int)this.lspId);
        c.writeShort((int)this.tunnelId);
        c.writeInt(this.extendedTunnelId);
        c.writeInt(this.ipv4EgressAddress);
        return c.writerIndex() - iLenStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c) {
        int ipv4IngressAddress = c.readInt();
        short lspId = c.readShort();
        short tunnelId = c.readShort();
        int extendedTunnelId = c.readInt();
        int ipv4EgressAddress = c.readInt();
        return new StatefulIPv4LspIdentidiersTlv(ipv4IngressAddress, lspId, tunnelId, extendedTunnelId, ipv4EgressAddress);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("Type:", 18).add("Length:", 16).add("Ipv4IngressAddress:", this.ipv4IngressAddress).add("LspId:", (int)this.lspId).add("TunnelId:", (int)this.tunnelId).add("ExtendedTunnelId:", this.extendedTunnelId).add("Ipv4EgressAddress:", this.ipv4EgressAddress).toString();
    }
}

