/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulPceCapabilityTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(StatefulPceCapabilityTlv.class);
    public static final short TYPE = 16;
    public static final short LENGTH = 4;
    public static final byte UFLAG_SET = 1;
    public static final byte SFLAG_SET = 2;
    public static final byte IFLAG_SET = 4;
    public static final byte TFLAG_SET = 8;
    public static final byte DFLAG_SET = 16;
    public static final int SET = 1;
    private final int rawValue;
    private final boolean bDFlag;
    private final boolean bTFlag;
    private final boolean bIFlag;
    private final boolean bSFlag;
    private final boolean bUFlag;
    private final boolean isRawValueSet;

    public StatefulPceCapabilityTlv(int rawValue) {
        this.rawValue = rawValue;
        this.isRawValueSet = true;
        this.bUFlag = (rawValue & 1) == 1;
        this.bSFlag = (rawValue & 2) == 2;
        this.bIFlag = (rawValue & 4) == 4;
        this.bTFlag = (rawValue & 8) == 8;
        this.bDFlag = (rawValue & 0x10) == 16;
    }

    public StatefulPceCapabilityTlv(boolean bDFlag, boolean bTFlag, boolean bIFlag, boolean bSFlag, boolean bUFlag) {
        this.bDFlag = bDFlag;
        this.bTFlag = bTFlag;
        this.bIFlag = bIFlag;
        this.bSFlag = bSFlag;
        this.bUFlag = bUFlag;
        this.rawValue = 0;
        this.isRawValueSet = false;
    }

    public static StatefulPceCapabilityTlv of(int raw) {
        return new StatefulPceCapabilityTlv(raw);
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    public boolean getDFlag() {
        return this.bDFlag;
    }

    public boolean getTFlag() {
        return this.bTFlag;
    }

    public boolean getIFlag() {
        return this.bIFlag;
    }

    public boolean getSFlag() {
        return this.bSFlag;
    }

    public boolean getUFlag() {
        return this.bUFlag;
    }

    public int getInt() {
        return this.rawValue;
    }

    @Override
    public short getType() {
        return 16;
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int hashCode() {
        if (this.isRawValueSet) {
            return Objects.hash(this.rawValue);
        }
        return Objects.hash(this.bDFlag, this.bTFlag, this.bIFlag, this.bSFlag, this.bUFlag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StatefulPceCapabilityTlv) {
            StatefulPceCapabilityTlv other = (StatefulPceCapabilityTlv)obj;
            if (this.isRawValueSet) {
                return Objects.equals(this.rawValue, other.rawValue);
            }
            return Objects.equals(this.bDFlag, other.bDFlag) && Objects.equals(this.bTFlag, other.bTFlag) && Objects.equals(this.bIFlag, other.bIFlag) && Objects.equals(this.bSFlag, other.bSFlag) && Objects.equals(this.bUFlag, other.bUFlag);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iLenStartIndex = c.writerIndex();
        c.writeShort(16);
        c.writeShort(4);
        if (this.isRawValueSet) {
            c.writeInt(this.rawValue);
        } else {
            int temp = 0;
            if (this.bUFlag) {
                temp |= 1;
            }
            if (this.bSFlag) {
                temp |= 2;
            }
            if (this.bIFlag) {
                temp |= 4;
            }
            if (this.bTFlag) {
                temp |= 8;
            }
            if (this.bDFlag) {
                temp |= 0x10;
            }
            c.writeInt(temp);
        }
        return c.writerIndex() - iLenStartIndex;
    }

    public static PcepValueType read(ChannelBuffer c) {
        int temp = c.readInt();
        boolean bUFlag = (temp & 1) == 1;
        boolean bSFlag = (temp & 2) == 2;
        boolean bIFlag = (temp & 4) == 4;
        boolean bTFlag = (temp & 8) == 8;
        boolean bDFlag = (temp & 0x10) == 16;
        return new StatefulPceCapabilityTlv(bDFlag, bTFlag, bIFlag, bSFlag, bUFlag);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", 16).add("Length", 4).add("DFlag", this.bDFlag).add("TFlag", this.bTFlag).add("IFlag", this.bIFlag).add("SFlag", this.bSFlag).add("UFlag", this.bUFlag).toString();
    }
}

