/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcepio.types;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcepVersion;
import org.onosproject.pcepio.types.PcepRsvpErrorSpec;
import org.onosproject.pcepio.types.PcepRsvpIpv4ErrorSpec;
import org.onosproject.pcepio.types.PcepRsvpIpv6ErrorSpec;
import org.onosproject.pcepio.types.PcepRsvpSpecObjHeader;
import org.onosproject.pcepio.types.PcepRsvpUserErrorSpec;
import org.onosproject.pcepio.types.PcepValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulRsvpErrorSpecTlv
implements PcepValueType {
    protected static final Logger log = LoggerFactory.getLogger(StatefulRsvpErrorSpecTlv.class);
    public static final short TYPE = 21;
    public static final int OBJECT_HEADER_LENGTH = 4;
    private short hLength;
    private final PcepRsvpErrorSpec rsvpErrSpecObj;
    private final boolean isErrSpceObjSet;

    public StatefulRsvpErrorSpecTlv(PcepRsvpErrorSpec rsvpErrSpecObj) {
        this.rsvpErrSpecObj = rsvpErrSpecObj;
        this.isErrSpceObjSet = true;
    }

    public PcepRsvpErrorSpec getPcepRsvpErrorSpec() {
        return this.rsvpErrSpecObj;
    }

    @Override
    public PcepVersion getVersion() {
        return PcepVersion.PCEP_1;
    }

    @Override
    public short getType() {
        return 21;
    }

    @Override
    public short getLength() {
        return this.hLength;
    }

    public static PcepValueType read(ChannelBuffer cb) throws PcepParseException {
        PcepRsvpErrorSpec rsvpErrSpecObj = null;
        cb.markReaderIndex();
        PcepRsvpSpecObjHeader rsvpErrSpecObjHeader = PcepRsvpSpecObjHeader.read(cb);
        cb.resetReaderIndex();
        if (6 == rsvpErrSpecObjHeader.getObjClassNum() && 1 == rsvpErrSpecObjHeader.getObjClassType()) {
            rsvpErrSpecObj = PcepRsvpIpv4ErrorSpec.read(cb);
        } else if (6 == rsvpErrSpecObjHeader.getObjClassNum() && 2 == rsvpErrSpecObjHeader.getObjClassType()) {
            rsvpErrSpecObj = PcepRsvpIpv6ErrorSpec.read(cb);
        } else if (-62 == rsvpErrSpecObjHeader.getObjClassNum() && 1 == rsvpErrSpecObjHeader.getObjClassType()) {
            rsvpErrSpecObj = PcepRsvpUserErrorSpec.read(cb);
        }
        return new StatefulRsvpErrorSpecTlv(rsvpErrSpecObj);
    }

    public int hashCode() {
        return Objects.hash(this.rsvpErrSpecObj.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StatefulRsvpErrorSpecTlv) {
            StatefulRsvpErrorSpecTlv other = (StatefulRsvpErrorSpecTlv)obj;
            return Objects.equals(this.rsvpErrSpecObj, other.rsvpErrSpecObj);
        }
        return false;
    }

    @Override
    public int write(ChannelBuffer c) {
        int iStartIndex = c.writerIndex();
        c.writeShort(21);
        int tlvLenIndex = c.writerIndex();
        this.hLength = 0;
        c.writeShort((int)this.hLength);
        if (this.isErrSpceObjSet) {
            this.rsvpErrSpecObj.write(c);
        }
        this.hLength = (short)(c.writerIndex() - iStartIndex);
        c.setShort(tlvLenIndex, this.hLength - 4);
        return c.writerIndex() - iStartIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("Type", 21).add("Length", (int)this.hLength).add("RSVPErrorSpecObject", (Object)this.rsvpErrSpecObj).toString();
    }
}

