/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.bgp.topology.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.TestUtils;
import org.onlab.packet.ChassisId;
import org.onlab.packet.Ip4Address;
import org.onlab.util.Bandwidth;
import org.onosproject.bgp.controller.BgpLinkListener;
import org.onosproject.bgp.controller.BgpNodeListener;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.NodeDescriptors;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetails;
import org.onosproject.bgpio.types.AutonomousSystemTlv;
import org.onosproject.bgpio.types.IsIsNonPseudonode;
import org.onosproject.bgpio.types.LinkLocalRemoteIdentifiersTlv;
import org.onosproject.bgpio.types.LinkStateAttributes;
import org.onosproject.bgpio.types.RouteDistinguisher;
import org.onosproject.bgpio.types.attr.BgpAttrNodeFlagBitTlv;
import org.onosproject.bgpio.types.attr.BgpAttrNodeIsIsAreaId;
import org.onosproject.bgpio.types.attr.BgpAttrRouterIdV4;
import org.onosproject.bgpio.types.attr.BgpLinkAttrIgpMetric;
import org.onosproject.bgpio.types.attr.BgpLinkAttrMaxLinkBandwidth;
import org.onosproject.bgpio.types.attr.BgpLinkAttrTeDefaultMetric;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.resource.label.LabelResourceAdminService;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourcePool;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistryAdapter;
import org.onosproject.net.config.basics.BandwidthCapacity;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAdminService;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.provider.bgp.topology.impl.BgpControllerAdapter;
import org.onosproject.provider.bgp.topology.impl.BgpTopologyProvider;

public class BgpTopologyProviderTest {
    private static final DeviceId DID2 = DeviceId.deviceId((String)"l3:rd=0::routinguniverse=0:asn=10");
    private static final String UNKNOWN = "unknown";
    public static ProviderId providerId = new ProviderId("l3", "foo");
    private static final NodeId NODE1 = new NodeId("Master1");
    private final BgpTopologyProvider provider = new BgpTopologyProvider();
    private final TestDeviceRegistry nodeRegistry = new TestDeviceRegistry();
    private final TestLinkRegistry linkRegistry = new TestLinkRegistry();
    private final MockBgpController controller = new MockBgpController();
    private MockDeviceService deviceService = new MockDeviceService();
    private MockLinkService linkService = new MockLinkService();
    private MockMastershipService mastershipService = new MockMastershipService();
    private MockNetConfigRegistryAdapter networkConfigService = new MockNetConfigRegistryAdapter();
    private MockLabelResourceService labelResourceAdminService = new MockLabelResourceService();
    private Map<DeviceId, Device> deviceMap = new HashMap<DeviceId, Device>();
    private DeviceListener listener;

    @Before
    public void startUp() throws TestUtils.TestUtilsException {
        this.provider.deviceProviderRegistry = this.nodeRegistry;
        this.provider.linkProviderRegistry = this.linkRegistry;
        this.provider.controller = this.controller;
        this.provider.deviceService = this.deviceService;
        this.provider.linkService = this.linkService;
        this.provider.labelResourceAdminService = this.labelResourceAdminService;
        this.provider.mastershipService = this.mastershipService;
        this.provider.networkConfigService = this.networkConfigService;
        this.listener = (DeviceListener)TestUtils.getField((Object)this.provider, (String)"deviceListener");
        this.provider.activate();
        MatcherAssert.assertThat((Object)"device provider should be registered", (Matcher)IsNot.not((Object)this.nodeRegistry.provider));
        MatcherAssert.assertThat((Object)"link provider should be registered", (Matcher)IsNot.not((Object)this.linkRegistry.linkProvider));
        MatcherAssert.assertThat((Object)"node listener should be registered", (Matcher)IsNot.not(this.controller.nodeListener));
        MatcherAssert.assertThat((Object)"link listener should be registered", (Matcher)IsNot.not(this.controller.linkListener));
    }

    @After
    public void tearDown() {
        this.provider.deactivate();
        this.provider.controller = null;
        this.provider.deviceService = null;
        this.provider.deviceProviderRegistry = null;
        this.provider.linkService = null;
        this.provider.mastershipService = null;
        this.provider.networkConfigService = null;
        this.provider.labelResourceAdminService = null;
        MatcherAssert.assertThat(this.controller.nodeListener, (Matcher)Is.is(new HashSet()));
        MatcherAssert.assertThat(this.controller.linkListener, (Matcher)Is.is(new HashSet()));
    }

    @Test
    public void bgpTopologyProviderTestAddDevice1() {
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(100);
        short deslength = 4;
        short desType = 512;
        subTlvs.add(tlv);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(new NodeDescriptors(subTlvs, deslength, desType));
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setIdentifier(0L);
        details.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.DIRECT);
        LinkedList pathAttributes = new LinkedList();
        details.setPathAttribute(pathAttributes);
        for (BgpNodeListener l : this.controller.nodeListener) {
            l.addNode(nodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)1));
            l.deleteNode(nodeNlri);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    public void bgpTopologyProviderTestAddDevice2() {
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(10);
        short deslength = 4;
        short desType = 512;
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setIdentifier(0L);
        details.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.DIRECT);
        LinkedList pathAttributes = new LinkedList();
        details.setPathAttribute(pathAttributes);
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        subTlvs.add(tlv);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(new NodeDescriptors(subTlvs, deslength, desType));
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        for (BgpNodeListener l : this.controller.nodeListener) {
            l.addNode(nodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    public void bgpTopologyProviderTestAddDevice3() {
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(10);
        short deslength = 4;
        short desType = 512;
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        subTlvs.add(tlv);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(new NodeDescriptors(subTlvs, deslength, desType));
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        for (BgpNodeListener l : this.controller.nodeListener) {
            l.deleteNode(nodeNlri);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    public void bgpTopologyProviderTestAddDevice4() {
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(100);
        short deslength = 4;
        short desType = 512;
        subTlvs.add(tlv);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(new NodeDescriptors(subTlvs, deslength, desType));
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setIdentifier(0L);
        details.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.DIRECT);
        LinkedList<LinkStateAttributes> pathAttributes = new LinkedList<LinkStateAttributes>();
        LinkedList<AutonomousSystemTlv> linkStateAttr = new LinkedList<AutonomousSystemTlv>();
        tlv = BgpAttrNodeFlagBitTlv.of((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        linkStateAttr.add(tlv);
        tlv = BgpAttrNodeIsIsAreaId.of((byte[])new byte[]{1, 1, 1, 1});
        linkStateAttr.add(tlv);
        tlv = BgpAttrRouterIdV4.of((Ip4Address)Ip4Address.valueOf((String)"1.1.1.1"), (short)1028);
        linkStateAttr.add(tlv);
        pathAttributes.add(new LinkStateAttributes(linkStateAttr));
        details.setPathAttribute(pathAttributes);
        for (BgpNodeListener l : this.controller.nodeListener) {
            l.addNode(nodeNlri, details);
            MatcherAssert.assertThat((Object)this.deviceMap.values().iterator().next().annotations().value("abrBit"), (Matcher)Is.is((Object)"false"));
            MatcherAssert.assertThat((Object)this.deviceMap.values().iterator().next().annotations().value("externalBit"), (Matcher)Is.is((Object)"true"));
            MatcherAssert.assertThat((Object)this.deviceMap.values().iterator().next().annotations().value("internalBit"), (Matcher)Is.is((Object)"false"));
            MatcherAssert.assertThat((Object)this.deviceMap.values().iterator().next().annotations().value("psuedo"), (Matcher)Is.is((Object)"false"));
            MatcherAssert.assertThat((Object)this.deviceMap.values().iterator().next().annotations().value("areaId").getBytes(), (Matcher)Is.is((Object)new byte[]{1, 1, 1, 1}));
            MatcherAssert.assertThat((Object)this.deviceMap.values().iterator().next().annotations().value("lsrId"), (Matcher)Is.is((Object)"1.1.1.1"));
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)1));
            l.deleteNode(nodeNlri);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    public void bgpTopologyProviderTestAddLink1() throws BgpParseException {
        LinkedList<AutonomousSystemTlv> localTlvs = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> remoteTlvs = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> linkdes = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(10);
        short deslength = 4;
        short desType = 512;
        localTlvs.add(tlv);
        remoteTlvs.add(tlv);
        tlv = IsIsNonPseudonode.of((byte[])new byte[]{20, 20, 20, 20, 0, 20});
        localTlvs.add(tlv);
        tlv = IsIsNonPseudonode.of((byte[])new byte[]{30, 30, 30, 30, 0, 30});
        remoteTlvs.add(tlv);
        NodeDescriptors localNode = new NodeDescriptors(localTlvs, deslength, desType);
        NodeDescriptors remoteNode = new NodeDescriptors(remoteTlvs, deslength, desType);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(localNode);
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        BgpNodeLSIdentifier remoteNodeDescriptors = new BgpNodeLSIdentifier(remoteNode);
        BgpNodeLSNlriVer4 remNodeNlri = new BgpNodeLSNlriVer4(0L, 4, remoteNodeDescriptors, false, new RouteDistinguisher());
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setIdentifier(0L);
        details.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.DIRECT);
        LinkedList pathAttributes = new LinkedList();
        details.setPathAttribute(pathAttributes);
        tlv = LinkLocalRemoteIdentifiersTlv.of((int)99, (int)100);
        linkdes.add(tlv);
        BgpLinkLSIdentifier linkId = new BgpLinkLSIdentifier(localNode, remoteNode, linkdes);
        BgpLinkLsNlriVer4 linkNlri = new BgpLinkLsNlriVer4(4, 0L, linkId, new RouteDistinguisher(), false);
        for (BgpNodeListener bgpNodeListener : this.controller.nodeListener) {
            bgpNodeListener.addNode(nodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)1));
            bgpNodeListener.addNode(remNodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)2));
        }
        for (BgpLinkListener bgpLinkListener : this.controller.linkListener) {
            bgpLinkListener.addLink(linkNlri, details);
            MatcherAssert.assertThat((Object)this.linkRegistry.links.size(), (Matcher)Is.is((Object)1));
        }
    }

    @Test
    public void bgpTopologyProviderTestAddLink2() throws BgpParseException {
        LinkedList<AutonomousSystemTlv> localTlvs = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> remoteTlvs = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> linkdes = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(10);
        short deslength = 4;
        short desType = 512;
        localTlvs.add(tlv);
        remoteTlvs.add(tlv);
        tlv = IsIsNonPseudonode.of((byte[])new byte[]{20, 20, 20, 20, 0, 20});
        localTlvs.add(tlv);
        tlv = IsIsNonPseudonode.of((byte[])new byte[]{30, 30, 30, 30, 0, 30});
        remoteTlvs.add(tlv);
        NodeDescriptors localNode = new NodeDescriptors(localTlvs, deslength, desType);
        NodeDescriptors remoteNode = new NodeDescriptors(remoteTlvs, deslength, desType);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(localNode);
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        BgpNodeLSIdentifier remoteNodeDescriptors = new BgpNodeLSIdentifier(remoteNode);
        BgpNodeLSNlriVer4 remNodeNlri = new BgpNodeLSNlriVer4(0L, 4, remoteNodeDescriptors, false, new RouteDistinguisher());
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setIdentifier(0L);
        details.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.DIRECT);
        LinkedList pathAttributes = new LinkedList();
        details.setPathAttribute(pathAttributes);
        tlv = LinkLocalRemoteIdentifiersTlv.of((int)99, (int)100);
        linkdes.add(tlv);
        BgpLinkLSIdentifier linkId = new BgpLinkLSIdentifier(localNode, remoteNode, linkdes);
        BgpLinkLsNlriVer4 linkNlri = new BgpLinkLsNlriVer4(4, 0L, linkId, new RouteDistinguisher(), false);
        for (BgpNodeListener bgpNodeListener : this.controller.nodeListener) {
            bgpNodeListener.addNode(nodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)1));
            bgpNodeListener.addNode(remNodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)2));
            bgpNodeListener.deleteNode(nodeNlri);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)1));
        }
        for (BgpLinkListener bgpLinkListener : this.controller.linkListener) {
            bgpLinkListener.addLink(linkNlri, details);
            MatcherAssert.assertThat((Object)this.linkRegistry.links.size(), (Matcher)Is.is((Object)1));
            bgpLinkListener.deleteLink(linkNlri);
            MatcherAssert.assertThat((Object)this.linkRegistry.links.size(), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    public void bgpTopologyProviderTestAddLink3() throws BgpParseException, InterruptedException {
        LinkedList<AutonomousSystemTlv> localTlvs = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> remoteTlvs = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> linkdes = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(10);
        short deslength = 4;
        short desType = 512;
        localTlvs.add(tlv);
        remoteTlvs.add(tlv);
        tlv = IsIsNonPseudonode.of((byte[])new byte[]{20, 20, 20, 20, 0, 20});
        localTlvs.add(tlv);
        tlv = IsIsNonPseudonode.of((byte[])new byte[]{30, 30, 30, 30, 0, 30});
        remoteTlvs.add(tlv);
        NodeDescriptors localNode = new NodeDescriptors(localTlvs, deslength, desType);
        NodeDescriptors remoteNode = new NodeDescriptors(remoteTlvs, deslength, desType);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(localNode);
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        BgpNodeLSIdentifier remoteNodeDescriptors = new BgpNodeLSIdentifier(remoteNode);
        BgpNodeLSNlriVer4 remNodeNlri = new BgpNodeLSNlriVer4(0L, 4, remoteNodeDescriptors, false, new RouteDistinguisher());
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setIdentifier(0L);
        details.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.DIRECT);
        LinkedList pathAttributes = new LinkedList();
        details.setPathAttribute(pathAttributes);
        tlv = LinkLocalRemoteIdentifiersTlv.of((int)99, (int)100);
        linkdes.add(tlv);
        BgpLinkLSIdentifier linkId = new BgpLinkLSIdentifier(localNode, remoteNode, linkdes);
        BgpLinkLsNlriVer4 linkNlri = new BgpLinkLsNlriVer4(4, 0L, linkId, new RouteDistinguisher(), false);
        for (BgpNodeListener l : this.controller.nodeListener) {
            l.addNode(nodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)1));
            l.addNode(remNodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)2));
            l.deleteNode(remNodeNlri);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)1));
        }
        LinkedList<LinkStateAttributes> linkPathAttributes = new LinkedList<LinkStateAttributes>();
        LinkedList<AutonomousSystemTlv> linkStateAttr = new LinkedList<AutonomousSystemTlv>();
        tlv = BgpLinkAttrIgpMetric.of((int)10, (int)4);
        linkStateAttr.add(tlv);
        tlv = BgpLinkAttrTeDefaultMetric.of((int)20);
        linkStateAttr.add(tlv);
        tlv = BgpLinkAttrMaxLinkBandwidth.of((float)30.0f, (short)1090);
        linkStateAttr.add(tlv);
        linkPathAttributes.add(new LinkStateAttributes(linkStateAttr));
        details.setPathAttribute(linkPathAttributes);
        for (BgpLinkListener l : this.controller.linkListener) {
            l.addLink(linkNlri, details);
            MatcherAssert.assertThat((Object)this.linkRegistry.links.size(), (Matcher)Is.is((Object)1));
            MatcherAssert.assertThat((Object)this.linkRegistry.links.iterator().next().annotations().value("cost"), (Matcher)Is.is((Object)"10"));
            MatcherAssert.assertThat((Object)this.linkRegistry.links.iterator().next().annotations().value("teCost"), (Matcher)Is.is((Object)"20"));
            l.deleteLink(linkNlri);
            MatcherAssert.assertThat((Object)this.linkRegistry.links.size(), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    public void bgpTopologyProviderTestDeleteLink3() throws BgpParseException {
        LinkedList<AutonomousSystemTlv> localTlvs = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> remoteTlvs = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> linkdes = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(10);
        short deslength = 4;
        short desType = 512;
        localTlvs.add(tlv);
        remoteTlvs.add(tlv);
        tlv = IsIsNonPseudonode.of((byte[])new byte[]{20, 20, 20, 20, 0, 20});
        localTlvs.add(tlv);
        tlv = IsIsNonPseudonode.of((byte[])new byte[]{30, 30, 30, 30, 0, 30});
        remoteTlvs.add(tlv);
        NodeDescriptors localNode = new NodeDescriptors(localTlvs, deslength, desType);
        NodeDescriptors remoteNode = new NodeDescriptors(remoteTlvs, deslength, desType);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(localNode);
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        BgpNodeLSIdentifier remoteNodeDescriptors = new BgpNodeLSIdentifier(remoteNode);
        BgpNodeLSNlriVer4 remNodeNlri = new BgpNodeLSNlriVer4(0L, 4, remoteNodeDescriptors, false, new RouteDistinguisher());
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setIdentifier(0L);
        details.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.DIRECT);
        LinkedList pathAttributes = new LinkedList();
        details.setPathAttribute(pathAttributes);
        tlv = LinkLocalRemoteIdentifiersTlv.of((int)99, (int)100);
        linkdes.add(tlv);
        BgpLinkLSIdentifier linkId = new BgpLinkLSIdentifier(localNode, remoteNode, linkdes);
        BgpLinkLsNlriVer4 linkNlri = new BgpLinkLsNlriVer4(4, 0L, linkId, new RouteDistinguisher(), false);
        for (BgpNodeListener bgpNodeListener : this.controller.nodeListener) {
            bgpNodeListener.addNode(nodeNlri, details);
            bgpNodeListener.addNode(remNodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)2));
            bgpNodeListener.deleteNode(nodeNlri);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)1));
        }
        for (BgpLinkListener bgpLinkListener : this.controller.linkListener) {
            bgpLinkListener.deleteLink(linkNlri);
            MatcherAssert.assertThat((Object)this.linkRegistry.links.size(), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    public void bgpTopologyProviderDeviceTestLabel1() throws BgpParseException {
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(100);
        short deslength = 4;
        short desType = 512;
        subTlvs.add(tlv);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(new NodeDescriptors(subTlvs, deslength, desType));
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setIdentifier(0L);
        details.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.DIRECT);
        LinkedList<LinkStateAttributes> pathAttributes = new LinkedList<LinkStateAttributes>();
        LinkedList<AutonomousSystemTlv> linkStateAttributes = new LinkedList<AutonomousSystemTlv>();
        tlv = BgpAttrRouterIdV4.of((Ip4Address)Ip4Address.valueOf((String)"1.1.1.1"), (short)1028);
        linkStateAttributes.add(tlv);
        pathAttributes.add(new LinkStateAttributes(linkStateAttributes));
        details.setPathAttribute(pathAttributes);
        for (BgpNodeListener l : this.controller.nodeListener) {
            l.addNode(nodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)1));
        }
        DefaultAnnotations.Builder newBuilder = DefaultAnnotations.builder();
        newBuilder.set("lsrId", "1.1.1.1");
        DefaultDevice device = new DefaultDevice(providerId, this.nodeRegistry.connected.iterator().next(), Device.Type.ROUTER, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, new ChassisId(), new Annotations[]{newBuilder.build()});
        DeviceEvent event = new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, (Device)device);
        this.listener.event((Event)event);
        MatcherAssert.assertThat((Object)this.labelResourceAdminService.resourcePool.keySet().size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void bgpTopologyProviderDeviceTestLabel2() throws BgpParseException {
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(100);
        short deslength = 4;
        short desType = 512;
        subTlvs.add(tlv);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(new NodeDescriptors(subTlvs, deslength, desType));
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setIdentifier(0L);
        details.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.DIRECT);
        LinkedList<LinkStateAttributes> pathAttributes = new LinkedList<LinkStateAttributes>();
        LinkedList<AutonomousSystemTlv> linkStateAttributes = new LinkedList<AutonomousSystemTlv>();
        tlv = BgpAttrRouterIdV4.of((Ip4Address)Ip4Address.valueOf((String)"1.1.1.1"), (short)1028);
        linkStateAttributes.add(tlv);
        pathAttributes.add(new LinkStateAttributes(linkStateAttributes));
        details.setPathAttribute(pathAttributes);
        for (BgpNodeListener l : this.controller.nodeListener) {
            l.addNode(nodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)1));
            DefaultAnnotations.Builder newBuilder = DefaultAnnotations.builder();
            newBuilder.set("lsrId", "1.1.1.1");
            DefaultDevice device = new DefaultDevice(providerId, this.nodeRegistry.connected.iterator().next(), Device.Type.ROUTER, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, new ChassisId(), new Annotations[]{newBuilder.build()});
            DeviceEvent event = new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, (Device)device);
            this.listener.event((Event)event);
            MatcherAssert.assertThat((Object)this.labelResourceAdminService.resourcePool.keySet().size(), (Matcher)Is.is((Object)1));
            l.deleteNode(nodeNlri);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)0));
            MatcherAssert.assertThat((Object)this.labelResourceAdminService.resourcePool.keySet().size(), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    public void bgpTopologyProviderDeviceTestLabel3() throws BgpParseException {
        LinkedList<AutonomousSystemTlv> localTlvs = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> remoteTlvs = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> linkdes = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(10);
        short deslength = 4;
        short desType = 512;
        localTlvs.add(tlv);
        remoteTlvs.add(tlv);
        tlv = IsIsNonPseudonode.of((byte[])new byte[]{20, 20, 20, 20, 0, 20});
        localTlvs.add(tlv);
        tlv = IsIsNonPseudonode.of((byte[])new byte[]{30, 30, 30, 30, 0, 30});
        remoteTlvs.add(tlv);
        NodeDescriptors localNode = new NodeDescriptors(localTlvs, deslength, desType);
        NodeDescriptors remoteNode = new NodeDescriptors(remoteTlvs, deslength, desType);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(localNode);
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        BgpNodeLSIdentifier remoteNodeDescriptors = new BgpNodeLSIdentifier(remoteNode);
        BgpNodeLSNlriVer4 remNodeNlri = new BgpNodeLSNlriVer4(0L, 4, remoteNodeDescriptors, false, new RouteDistinguisher());
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setIdentifier(0L);
        details.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.DIRECT);
        LinkedList<LinkStateAttributes> pathAttributes = new LinkedList<LinkStateAttributes>();
        LinkedList<AutonomousSystemTlv> linkStateAttributes = new LinkedList<AutonomousSystemTlv>();
        tlv = BgpAttrRouterIdV4.of((Ip4Address)Ip4Address.valueOf((String)"1.1.1.1"), (short)1028);
        linkStateAttributes.add(tlv);
        pathAttributes.add(new LinkStateAttributes(linkStateAttributes));
        details.setPathAttribute(pathAttributes);
        tlv = LinkLocalRemoteIdentifiersTlv.of((int)99, (int)100);
        linkdes.add(tlv);
        BgpLinkLSIdentifier linkId = new BgpLinkLSIdentifier(localNode, remoteNode, linkdes);
        BgpLinkLsNlriVer4 linkNlri = new BgpLinkLsNlriVer4(4, 0L, linkId, new RouteDistinguisher(), false);
        for (BgpNodeListener l : this.controller.nodeListener) {
            l.addNode(nodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)1));
            DefaultAnnotations.Builder newBuilder = DefaultAnnotations.builder();
            newBuilder.set("lsrId", "1.1.1.1");
            DefaultDevice device = new DefaultDevice(providerId, this.nodeRegistry.connected.iterator().next(), Device.Type.ROUTER, UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN, new ChassisId(), new Annotations[]{newBuilder.build()});
            DeviceEvent event = new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, (Device)device);
            this.listener.event((Event)event);
            MatcherAssert.assertThat((Object)this.labelResourceAdminService.resourcePool.keySet().size(), (Matcher)Is.is((Object)1));
            l.addNode(remNodeNlri, details);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)2));
            l.deleteNode(remNodeNlri);
            MatcherAssert.assertThat((Object)this.nodeRegistry.connected.size(), (Matcher)Is.is((Object)1));
            MatcherAssert.assertThat((Object)this.labelResourceAdminService.resourcePool.keySet().size(), (Matcher)Is.is((Object)1));
        }
        LinkedList<LinkStateAttributes> linkPathAttributes = new LinkedList<LinkStateAttributes>();
        LinkedList<AutonomousSystemTlv> linkStateAttr = new LinkedList<AutonomousSystemTlv>();
        tlv = BgpLinkAttrIgpMetric.of((int)10, (int)4);
        linkStateAttr.add(tlv);
        tlv = BgpLinkAttrTeDefaultMetric.of((int)20);
        linkStateAttr.add(tlv);
        tlv = BgpLinkAttrMaxLinkBandwidth.of((float)7.0E7f, (short)1090);
        linkStateAttr.add(tlv);
        linkPathAttributes.add(new LinkStateAttributes(linkStateAttr));
        details.setPathAttribute(linkPathAttributes);
        for (BgpLinkListener l : this.controller.linkListener) {
            l.addLink(linkNlri, details);
            MatcherAssert.assertThat((Object)this.linkRegistry.links.size(), (Matcher)Is.is((Object)1));
            MatcherAssert.assertThat((Object)this.linkRegistry.links.iterator().next().annotations().value("cost"), (Matcher)Is.is((Object)"10"));
            MatcherAssert.assertThat((Object)this.linkRegistry.links.iterator().next().annotations().value("teCost"), (Matcher)Is.is((Object)"20"));
            ConnectPoint src = new ConnectPoint((ElementId)DeviceId.deviceId((String)"l3:rd=0::routinguniverse=0:asn=10:isoid=1414.1414.0014"), PortNumber.portNumber((long)4294967395L));
            ConnectPoint dst = new ConnectPoint((ElementId)DeviceId.deviceId((String)"l3:rd=0::routinguniverse=0:asn=10:isoid=1e1e.1e1e.001e"), PortNumber.portNumber((long)4294967396L));
            BandwidthCapacity bandwidth = this.networkConfigService.getConfig(src, BandwidthCapacity.class);
            MatcherAssert.assertThat((Object)bandwidth.capacity().bps(), (Matcher)Is.is((Object)7.0E7));
            bandwidth = this.networkConfigService.getConfig(dst, BandwidthCapacity.class);
            MatcherAssert.assertThat((Object)bandwidth.capacity(), (Matcher)Is.is((Object)Bandwidth.bps((double)7.0E7)));
            l.deleteLink(linkNlri);
            MatcherAssert.assertThat((Object)this.linkRegistry.links.size(), (Matcher)Is.is((Object)0));
            bandwidth = this.networkConfigService.getConfig(src, BandwidthCapacity.class);
            MatcherAssert.assertThat((Object)bandwidth, (Matcher)Is.is((Matcher)Matchers.nullValue()));
            bandwidth = this.networkConfigService.getConfig(dst, BandwidthCapacity.class);
            MatcherAssert.assertThat((Object)bandwidth, (Matcher)Is.is((Matcher)Matchers.nullValue()));
        }
    }

    private class MockDeviceService
    extends DeviceServiceAdapter {
        private MockDeviceService() {
        }

        public Device getDevice(DeviceId deviceId) {
            return (Device)BgpTopologyProviderTest.this.deviceMap.get(deviceId);
        }
    }

    private class MockBgpController
    extends BgpControllerAdapter {
        protected Set<BgpNodeListener> nodeListener = new CopyOnWriteArraySet<BgpNodeListener>();
        protected Set<BgpLinkListener> linkListener = new CopyOnWriteArraySet<BgpLinkListener>();

        private MockBgpController() {
        }

        @Override
        public void addListener(BgpNodeListener nodeListener) {
            this.nodeListener.add(nodeListener);
        }

        @Override
        public void removeListener(BgpNodeListener nodeListener) {
            this.nodeListener.remove(nodeListener);
        }

        @Override
        public void addLinkListener(BgpLinkListener linkListener) {
            this.linkListener.add(linkListener);
        }

        @Override
        public void removeLinkListener(BgpLinkListener linkListener) {
            this.linkListener.remove(linkListener);
        }
    }

    private class TestLinkRegistry
    implements LinkProviderRegistry {
        LinkProvider linkProvider;
        Set<Link> links = new HashSet<Link>();

        private TestLinkRegistry() {
        }

        public LinkProviderService register(LinkProvider provider) {
            this.linkProvider = provider;
            return new TestProviderService();
        }

        public void unregister(LinkProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }

        private class TestProviderService
        implements LinkProviderService {
            private TestProviderService() {
            }

            public void linkDetected(LinkDescription linkDescription) {
                TestLinkRegistry.this.links.add((Link)DefaultLink.builder().src(linkDescription.src()).dst(linkDescription.dst()).state(Link.State.ACTIVE).type(linkDescription.type()).providerId(providerId).annotations((Annotations)linkDescription.annotations()).build());
            }

            public void linkVanished(LinkDescription linkDescription) {
                TestLinkRegistry.this.links.remove(DefaultLink.builder().src(linkDescription.src()).dst(linkDescription.dst()).state(Link.State.ACTIVE).type(linkDescription.type()).providerId(providerId).build());
            }

            public void linksVanished(ConnectPoint connectPoint) {
            }

            public void linksVanished(DeviceId deviceId) {
            }

            public LinkProvider provider() {
                return null;
            }
        }
    }

    private class TestDeviceRegistry
    implements DeviceProviderRegistry {
        DeviceProvider provider;
        Set<DeviceId> connected = new HashSet<DeviceId>();
        Map<DeviceId, List<PortDescription>> portUpdated = new HashMap<DeviceId, List<PortDescription>>();

        private TestDeviceRegistry() {
        }

        public DeviceProviderService register(DeviceProvider provider) {
            this.provider = provider;
            return new TestProviderService();
        }

        public void unregister(DeviceProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }

        private class TestProviderService
        implements DeviceProviderService {
            private TestProviderService() {
            }

            public DeviceProvider provider() {
                return null;
            }

            public void deviceConnected(DeviceId deviceId, DeviceDescription deviceDescription) {
                if (!deviceId.equals((Object)DID2)) {
                    TestDeviceRegistry.this.connected.add(deviceId);
                    DefaultDevice device = new DefaultDevice(providerId, deviceId, Device.Type.ROUTER, BgpTopologyProviderTest.UNKNOWN, BgpTopologyProviderTest.UNKNOWN, BgpTopologyProviderTest.UNKNOWN, BgpTopologyProviderTest.UNKNOWN, new ChassisId(), new Annotations[]{deviceDescription.annotations()});
                    BgpTopologyProviderTest.this.deviceMap.put(deviceId, device);
                }
            }

            public void deviceDisconnected(DeviceId deviceId) {
                if (!deviceId.equals((Object)DID2)) {
                    TestDeviceRegistry.this.connected.remove(deviceId);
                    BgpTopologyProviderTest.this.deviceMap.remove(deviceId);
                }
            }

            public void updatePorts(DeviceId deviceId, List<PortDescription> portDescriptions) {
                TestDeviceRegistry.this.portUpdated.put(deviceId, portDescriptions);
            }

            public void portStatusChanged(DeviceId deviceId, PortDescription portDescription) {
            }

            public void receivedRoleReply(DeviceId deviceId, MastershipRole requested, MastershipRole response) {
            }

            public void updatePortStatistics(DeviceId deviceId, Collection<PortStatistics> portStatistics) {
            }
        }
    }

    private class MockLinkService
    extends LinkServiceAdapter {
        private MockLinkService() {
        }

        public Link getLink(ConnectPoint src, ConnectPoint dst) {
            for (Link link : ((BgpTopologyProviderTest)BgpTopologyProviderTest.this).linkRegistry.links) {
                if (!link.src().equals((Object)src) || !link.dst().equals((Object)dst)) continue;
                return link;
            }
            return null;
        }
    }

    private class MockResourceAdminService
    implements ResourceAdminService {
        Map<ResourceId, List<Resource>> registeredRes = new HashMap<ResourceId, List<Resource>>();

        private MockResourceAdminService() {
        }

        public boolean register(List<? extends Resource> resources) {
            for (Resource resource : resources) {
                LinkedList<Resource> resource2 = new LinkedList<Resource>();
                resource2.add(resource);
                if (this.registeredRes.containsKey(resource.id())) {
                    resource2.addAll((Collection)this.registeredRes.get(resource.id()));
                }
                this.registeredRes.put(resource.id(), resource2);
            }
            return true;
        }

        public boolean unregister(List<? extends ResourceId> ids) {
            for (ResourceId resourceId : ids) {
                if (this.registeredRes.containsKey(resourceId)) {
                    this.registeredRes.remove(resourceId);
                    continue;
                }
                return false;
            }
            return true;
        }
    }

    private class MockMastershipService
    extends MastershipServiceAdapter {
        private MockMastershipService() {
        }

        public MastershipRole getLocalRole(DeviceId deviceId) {
            return MastershipRole.MASTER;
        }

        public boolean isLocalMaster(DeviceId deviceId) {
            return this.getLocalRole(deviceId) == MastershipRole.MASTER;
        }

        public NodeId getMasterFor(DeviceId deviceId) {
            return NODE1;
        }
    }

    private class MockNetConfigRegistryAdapter
    extends NetworkConfigRegistryAdapter {
        private ConfigFactory cfgFactory;
        private Map<ConnectPoint, BandwidthCapacity> classConfig = new HashMap<ConnectPoint, BandwidthCapacity>();

        private MockNetConfigRegistryAdapter() {
        }

        public void registerConfigFactory(ConfigFactory configFactory) {
            this.cfgFactory = configFactory;
        }

        public void unregisterConfigFactory(ConfigFactory configFactory) {
            this.cfgFactory = null;
        }

        public <S, C extends Config<S>> C addConfig(S subject, Class<C> configClass) {
            if (configClass == BandwidthCapacity.class) {
                BandwidthCapacity devCap = new BandwidthCapacity();
                this.classConfig.put((ConnectPoint)subject, devCap);
                ObjectNode node = new ObjectNode((JsonNodeFactory)new MockJsonNode());
                ObjectMapper mapper = new ObjectMapper();
                InternalApplyDelegate delegate = new InternalApplyDelegate();
                devCap.init((Object)((ConnectPoint)subject), null, (JsonNode)node, mapper, (ConfigApplyDelegate)delegate);
                return (C)devCap;
            }
            return null;
        }

        public <S, C extends Config<S>> void removeConfig(S subject, Class<C> configClass) {
            this.classConfig.remove(subject);
        }

        public <S, C extends Config<S>> C getConfig(S subject, Class<C> configClass) {
            if (configClass == BandwidthCapacity.class) {
                return (C)((Config)this.classConfig.get(subject));
            }
            return null;
        }

        private class InternalApplyDelegate
        implements ConfigApplyDelegate {
            private InternalApplyDelegate() {
            }

            public void onApply(Config config) {
            }
        }

        private class MockJsonNode
        extends JsonNodeFactory {
            private MockJsonNode() {
            }
        }
    }

    private class MockLabelResourceService
    implements LabelResourceAdminService {
        Map<DeviceId, LabelResourcePool> resourcePool = new HashMap<DeviceId, LabelResourcePool>();

        private MockLabelResourceService() {
        }

        public boolean createDevicePool(DeviceId deviceId, LabelResourceId beginLabel, LabelResourceId endLabel) {
            LabelResourcePool labelResource = new LabelResourcePool(deviceId.toString(), beginLabel.labelId(), endLabel.labelId());
            if (this.resourcePool.containsValue(labelResource)) {
                return false;
            }
            this.resourcePool.put(deviceId, labelResource);
            return true;
        }

        public boolean createGlobalPool(LabelResourceId beginLabel, LabelResourceId endLabel) {
            return false;
        }

        public boolean destroyDevicePool(DeviceId deviceId) {
            LabelResourcePool devicePool = this.resourcePool.get(deviceId);
            if (devicePool == null) {
                return false;
            }
            this.resourcePool.remove(deviceId);
            return true;
        }

        public boolean destroyGlobalPool() {
            return false;
        }
    }
}

