/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.bgp.topology.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onlab.packet.Ip4Address;
import org.onlab.util.Bandwidth;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpDpid;
import org.onosproject.bgp.controller.BgpLinkListener;
import org.onosproject.bgp.controller.BgpNodeListener;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetails;
import org.onosproject.bgpio.types.AutonomousSystemTlv;
import org.onosproject.bgpio.types.BgpLSIdentifierTlv;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.IPv4AddressTlv;
import org.onosproject.bgpio.types.IsIsNonPseudonode;
import org.onosproject.bgpio.types.IsIsPseudonode;
import org.onosproject.bgpio.types.LinkLocalRemoteIdentifiersTlv;
import org.onosproject.bgpio.types.LinkStateAttributes;
import org.onosproject.bgpio.types.OspfNonPseudonode;
import org.onosproject.bgpio.types.OspfPseudonode;
import org.onosproject.bgpio.types.attr.BgpAttrNodeFlagBitTlv;
import org.onosproject.bgpio.types.attr.BgpAttrNodeIsIsAreaId;
import org.onosproject.bgpio.types.attr.BgpAttrRouterIdV4;
import org.onosproject.bgpio.types.attr.BgpLinkAttrIgpMetric;
import org.onosproject.bgpio.types.attr.BgpLinkAttrMaxLinkBandwidth;
import org.onosproject.bgpio.types.attr.BgpLinkAttrTeDefaultMetric;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.resource.label.LabelResourceAdminService;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BandwidthCapacity;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class BgpTopologyProvider
extends AbstractProvider
implements DeviceProvider,
LinkProvider {
    private static final Logger log = LoggerFactory.getLogger(BgpTopologyProvider.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry deviceProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry linkProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected BgpController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LabelResourceAdminService labelResourceAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    private DeviceProviderService deviceProviderService;
    private LinkProviderService linkProviderService;
    private DeviceListener deviceListener = new InternalDeviceListener();
    private InternalBgpProvider listener = new InternalBgpProvider();
    private static final String UNKNOWN = "unknown";
    public static final long IDENTIFIER_SET = 0x100000000L;
    public static final String AS_NUMBER = "asNumber";
    public static final String DOMAIN_IDENTIFIER = "domainIdentifier";
    public static final String ROUTING_UNIVERSE = "routingUniverse";
    public static final String EXTERNAL_BIT = "externalBit";
    public static final String ABR_BIT = "abrBit";
    public static final String INTERNAL_BIT = "internalBit";
    public static final String PSEUDO = "psuedo";
    public static final String AREAID = "areaId";
    public static final String LSRID = "lsrId";
    public static final String COST = "cost";
    public static final String TE_COST = "teCost";
    public static final long PSEUDO_PORT = -1L;
    public static final int DELAY = 2;
    private LabelResourceId beginLabel = LabelResourceId.labelResourceId((long)5122L);
    private LabelResourceId endLabel = LabelResourceId.labelResourceId((long)9217L);
    private HashMap<DeviceId, List<PortDescription>> portMap = new HashMap();

    public BgpTopologyProvider() {
        super(new ProviderId("l3", "org.onosproject.provider.bgp"));
    }

    @Activate
    public void activate() {
        log.debug("BgpTopologyProvider activate");
        this.deviceProviderService = (DeviceProviderService)this.deviceProviderRegistry.register((Provider)this);
        this.linkProviderService = (LinkProviderService)this.linkProviderRegistry.register((Provider)this);
        this.controller.addListener((BgpNodeListener)this.listener);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.controller.addLinkListener((BgpLinkListener)this.listener);
    }

    @Deactivate
    public void deactivate() {
        log.debug("BgpTopologyProvider deactivate");
        this.deviceProviderRegistry.unregister((Provider)this);
        this.deviceProviderService = null;
        this.linkProviderRegistry.unregister((Provider)this);
        this.linkProviderService = null;
        this.controller.removeListener((BgpNodeListener)this.listener);
        this.controller.removeLinkListener((BgpLinkListener)this.listener);
        this.deviceService.removeListener((EventListener)this.deviceListener);
    }

    private void createDevicePool(DeviceId deviceId) {
        if (this.labelResourceAdminService == null) {
            return;
        }
        this.labelResourceAdminService.createDevicePool(deviceId, this.beginLabel, this.endLabel);
    }

    private void registerBandwidth(LinkDescription linkDes, PathAttrNlriDetails details) {
        if (details == null) {
            log.error("Couldnot able to register bandwidth ");
            return;
        }
        List attribute = details.pathAttributes().stream().filter(attr -> attr instanceof LinkStateAttributes).collect(Collectors.toList());
        if (attribute.isEmpty()) {
            return;
        }
        List tlvs = ((LinkStateAttributes)attribute.iterator().next()).linkStateAttributes();
        float maxReservableBw = 0.0f;
        for (BgpValueType tlv : tlvs) {
            switch (tlv.getType()) {
                case 1090: {
                    maxReservableBw = ((BgpLinkAttrMaxLinkBandwidth)tlv).linkAttrMaxLinkBandwidth();
                    maxReservableBw /= 1000000.0f;
                    break;
                }
            }
        }
        if ((double)maxReservableBw == 0.0) {
            return;
        }
        BandwidthCapacity config = (BandwidthCapacity)this.networkConfigService.addConfig((Object)linkDes.src(), BandwidthCapacity.class);
        config.capacity(Bandwidth.bps((double)maxReservableBw)).apply();
        config = (BandwidthCapacity)this.networkConfigService.addConfig((Object)linkDes.dst(), BandwidthCapacity.class);
        config.capacity(Bandwidth.bps((double)maxReservableBw)).apply();
    }

    private DefaultAnnotations.Builder getAnnotations(DefaultAnnotations.Builder annotationBuilder, boolean isNode, PathAttrNlriDetails details) {
        List attribute = details.pathAttributes().stream().filter(attr -> attr instanceof LinkStateAttributes).collect(Collectors.toList());
        if (attribute.isEmpty()) {
            return annotationBuilder;
        }
        List tlvs = ((LinkStateAttributes)attribute.iterator().next()).linkStateAttributes();
        boolean abrBit = false;
        boolean externalBit = false;
        boolean pseudo = false;
        int igpMetric = 0;
        int teMetric = 0;
        byte[] areaId = null;
        Ip4Address routerId = null;
        for (BgpValueType tlv : tlvs) {
            switch (tlv.getType()) {
                case 1024: {
                    abrBit = ((BgpAttrNodeFlagBitTlv)tlv).abrBit();
                    externalBit = ((BgpAttrNodeFlagBitTlv)tlv).externalBit();
                    break;
                }
                case 515: {
                    if (!(tlv instanceof IsIsPseudonode) && !(tlv instanceof OspfPseudonode)) break;
                    pseudo = true;
                    break;
                }
                case 1027: {
                    areaId = ((BgpAttrNodeIsIsAreaId)tlv).attrNodeIsIsAreaId();
                    break;
                }
                case 1028: {
                    routerId = ((BgpAttrRouterIdV4)tlv).attrRouterId();
                    break;
                }
                case 1095: {
                    igpMetric = ((BgpLinkAttrIgpMetric)tlv).attrLinkIgpMetric();
                    break;
                }
                case 1092: {
                    teMetric = ((BgpLinkAttrTeDefaultMetric)tlv).attrLinkDefTeMetric();
                    break;
                }
            }
        }
        if (isNode) {
            boolean internalBit = false;
            if (!abrBit && !externalBit) {
                internalBit = true;
            }
            annotationBuilder.set(EXTERNAL_BIT, String.valueOf(externalBit));
            annotationBuilder.set(ABR_BIT, String.valueOf(abrBit));
            annotationBuilder.set(INTERNAL_BIT, String.valueOf(internalBit));
            annotationBuilder.set(PSEUDO, String.valueOf(pseudo));
            if (areaId != null) {
                annotationBuilder.set(AREAID, new String(areaId));
            }
            if (routerId != null) {
                annotationBuilder.set(LSRID, String.valueOf(routerId));
            }
        } else {
            if (igpMetric != 0) {
                annotationBuilder.set(COST, String.valueOf(igpMetric));
            }
            if (teMetric != 0) {
                annotationBuilder.set(TE_COST, String.valueOf(teMetric));
            }
        }
        return annotationBuilder;
    }

    public void triggerProbe(DeviceId deviceId) {
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
    }

    public boolean isReachable(DeviceId deviceId) {
        return true;
    }

    public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
    }

    protected void bindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.deviceProviderRegistry = deviceProviderRegistry;
    }

    protected void unbindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.deviceProviderRegistry == deviceProviderRegistry) {
            this.deviceProviderRegistry = null;
        }
    }

    protected void bindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.linkProviderRegistry = linkProviderRegistry;
    }

    protected void unbindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.linkProviderRegistry == linkProviderRegistry) {
            this.linkProviderRegistry = null;
        }
    }

    protected void bindController(BgpController bgpController) {
        this.controller = bgpController;
    }

    protected void unbindController(BgpController bgpController) {
        if (this.controller == bgpController) {
            this.controller = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindLabelResourceAdminService(LabelResourceAdminService labelResourceAdminService) {
        this.labelResourceAdminService = labelResourceAdminService;
    }

    protected void unbindLabelResourceAdminService(LabelResourceAdminService labelResourceAdminService) {
        if (this.labelResourceAdminService == labelResourceAdminService) {
            this.labelResourceAdminService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    private class InternalBgpProvider
    implements BgpNodeListener,
    BgpLinkListener {
        private InternalBgpProvider() {
        }

        public void addNode(BgpNodeLSNlriVer4 nodeNlri, PathAttrNlriDetails details) {
            log.debug("Add node {}", (Object)nodeNlri.toString());
            if (BgpTopologyProvider.this.deviceProviderService == null || BgpTopologyProvider.this.deviceService == null) {
                return;
            }
            Device.Type deviceType = Device.Type.ROUTER;
            BgpDpid nodeUri = new BgpDpid(nodeNlri);
            DeviceId deviceId = DeviceId.deviceId((URI)BgpDpid.uri((String)nodeUri.toString()));
            ChassisId cId = new ChassisId();
            if (BgpTopologyProvider.this.deviceService.isAvailable(deviceId)) {
                return;
            }
            DefaultAnnotations.Builder newBuilder = DefaultAnnotations.builder();
            newBuilder.set("type", "L3");
            newBuilder.set(BgpTopologyProvider.ROUTING_UNIVERSE, Long.toString(nodeNlri.getIdentifier()));
            List tlvs = nodeNlri.getLocalNodeDescriptors().getNodedescriptors().getSubTlvs();
            for (BgpValueType tlv : tlvs) {
                if (tlv instanceof AutonomousSystemTlv) {
                    newBuilder.set(BgpTopologyProvider.AS_NUMBER, Integer.toString(((AutonomousSystemTlv)tlv).getAsNum()));
                } else if (tlv instanceof BgpLSIdentifierTlv) {
                    newBuilder.set(BgpTopologyProvider.DOMAIN_IDENTIFIER, Integer.toString(((BgpLSIdentifierTlv)tlv).getBgpLsIdentifier()));
                }
                if (tlv.getType() != 515) continue;
                if (tlv instanceof IsIsPseudonode) {
                    deviceType = Device.Type.VIRTUAL;
                    newBuilder.set("routerId", nodeUri.isoNodeIdString(((IsIsPseudonode)tlv).getIsoNodeId()));
                    continue;
                }
                if (tlv instanceof OspfPseudonode) {
                    deviceType = Device.Type.VIRTUAL;
                    newBuilder.set("routerId", Integer.toString(((OspfPseudonode)tlv).getrouterID()));
                    continue;
                }
                if (tlv instanceof IsIsNonPseudonode) {
                    newBuilder.set("routerId", nodeUri.isoNodeIdString(((IsIsNonPseudonode)tlv).getIsoNodeId()));
                    continue;
                }
                if (!(tlv instanceof OspfNonPseudonode)) continue;
                newBuilder.set("routerId", Integer.toString(((OspfNonPseudonode)tlv).getrouterID()));
            }
            DefaultAnnotations.Builder anntotations = DefaultAnnotations.builder();
            anntotations = BgpTopologyProvider.this.getAnnotations(newBuilder, true, details);
            DefaultDeviceDescription description = new DefaultDeviceDescription(BgpDpid.uri((String)nodeUri.toString()), deviceType, BgpTopologyProvider.UNKNOWN, BgpTopologyProvider.UNKNOWN, BgpTopologyProvider.UNKNOWN, BgpTopologyProvider.UNKNOWN, cId, new SparseAnnotations[]{anntotations.build()});
            BgpTopologyProvider.this.deviceProviderService.deviceConnected(deviceId, (DeviceDescription)description);
        }

        public void deleteNode(BgpNodeLSNlriVer4 nodeNlri) {
            log.debug("Delete node {}", (Object)nodeNlri.toString());
            if (BgpTopologyProvider.this.deviceProviderService == null) {
                return;
            }
            BgpDpid deviceUri = new BgpDpid(nodeNlri);
            DeviceId deviceId = DeviceId.deviceId((URI)BgpDpid.uri((String)deviceUri.toString()));
            if (BgpTopologyProvider.this.labelResourceAdminService != null) {
                BgpTopologyProvider.this.labelResourceAdminService.destroyDevicePool(deviceId);
            }
            BgpTopologyProvider.this.deviceProviderService.deviceDisconnected(deviceId);
        }

        private List<PortDescription> buildPortDescriptions(DeviceId deviceId, PortNumber portNumber) {
            List portList = BgpTopologyProvider.this.portMap.containsKey(deviceId) ? (List)BgpTopologyProvider.this.portMap.get(deviceId) : new ArrayList();
            if (portNumber != null) {
                DefaultPortDescription portDescriptions = new DefaultPortDescription(portNumber, true, new SparseAnnotations[0]);
                portList.add((PortDescription)portDescriptions);
            }
            BgpTopologyProvider.this.portMap.put(deviceId, portList);
            return portList;
        }

        public void addLink(BgpLinkLsNlriVer4 linkNlri, PathAttrNlriDetails details) throws BgpParseException {
            log.debug("Addlink {}", (Object)linkNlri.toString());
            LinkDescription linkDes = this.buildLinkDes(linkNlri, details, true);
            if (BgpTopologyProvider.this.linkService.getLink(linkDes.src(), linkDes.dst()) != null || BgpTopologyProvider.this.linkProviderService == null) {
                return;
            }
            if (BgpTopologyProvider.this.mastershipService.isLocalMaster(linkDes.src().deviceId())) {
                BgpTopologyProvider.this.registerBandwidth(linkDes, details);
            }
            BgpTopologyProvider.this.deviceProviderService.updatePorts(linkDes.src().deviceId(), this.buildPortDescriptions(linkDes.src().deviceId(), linkDes.src().port()));
            BgpTopologyProvider.this.deviceProviderService.updatePorts(linkDes.dst().deviceId(), this.buildPortDescriptions(linkDes.dst().deviceId(), linkDes.dst().port()));
            BgpTopologyProvider.this.linkProviderService.linkDetected(linkDes);
        }

        private LinkDescription buildLinkDes(BgpLinkLsNlriVer4 linkNlri, PathAttrNlriDetails details, boolean isAddLink) throws BgpParseException {
            long srcAddress = 0L;
            long dstAddress = 0L;
            boolean localPseduo = false;
            boolean remotePseduo = false;
            List localTlvs = linkNlri.getLinkIdentifier().localNodeDescriptors().getSubTlvs();
            for (Object localTlv : localTlvs) {
                if (!(localTlv instanceof IsIsPseudonode) && !(localTlv instanceof OspfPseudonode)) continue;
                localPseduo = true;
            }
            List remoteTlvs = linkNlri.getLinkIdentifier().remoteNodeDescriptors().getSubTlvs();
            for (Object remoteTlv : remoteTlvs) {
                if (!(remoteTlv instanceof IsIsPseudonode) && !(remoteTlv instanceof OspfPseudonode)) continue;
                remotePseduo = true;
            }
            List tlvs = linkNlri.getLinkIdentifier().linkDescriptors();
            for (BgpValueType tlv : tlvs) {
                if (tlv instanceof LinkLocalRemoteIdentifiersTlv) {
                    srcAddress = ((LinkLocalRemoteIdentifiersTlv)tlv).getLinkLocalIdentifier();
                    srcAddress |= 0x100000000L;
                    dstAddress = ((LinkLocalRemoteIdentifiersTlv)tlv).getLinkRemoteIdentifier();
                    dstAddress |= 0x100000000L;
                    continue;
                }
                if (!(tlv instanceof IPv4AddressTlv)) continue;
                if (tlv.getType() == 259) {
                    srcAddress = ((IPv4AddressTlv)tlv).address().toInt();
                    continue;
                }
                dstAddress = ((IPv4AddressTlv)tlv).address().toInt();
            }
            DeviceId srcId = DeviceId.deviceId((URI)BgpDpid.uri((String)new BgpDpid(linkNlri, 1).toString()));
            DeviceId dstId = DeviceId.deviceId((URI)BgpDpid.uri((String)new BgpDpid(linkNlri, 2).toString()));
            if (localPseduo && srcAddress == 0L) {
                srcAddress = -1L;
            } else if (remotePseduo && dstAddress == 0L) {
                dstAddress = -1L;
            }
            ConnectPoint src = new ConnectPoint((ElementId)srcId, PortNumber.portNumber((long)srcAddress));
            ConnectPoint dst = new ConnectPoint((ElementId)dstId, PortNumber.portNumber((long)dstAddress));
            BgpNodeLSNlriVer4 srcNodeNlri = new BgpNodeLSNlriVer4(linkNlri.getIdentifier(), linkNlri.getProtocolId().getType(), new BgpNodeLSIdentifier(linkNlri.getLinkIdentifier().localNodeDescriptors()), false, linkNlri.getRouteDistinguisher());
            BgpNodeLSNlriVer4 dstNodeNlri = new BgpNodeLSNlriVer4(linkNlri.getIdentifier(), linkNlri.getProtocolId().getType(), new BgpNodeLSIdentifier(linkNlri.getLinkIdentifier().remoteNodeDescriptors()), false, linkNlri.getRouteDistinguisher());
            this.addOrDeletePseudoNode(isAddLink, localPseduo, remotePseduo, srcNodeNlri, dstNodeNlri, srcId, dstId, details);
            DefaultAnnotations.Builder annotationBuilder = DefaultAnnotations.builder();
            if (details != null) {
                annotationBuilder = BgpTopologyProvider.this.getAnnotations(annotationBuilder, false, details);
            }
            return new DefaultLinkDescription(src, dst, Link.Type.DIRECT, false, new SparseAnnotations[]{annotationBuilder.build()});
        }

        private void addOrDeletePseudoNode(boolean isAddLink, boolean localPseduo, boolean remotePseduo, BgpNodeLSNlriVer4 srcNodeNlri, BgpNodeLSNlriVer4 dstNodeNlri, DeviceId srcId, DeviceId dstId, PathAttrNlriDetails details) {
            block8: {
                block9: {
                    block6: {
                        block7: {
                            if (!isAddLink) break block6;
                            if (!localPseduo) break block7;
                            if (BgpTopologyProvider.this.deviceService.getDevice(srcId) != null) break block8;
                            for (BgpNodeListener l : BgpTopologyProvider.this.controller.listener()) {
                                l.addNode(srcNodeNlri, details);
                            }
                            break block8;
                        }
                        if (!remotePseduo || BgpTopologyProvider.this.deviceService.getDevice(dstId) != null) break block8;
                        for (BgpNodeListener l : BgpTopologyProvider.this.controller.listener()) {
                            l.addNode(dstNodeNlri, details);
                        }
                        break block8;
                    }
                    if (!localPseduo) break block9;
                    Set links = BgpTopologyProvider.this.linkService.getDeviceLinks(srcId);
                    if (links != null && !links.isEmpty()) break block8;
                    for (BgpNodeListener l : BgpTopologyProvider.this.controller.listener()) {
                        l.deleteNode(srcNodeNlri);
                    }
                    break block8;
                }
                if (remotePseduo) {
                    log.info("Remote pseudo delete link ");
                    Set links = BgpTopologyProvider.this.linkService.getDeviceLinks(dstId);
                    if (links == null || links.isEmpty()) {
                        for (BgpNodeListener l : BgpTopologyProvider.this.controller.listener()) {
                            l.deleteNode(dstNodeNlri);
                        }
                    }
                }
            }
        }

        public void deleteLink(BgpLinkLsNlriVer4 linkNlri) throws BgpParseException {
            log.debug("Delete link {}", (Object)linkNlri.toString());
            if (BgpTopologyProvider.this.linkProviderService == null) {
                return;
            }
            LinkDescription linkDes = this.buildLinkDes(linkNlri, null, false);
            if (BgpTopologyProvider.this.networkConfigService != null && BgpTopologyProvider.this.mastershipService.isLocalMaster(linkDes.src().deviceId())) {
                BgpTopologyProvider.this.networkConfigService.removeConfig((Object)linkDes.src(), BandwidthCapacity.class);
                BgpTopologyProvider.this.networkConfigService.removeConfig((Object)linkDes.dst(), BandwidthCapacity.class);
            }
            BgpTopologyProvider.this.linkProviderService.linkVanished(linkDes);
            linkDes = new DefaultLinkDescription(linkDes.dst(), linkDes.src(), Link.Type.DIRECT, false, new SparseAnnotations[]{linkDes.annotations()});
            BgpTopologyProvider.this.linkProviderService.linkVanished(linkDes);
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            Device device = (Device)event.subject();
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: {
                    if (!BgpTopologyProvider.this.mastershipService.isLocalMaster(device.id()) || device.annotations().value(BgpTopologyProvider.LSRID) == null) break;
                    BgpTopologyProvider.this.createDevicePool(device.id());
                    break;
                }
            }
        }
    }
}

