/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.isis.cfg.impl;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.isis.controller.IsisController;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.isis.cfg.impl.IsisAppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class IsisCfgProvider
extends AbstractProvider {
    private static final String PROVIDER_ID = "org.onosproject.provider.isis.cfg";
    private static final Logger log = LoggerFactory.getLogger(IsisCfgProvider.class);
    private final ConfigFactory configFactory = new ConfigFactory(SubjectFactories.APP_SUBJECT_FACTORY, IsisAppConfig.class, "isisapp"){

        public IsisAppConfig createConfig() {
            return new IsisAppConfig();
        }
    };
    private final NetworkConfigListener configListener = new InternalConfigListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IsisController isisController;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry configRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService configService;
    private ApplicationId appId;

    public IsisCfgProvider() {
        super(new ProviderId("isis", PROVIDER_ID));
    }

    @Activate
    public void activate() {
        log.debug("Activate...!!!");
        this.appId = this.coreService.registerApplication(PROVIDER_ID);
        this.configService.addListener((EventListener)this.configListener);
        this.configRegistry.registerConfigFactory(this.configFactory);
        log.debug("ISIS cfg service got started");
    }

    @Deactivate
    public void deactivate() {
        log.debug("Deactivate...!!!");
        this.configRegistry.unregisterConfigFactory(this.configFactory);
        this.configService.removeListener((EventListener)this.configListener);
    }

    private void updateConfig() {
        IsisAppConfig isisAppConfig = (IsisAppConfig)this.configRegistry.getConfig((Object)this.appId, IsisAppConfig.class);
        log.debug("IsisAppConfig::config processes::" + isisAppConfig.processes());
        log.debug("IsisAppConfig::prop 1::" + isisAppConfig.method());
        if ("ADD".equalsIgnoreCase(isisAppConfig.method())) {
            JsonNode jsonNode = isisAppConfig.processes();
            this.isisController.updateConfig(jsonNode);
        }
    }

    protected void bindIsisController(IsisController isisController) {
        this.isisController = isisController;
    }

    protected void unbindIsisController(IsisController isisController) {
        if (this.isisController == isisController) {
            this.isisController = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.configRegistry = networkConfigRegistry;
    }

    protected void unbindConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.configRegistry == networkConfigRegistry) {
            this.configRegistry = null;
        }
    }

    protected void bindConfigService(NetworkConfigService networkConfigService) {
        this.configService = networkConfigService;
    }

    protected void unbindConfigService(NetworkConfigService networkConfigService) {
        if (this.configService == networkConfigService) {
            this.configService = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            log.debug("config event is getting called...!!!");
            if (!event.configClass().equals(IsisAppConfig.class)) {
                return;
            }
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_ADDED: {
                    IsisCfgProvider.this.updateConfig();
                    break;
                }
                case CONFIG_UPDATED: {
                    IsisCfgProvider.this.updateConfig();
                    break;
                }
                case CONFIG_REMOVED: {
                    break;
                }
            }
        }
    }
}

