/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.isis.topology.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Ip4Address;
import org.onlab.util.Bandwidth;
import org.onosproject.isis.controller.IsisController;
import org.onosproject.isis.controller.IsisProcess;
import org.onosproject.isis.controller.impl.topology.DefaultIsisLink;
import org.onosproject.isis.controller.impl.topology.DefaultIsisLinkTed;
import org.onosproject.isis.controller.impl.topology.DefaultIsisRouter;
import org.onosproject.isis.controller.topology.IsisLink;
import org.onosproject.isis.controller.topology.IsisLinkListener;
import org.onosproject.isis.controller.topology.IsisLinkTed;
import org.onosproject.isis.controller.topology.IsisRouter;
import org.onosproject.isis.controller.topology.IsisRouterListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistryAdapter;
import org.onosproject.net.config.basics.BandwidthCapacity;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.isis.topology.impl.IsisTopologyProvider;

public class IsisTopologyProviderTest {
    private final IsisTopologyProvider provider = new IsisTopologyProvider();
    private final TestDeviceRegistry nodeRegistry = new TestDeviceRegistry();
    private final TestLinkRegistry linkRegistry = new TestLinkRegistry();
    private final TestController controller = new TestController();
    private final TestLinkService linkService = new TestLinkService();
    private MockNetConfigRegistryAdapter networkConfigService = new MockNetConfigRegistryAdapter();

    @Before
    public void setUp() throws Exception {
        this.provider.deviceProviderRegistry = this.nodeRegistry;
        this.provider.linkProviderRegistry = this.linkRegistry;
        this.provider.networkConfigService = this.networkConfigService;
        this.provider.controller = this.controller;
        this.provider.linkService = this.linkService;
        this.provider.activate();
        Assert.assertNotNull((String)"provider should be registered", (Object)this.nodeRegistry.provider);
        Assert.assertNotNull((String)"listener should be registered", this.controller.nodeListener);
    }

    @After
    public void tearDown() throws Exception {
        this.provider.deactivate();
        this.provider.controller = null;
        this.provider.deviceProviderRegistry = null;
        this.provider.networkConfigService = null;
    }

    @Test
    public void triggerProbe() {
        DeviceId deviceId = DeviceId.deviceId((String)"2929.2929.2929.00-00");
        this.provider.triggerProbe(deviceId);
    }

    @Test
    public void roleChanged() {
        DeviceId deviceId = DeviceId.deviceId((String)"1111.1111.1111.00-00");
        this.provider.roleChanged(deviceId, MastershipRole.MASTER);
    }

    @Test
    public void changePortState() {
        DeviceId deviceId = DeviceId.deviceId((String)"2222.2222.2222.00-82");
        this.provider.changePortState(deviceId, PortNumber.portNumber((long)0xA0A0A07L), false);
    }

    @Test
    public void isReachable() {
        DeviceId deviceId = DeviceId.deviceId((String)"1010.1010.1111.00-22");
        this.provider.isReachable(deviceId);
    }

    @Test
    public void isisTopologyProviderTestAddDevice1() {
        int deviceAddCount = 0;
        DefaultIsisRouter isisRouter = new DefaultIsisRouter();
        isisRouter.setSystemId("2929.2929.2929.00");
        isisRouter.setNeighborRouterId(Ip4Address.valueOf((String)"10.10.10.1"));
        isisRouter.setInterfaceId(Ip4Address.valueOf((String)"10.10.10.2"));
        isisRouter.setDis(false);
        for (IsisRouterListener l : this.controller.nodeListener) {
            l.routerAdded((IsisRouter)isisRouter);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 1 ? 1 : 0) != 0);
            l.routerRemoved((IsisRouter)isisRouter);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void isisTopologyProviderTestAddDevice2() {
        int deviceAddCount = 0;
        DefaultIsisRouter isisRouter = new DefaultIsisRouter();
        isisRouter.setSystemId("7777.7777.7777.00");
        isisRouter.setNeighborRouterId(Ip4Address.valueOf((String)"10.10.10.1"));
        isisRouter.setInterfaceId(Ip4Address.valueOf((String)"10.10.10.7"));
        isisRouter.setDis(false);
        DefaultIsisRouter isisRouter1 = new DefaultIsisRouter();
        isisRouter1.setSystemId("1111.1111.1111.00");
        isisRouter1.setNeighborRouterId(Ip4Address.valueOf((String)"10.10.10.7"));
        isisRouter1.setInterfaceId(Ip4Address.valueOf((String)"10.10.10.1"));
        isisRouter1.setDis(true);
        for (IsisRouterListener l : this.controller.nodeListener) {
            l.routerAdded((IsisRouter)isisRouter);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 1 ? 1 : 0) != 0);
            l.routerAdded((IsisRouter)isisRouter1);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 2 ? 1 : 0) != 0);
            l.routerRemoved((IsisRouter)isisRouter);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void isisTopologyProviderTestAddLink() {
        int deviceAddCount = 0;
        DefaultIsisRouter isisRouter = new DefaultIsisRouter();
        isisRouter.setSystemId("7777.7777.7777.00");
        isisRouter.setNeighborRouterId(Ip4Address.valueOf((String)"10.10.10.1"));
        isisRouter.setInterfaceId(Ip4Address.valueOf((String)"10.10.10.7"));
        isisRouter.setDis(false);
        DefaultIsisRouter isisRouter1 = new DefaultIsisRouter();
        isisRouter1.setSystemId("1111.1111.1111.00");
        isisRouter1.setNeighborRouterId(Ip4Address.valueOf((String)"10.10.10.7"));
        isisRouter1.setInterfaceId(Ip4Address.valueOf((String)"10.10.10.1"));
        isisRouter1.setDis(true);
        DefaultIsisLink isisLink = new DefaultIsisLink();
        isisLink.setRemoteSystemId("7777.7777.7777.00");
        isisLink.setLocalSystemId("1111.1111.1111.00");
        isisLink.setInterfaceIp(Ip4Address.valueOf((String)"10.10.10.1"));
        isisLink.setNeighborIp(Ip4Address.valueOf((String)"10.10.10.7"));
        DefaultIsisLinkTed isisLinkTed = new DefaultIsisLinkTed();
        isisLinkTed.setTeDefaultMetric(10L);
        isisLinkTed.setAdministrativeGroup(5);
        isisLinkTed.setIpv4InterfaceAddress(Ip4Address.valueOf((String)"10.10.10.1"));
        isisLinkTed.setIpv4NeighborAddress(Ip4Address.valueOf((String)"10.10.10.7"));
        isisLinkTed.setMaximumLinkBandwidth(Bandwidth.bps((long)0L));
        isisLinkTed.setMaximumReservableLinkBandwidth(Bandwidth.bps((double)1.0));
        ArrayList<Bandwidth> unresList = new ArrayList<Bandwidth>();
        unresList.add(Bandwidth.bps((double)0.0));
        unresList.add(Bandwidth.bps((double)1.0));
        unresList.add(Bandwidth.bps((double)2.0));
        unresList.add(Bandwidth.bps((double)3.0));
        isisLinkTed.setUnreservedBandwidth(unresList);
        isisLink.setLinkTed((IsisLinkTed)isisLinkTed);
        for (IsisRouterListener isisRouterListener : this.controller.nodeListener) {
            isisRouterListener.routerAdded((IsisRouter)isisRouter);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 1 ? 1 : 0) != 0);
            isisRouterListener.routerAdded((IsisRouter)isisRouter1);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 2 ? 1 : 0) != 0);
        }
        for (IsisLinkListener isisLinkListener : this.controller.linkListener) {
            isisLinkListener.addLink((IsisLink)isisLink);
            isisLinkListener.deleteLink((IsisLink)isisLink);
        }
    }

    private class MockNetConfigRegistryAdapter
    extends NetworkConfigRegistryAdapter {
        private ConfigFactory cfgFactory;
        private Map<ConnectPoint, BandwidthCapacity> classConfig = new HashMap<ConnectPoint, BandwidthCapacity>();

        private MockNetConfigRegistryAdapter() {
        }

        public void registerConfigFactory(ConfigFactory configFactory) {
            this.cfgFactory = configFactory;
        }

        public void unregisterConfigFactory(ConfigFactory configFactory) {
            this.cfgFactory = null;
        }

        public <S, C extends Config<S>> C addConfig(S subject, Class<C> configClass) {
            if (configClass == BandwidthCapacity.class) {
                BandwidthCapacity devCap = new BandwidthCapacity();
                this.classConfig.put((ConnectPoint)subject, devCap);
                ObjectNode node = new ObjectNode((JsonNodeFactory)new MockJsonNode());
                ObjectMapper mapper = new ObjectMapper();
                InternalApplyDelegate delegate = new InternalApplyDelegate();
                devCap.init((Object)((ConnectPoint)subject), null, (JsonNode)node, mapper, (ConfigApplyDelegate)delegate);
                return (C)devCap;
            }
            return null;
        }

        public <S, C extends Config<S>> void removeConfig(S subject, Class<C> configClass) {
            this.classConfig.remove(subject);
        }

        public <S, C extends Config<S>> C getConfig(S subject, Class<C> configClass) {
            if (configClass == BandwidthCapacity.class) {
                return (C)((Config)this.classConfig.get(subject));
            }
            return null;
        }

        private class InternalApplyDelegate
        implements ConfigApplyDelegate {
            private InternalApplyDelegate() {
            }

            public void onApply(Config config) {
            }
        }

        private class MockJsonNode
        extends JsonNodeFactory {
            private MockJsonNode() {
            }
        }
    }

    private class TestController
    implements IsisController {
        protected Set<IsisRouterListener> nodeListener = new CopyOnWriteArraySet<IsisRouterListener>();
        protected Set<IsisLinkListener> linkListener = new CopyOnWriteArraySet<IsisLinkListener>();

        private TestController() {
        }

        public void addRouterListener(IsisRouterListener nodeListener) {
            this.nodeListener.add(nodeListener);
        }

        public void removeRouterListener(IsisRouterListener nodeListener) {
            this.nodeListener.remove(nodeListener);
        }

        public void addLinkListener(IsisLinkListener listener) {
            this.linkListener.add(listener);
        }

        public void removeLinkListener(IsisLinkListener listener) {
            this.linkListener.remove(listener);
        }

        public void updateConfig(JsonNode processesNode) {
        }

        public List<IsisProcess> allConfiguredProcesses() {
            return null;
        }

        public Set<IsisRouterListener> listener() {
            return null;
        }

        public Set<IsisLinkListener> linkListener() {
            return null;
        }
    }

    private class TestLinkRegistry
    implements LinkProviderRegistry {
        LinkProvider provider;
        Set<DeviceId> connected = new HashSet<DeviceId>();

        private TestLinkRegistry() {
        }

        public LinkProviderService register(LinkProvider provider) {
            this.provider = provider;
            return new TestLinkProviderService();
        }

        public void unregister(LinkProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }

        private class TestLinkProviderService
        implements LinkProviderService {
            private TestLinkProviderService() {
            }

            public void linkDetected(LinkDescription linkDescription) {
            }

            public void linkVanished(LinkDescription linkDescription) {
            }

            public void linksVanished(ConnectPoint connectPoint) {
            }

            public void linksVanished(DeviceId deviceId) {
            }

            public LinkProvider provider() {
                return null;
            }
        }
    }

    private class TestLinkService
    extends LinkServiceAdapter {
        private LinkListener listener;

        private TestLinkService() {
        }

        public void addListener(LinkListener listener) {
            this.listener = listener;
        }

        public Iterable<Link> getLinks() {
            return Collections.emptyList();
        }
    }

    private class TestDeviceService
    extends DeviceServiceAdapter {
        private DeviceListener listener;

        private TestDeviceService() {
        }

        public void addListener(DeviceListener listener) {
            this.listener = listener;
        }

        public Iterable<Device> getDevices() {
            return Collections.emptyList();
        }
    }

    private class TestDeviceRegistry
    implements DeviceProviderRegistry {
        DeviceProvider provider;
        Set<DeviceId> connected = new HashSet<DeviceId>();

        private TestDeviceRegistry() {
        }

        public DeviceProviderService register(DeviceProvider provider) {
            this.provider = provider;
            return new TestProviderService();
        }

        public void unregister(DeviceProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }

        private class TestProviderService
        implements DeviceProviderService {
            private TestProviderService() {
            }

            public DeviceProvider provider() {
                return null;
            }

            public void deviceConnected(DeviceId deviceId, DeviceDescription deviceDescription) {
                TestDeviceRegistry.this.connected.add(deviceId);
            }

            public void deviceDisconnected(DeviceId deviceId) {
                TestDeviceRegistry.this.connected.remove(deviceId);
            }

            public void updatePorts(DeviceId deviceId, List<PortDescription> portDescriptions) {
            }

            public void portStatusChanged(DeviceId deviceId, PortDescription portDescription) {
            }

            public void receivedRoleReply(DeviceId deviceId, MastershipRole requested, MastershipRole response) {
            }

            public void updatePortStatistics(DeviceId deviceId, Collection<PortStatistics> portStatistics) {
            }
        }
    }
}

