/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.linkdiscovery.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onlab.osgi.ComponentContextAdapter;
import org.onlab.packet.ChassisId;
import org.onosproject.cfg.ComponentConfigAdapter;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.AbstractProjectableModel;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.LinkDiscovery;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverAdapter;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.driver.DriverServiceAdapter;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProviderRegistryAdapter;
import org.onosproject.net.link.LinkProviderServiceAdapter;
import org.onosproject.net.link.LinkServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.linkdiscovery.impl.LinkDiscoveryProvider;
import org.osgi.service.component.ComponentContext;

public class LinkDiscoveryProviderTest {
    private static final ComponentContextAdapter CONTEXT = new ComponentContextAdapter(){

        public Dictionary getProperties() {
            Hashtable<String, Integer> props = new Hashtable<String, Integer>();
            props.put("linkPollFrequencySeconds", 2);
            props.put("linkPollDelaySeconds", 1);
            return props;
        }
    };
    private static final DeviceId DEVICE_ID_1 = DeviceId.deviceId((String)"netconf:1.1.1.1");
    private static final DeviceId DEVICE_ID_2 = DeviceId.deviceId((String)"netconf:1.1.1.2");
    private static final ConnectPoint CP11 = new ConnectPoint((ElementId)DEVICE_ID_1, PortNumber.portNumber((long)1L));
    private static final ConnectPoint CP12 = new ConnectPoint((ElementId)DEVICE_ID_1, PortNumber.portNumber((long)2L));
    private static final ConnectPoint CP13 = new ConnectPoint((ElementId)DEVICE_ID_1, PortNumber.portNumber((long)3L));
    private static final ConnectPoint CP14 = new ConnectPoint((ElementId)DEVICE_ID_1, PortNumber.portNumber((long)4L));
    private static final ConnectPoint CP21 = new ConnectPoint((ElementId)DEVICE_ID_2, PortNumber.portNumber((long)1L));
    private static final ConnectPoint CP22 = new ConnectPoint((ElementId)DEVICE_ID_2, PortNumber.portNumber((long)2L));
    private static final ConnectPoint CP23 = new ConnectPoint((ElementId)DEVICE_ID_2, PortNumber.portNumber((long)3L));
    private static final ConnectPoint CP24 = new ConnectPoint((ElementId)DEVICE_ID_2, PortNumber.portNumber((long)4L));
    private static final DefaultAnnotations DEVICE_ANNOTATIONS = DefaultAnnotations.builder().set("protocol", "linkdiscovery".toUpperCase()).build();
    private static final DefaultAnnotations LINK_ANNOTATIONS = DefaultAnnotations.builder().set("protocol", "linkdiscovery".toUpperCase()).build();
    private static final LinkKey LINKKEY1 = LinkKey.linkKey((ConnectPoint)CP11, (ConnectPoint)CP21);
    private static final LinkDescription LINK1 = new DefaultLinkDescription(CP11, CP21, Link.Type.DIRECT, new SparseAnnotations[]{LINK_ANNOTATIONS});
    private static final LinkKey LINKKEY2 = LinkKey.linkKey((ConnectPoint)CP12, (ConnectPoint)CP22);
    private static final LinkDescription LINK2 = new DefaultLinkDescription(CP12, CP22, Link.Type.DIRECT, new SparseAnnotations[]{LINK_ANNOTATIONS});
    private static final LinkKey LINKKEY3 = LinkKey.linkKey((ConnectPoint)CP13, (ConnectPoint)CP23);
    private static final LinkDescription LINK3 = new DefaultLinkDescription(CP13, CP23, Link.Type.DIRECT, new SparseAnnotations[]{DefaultAnnotations.builder().build()});
    private static final LinkKey LINKKEY4 = LinkKey.linkKey((ConnectPoint)CP14, (ConnectPoint)CP24);
    private static final LinkDescription LINK4 = new DefaultLinkDescription(CP14, CP24, Link.Type.DIRECT, new SparseAnnotations[]{DefaultAnnotations.builder().build()});
    private final MockDeviceService deviceService = new MockDeviceService();
    private final LinkProviderRegistryAdapter linkRegistry = new LinkProviderRegistryAdapter();
    private final MastershipService mastershipService = new MockMastershipService();
    private final MockLinkService linkService = new MockLinkService();
    private final Driver driver = new MockDriver();
    private LinkProviderServiceAdapter providerService;
    private CoreService coreService;
    private LinkDiscoveryProvider provider = new LinkDiscoveryProvider();
    private final Device device1 = new MockDevice(this.provider.id(), DEVICE_ID_1, Device.Type.SWITCH, "foo.inc", "0", "0", "0", new ChassisId(), new Annotations[]{DEVICE_ANNOTATIONS});
    private Set<DeviceListener> deviceListeners = new HashSet<DeviceListener>();
    private ApplicationId appId = new DefaultApplicationId(100, "org.onosproject.linkdiscovery");
    private TestLink testLink = new TestLink();

    @Before
    public void setUp() {
        this.coreService = (CoreService)EasyMock.createMock(CoreService.class);
        EasyMock.expect((Object)this.coreService.registerApplication(this.appId.name())).andReturn((Object)this.appId).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coreService});
        this.provider.coreService = this.coreService;
        this.provider.providerRegistry = this.linkRegistry;
        this.provider.deviceService = this.deviceService;
        this.provider.mastershipService = this.mastershipService;
        this.provider.linkService = this.linkService;
        this.provider.cfgService = new ComponentConfigAdapter();
        AbstractProjectableModel.setDriverService(null, (DriverService)new DriverServiceAdapter());
        this.provider.activate(null);
        this.providerService = this.linkRegistry.registeredProvider();
    }

    @Test
    public void activate() throws Exception {
        Assert.assertFalse((String)"Provider should be registered", (boolean)this.linkRegistry.getProviders().contains(this.provider));
        Assert.assertEquals((String)"Device service should be registered", (Object)this.provider.deviceService, (Object)((Object)this.deviceService));
        Assert.assertEquals((String)"Device listener should be added", (long)1L, (long)this.deviceListeners.size());
        Assert.assertNotNull((String)"Registration expected", (Object)this.providerService);
        Assert.assertEquals((String)"Incorrect  provider", (Object)this.provider, (Object)this.providerService.provider());
        Assert.assertFalse((String)"Executor should be running", (boolean)this.provider.executor.isShutdown());
        Assert.assertFalse((String)"Executor should be running", (boolean)this.provider.executor.isTerminated());
        Assert.assertEquals((String)"Incorrect polling frequency, should be default", (long)10L, (long)LinkDiscoveryProvider.linkPollFrequencySeconds);
        Assert.assertEquals((String)"Incorrect polling delay , should be default", (long)20L, (long)LinkDiscoveryProvider.linkPollDelaySeconds);
    }

    @Test
    public void modified() throws Exception {
        this.provider.modified((ComponentContext)CONTEXT);
        Assert.assertEquals((String)"Incorrect polling frequency, should be default", (long)2L, (long)LinkDiscoveryProvider.linkPollFrequencySeconds);
        Assert.assertEquals((String)"Incorrect polling delay , should be default", (long)1L, (long)LinkDiscoveryProvider.linkPollDelaySeconds);
    }

    @Test
    public void deactivate() throws Exception {
        this.provider.deactivate();
        Assert.assertEquals((String)"Device listener should be removed", (long)0L, (long)this.deviceListeners.size());
        Assert.assertFalse((String)"Provider should not be registered", (boolean)this.linkRegistry.getProviders().contains(this.provider));
        Assert.assertTrue((boolean)this.provider.executor.isShutdown());
        Assert.assertNull((Object)this.provider.providerService);
    }

    @Test
    public void linksTestForStoredDevice() {
        this.provider.modified((ComponentContext)CONTEXT);
        this.providerService.discoveredLinkDescriptions().put(LINKKEY1, LINK1);
        this.providerService.discoveredLinkDescriptions().put(LINKKEY2, LINK2);
        this.providerService.discoveredLinkDescriptions().put(LINKKEY4, LINK4);
        this.testLink.addLinkDesc(LinkDiscoveryProviderTest.LINK2);
        this.testLink.addLinkDesc(LinkDiscoveryProviderTest.LINK3);
        TestTools.assertAfter((int)1100, () -> {
            Assert.assertEquals((String)"Total number of link must be 3", (long)3L, (long)this.providerService.discoveredLinkDescriptions().size());
            Assert.assertFalse((String)"Link1 should be removed", (boolean)this.providerService.discoveredLinkDescriptions().containsKey(LINKKEY1));
            Assert.assertTrue((String)"Link2 should be present", (boolean)this.providerService.discoveredLinkDescriptions().containsKey(LINKKEY2));
            Assert.assertTrue((String)"Link3 should be added", (boolean)this.providerService.discoveredLinkDescriptions().containsKey(LINKKEY3));
            Assert.assertEquals((String)"Link3 should be annotated", (Object)"linkdiscovery".toUpperCase(), (Object)((LinkDescription)this.providerService.discoveredLinkDescriptions().get(LINKKEY3)).annotations().value("protocol"));
            Assert.assertTrue((String)"Link4 should be present because it is not related to the LinkDiscovery", (boolean)this.providerService.discoveredLinkDescriptions().containsKey(LINKKEY4));
        });
        this.clear();
    }

    private void clear() {
        this.testLink.clearLinkDesc();
        this.providerService.discoveredLinkDescriptions().clear();
        this.providerService.discoveredLinks().clear();
    }

    private class TestLink
    extends AbstractHandlerBehaviour
    implements LinkDiscovery {
        Set<LinkDescription> linkDescriptions = new HashSet<LinkDescription>();

        private TestLink() {
        }

        public Set<LinkDescription> getLinks() {
            return ImmutableSet.copyOf(this.linkDescriptions);
        }

        private void addLinkDesc(LinkDescription link) {
            this.linkDescriptions.add(link);
        }

        private void clearLinkDesc() {
            this.linkDescriptions.clear();
        }
    }

    private class MockDriver
    extends DriverAdapter {
        private MockDriver() {
        }

        public <T extends Behaviour> T createBehaviour(DriverHandler handler, Class<T> behaviourClass) {
            return (T)((Object)LinkDiscoveryProviderTest.this.testLink);
        }
    }

    private class MockDevice
    extends DefaultDevice {
        public MockDevice(ProviderId providerId, DeviceId id, Device.Type type, String manufacturer, String hwVersion, String swVersion, String serialNumber, ChassisId chassisId, Annotations ... annotations) {
            super(providerId, id, type, manufacturer, hwVersion, swVersion, serialNumber, chassisId, annotations);
        }

        protected Driver locateDriver() {
            return LinkDiscoveryProviderTest.this.driver;
        }

        public Driver driver() {
            return LinkDiscoveryProviderTest.this.driver;
        }
    }

    private class MockLinkService
    extends LinkServiceAdapter {
        private MockLinkService() {
        }

        public Set<Link> getDeviceEgressLinks(DeviceId deviceId) {
            HashSet links = new HashSet();
            LinkDiscoveryProviderTest.this.providerService.discoveredLinkDescriptions().values().forEach(x -> links.add(DefaultLink.builder().providerId(LinkDiscoveryProviderTest.this.provider.id()).src(x.src()).dst(x.dst()).type(x.type()).isExpected(x.isExpected()).annotations((Annotations)x.annotations()).build()));
            return ImmutableSet.copyOf(links);
        }
    }

    private class MockMastershipService
    extends MastershipServiceAdapter {
        private MockMastershipService() {
        }

        public boolean isLocalMaster(DeviceId deviceId) {
            return true;
        }
    }

    private class MockDeviceService
    extends DeviceServiceAdapter {
        private MockDeviceService() {
        }

        public Iterable<Device> getAvailableDevices() {
            return ImmutableSet.of((Object)LinkDiscoveryProviderTest.this.device1);
        }

        public void addListener(DeviceListener listener) {
            LinkDiscoveryProviderTest.this.deviceListeners.add(listener);
        }

        public void removeListener(DeviceListener listener) {
            LinkDiscoveryProviderTest.this.deviceListeners.remove(listener);
        }
    }
}

