/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.netcfglinks;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.ONOSLLDP;
import org.onosproject.cluster.ClusterMetadataServiceAdapter;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.ElementId;
import org.onosproject.net.LinkKey;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistryAdapter;
import org.onosproject.net.config.basics.BasicLinkConfig;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProviderRegistryAdapter;
import org.onosproject.net.link.LinkProviderServiceAdapter;
import org.onosproject.net.packet.DefaultInboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketServiceAdapter;
import org.onosproject.provider.netcfglinks.NetworkConfigLinksProvider;

public class NetworkConfigLinksProviderTest {
    private NetworkConfigLinksProvider provider;
    private PacketProcessor testProcessor;
    private LinkProviderServiceAdapter providerService;
    private NetworkConfigListener configListener;
    private final TestNetworkConfigRegistry configRegistry = new TestNetworkConfigRegistry();
    static Device dev1 = NetTestTools.device((String)"sw1");
    static Device dev2 = NetTestTools.device((String)"sw2");
    static Device dev3 = NetTestTools.device((String)"sw3");
    static PortNumber portNumber1 = PortNumber.portNumber((long)1L);
    static PortNumber portNumber2 = PortNumber.portNumber((long)2L);
    static PortNumber portNumber3 = PortNumber.portNumber((long)3L);
    static ConnectPoint src = new ConnectPoint((ElementId)dev1.id(), portNumber2);
    static ConnectPoint dst = new ConnectPoint((ElementId)dev2.id(), portNumber2);
    static DeviceListener deviceListener;

    @Before
    public void setUp() {
        this.provider = new NetworkConfigLinksProvider();
        this.provider.coreService = new CoreServiceAdapter();
        this.provider.packetService = new PacketServiceAdapter();
        LinkProviderRegistryAdapter linkRegistry = new LinkProviderRegistryAdapter();
        this.provider.providerRegistry = linkRegistry;
        this.provider.deviceService = new TestDeviceManager();
        this.provider.masterService = new TestMastershipService();
        this.provider.packetService = new TestPacketService();
        this.provider.metadataService = new ClusterMetadataServiceAdapter();
        this.provider.netCfgService = this.configRegistry;
        this.provider.activate();
        this.providerService = linkRegistry.registeredProvider();
    }

    @After
    public void tearDown() {
        this.provider.deactivate();
    }

    @Test
    public void testCreation() {
        MatcherAssert.assertThat((Object)this.provider, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.provider.configuredLinks, (Matcher)Matchers.empty());
    }

    @Test
    public void testDeviceLoad() {
        MatcherAssert.assertThat((Object)this.provider, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(this.provider.discoverers.entrySet(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testNotConfiguredLink() {
        TestPacketContext pktCtx = new TestPacketContext(src, dst);
        this.testProcessor.process((PacketContext)pktCtx);
        MatcherAssert.assertThat(this.providerService.discoveredLinks().entrySet(), (Matcher)Matchers.hasSize((int)1));
        DeviceId destination = (DeviceId)this.providerService.discoveredLinks().get(dev1.id());
        MatcherAssert.assertThat((Object)destination, (Matcher)Matchers.notNullValue());
        LinkKey key = LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst);
        LinkDescription linkDescription = (LinkDescription)this.providerService.discoveredLinkDescriptions().get(key);
        MatcherAssert.assertThat((Object)linkDescription, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)linkDescription.isExpected(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testConfiguredLink() {
        LinkKey key = LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst);
        this.configListener.event((Event)new NetworkConfigEvent(NetworkConfigEvent.Type.CONFIG_ADDED, (Object)key, BasicLinkConfig.class));
        TestPacketContext pktCtx = new TestPacketContext(src, dst);
        this.testProcessor.process((PacketContext)pktCtx);
        MatcherAssert.assertThat(this.providerService.discoveredLinks().entrySet(), (Matcher)Matchers.hasSize((int)1));
        DeviceId destination = (DeviceId)this.providerService.discoveredLinks().get(dev1.id());
        MatcherAssert.assertThat((Object)destination, (Matcher)Matchers.notNullValue());
        LinkDescription linkDescription = (LinkDescription)this.providerService.discoveredLinkDescriptions().get(key);
        MatcherAssert.assertThat((Object)linkDescription, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)linkDescription.isExpected(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testRemoveLink() {
        LinkKey key = LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst);
        this.configListener.event((Event)new NetworkConfigEvent(NetworkConfigEvent.Type.CONFIG_ADDED, (Object)key, BasicLinkConfig.class));
        MatcherAssert.assertThat((Object)this.provider.configuredLinks, (Matcher)Matchers.hasSize((int)1));
        this.configListener.event((Event)new NetworkConfigEvent(NetworkConfigEvent.Type.CONFIG_REMOVED, (Object)key, BasicLinkConfig.class));
        MatcherAssert.assertThat((Object)this.provider.configuredLinks, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testAddDevice() {
        deviceListener.event((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, dev3));
        MatcherAssert.assertThat(this.provider.discoverers.entrySet(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void testAddPort() {
        deviceListener.event((Event)new DeviceEvent(DeviceEvent.Type.PORT_ADDED, dev3, (Port)new DefaultPort((Element)dev3, portNumber3, true, new Annotations[0])));
        MatcherAssert.assertThat(this.provider.discoverers.entrySet(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void testRemoveDevice() {
        MatcherAssert.assertThat(this.provider.discoverers.entrySet(), (Matcher)Matchers.hasSize((int)2));
        deviceListener.event((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, dev3));
        MatcherAssert.assertThat(this.provider.discoverers.entrySet(), (Matcher)Matchers.hasSize((int)3));
        deviceListener.event((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_REMOVED, dev3));
        MatcherAssert.assertThat(this.provider.discoverers.entrySet(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testRemovePort() {
        MatcherAssert.assertThat(this.provider.discoverers.entrySet(), (Matcher)Matchers.hasSize((int)2));
        deviceListener.event((Event)new DeviceEvent(DeviceEvent.Type.PORT_ADDED, dev3, (Port)new DefaultPort((Element)dev3, portNumber3, true, new Annotations[0])));
        MatcherAssert.assertThat(this.provider.discoverers.entrySet(), (Matcher)Matchers.hasSize((int)3));
        deviceListener.event((Event)new DeviceEvent(DeviceEvent.Type.PORT_REMOVED, dev3, (Port)new DefaultPort((Element)dev3, portNumber3, true, new Annotations[0])));
        MatcherAssert.assertThat(this.provider.discoverers.entrySet(), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void testDeviceAvailabilityChanged() {
        MatcherAssert.assertThat((Object)this.providerService.vanishedDpid(), (Matcher)Matchers.hasSize((int)0));
        deviceListener.event((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, dev3));
        MatcherAssert.assertThat((Object)this.providerService.vanishedDpid(), (Matcher)Matchers.hasSize((int)0));
        deviceListener.event((Event)new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, dev3));
        MatcherAssert.assertThat((Object)this.providerService.vanishedDpid(), (Matcher)Matchers.hasSize((int)1));
    }

    private final class TestNetworkConfigRegistry
    extends NetworkConfigRegistryAdapter {
        private TestNetworkConfigRegistry() {
        }

        public void addListener(NetworkConfigListener listener) {
            NetworkConfigLinksProviderTest.this.configListener = listener;
        }
    }

    private class TestPacketService
    extends PacketServiceAdapter {
        private TestPacketService() {
        }

        public void addProcessor(PacketProcessor processor, int priority) {
            NetworkConfigLinksProviderTest.this.testProcessor = processor;
        }
    }

    private class TestPacketContext
    implements PacketContext {
        protected ConnectPoint src;
        protected ConnectPoint dst;
        protected boolean blocked = false;

        public TestPacketContext(ConnectPoint src, ConnectPoint dst) {
            this.src = src;
            this.dst = dst;
        }

        public long time() {
            return 0L;
        }

        public InboundPacket inPacket() {
            ONOSLLDP lldp = ONOSLLDP.onosLLDP((String)this.src.deviceId().toString(), (ChassisId)new ChassisId(), (int)((int)this.src.port().toLong()));
            Ethernet ethPacket = new Ethernet();
            ethPacket.setEtherType(Ethernet.TYPE_LLDP);
            ethPacket.setDestinationMACAddress(ONOSLLDP.LLDP_ONLAB);
            ethPacket.setPayload((IPacket)lldp);
            ethPacket.setPad(true);
            ethPacket.setSourceMACAddress("DE:AD:BE:EF:BA:11");
            return new DefaultInboundPacket(this.dst, ethPacket, ByteBuffer.wrap(ethPacket.serialize()));
        }

        public OutboundPacket outPacket() {
            return null;
        }

        public TrafficTreatment.Builder treatmentBuilder() {
            return null;
        }

        public void send() {
        }

        public boolean block() {
            this.blocked = true;
            return true;
        }

        public boolean isHandled() {
            return this.blocked;
        }
    }

    static class TestMastershipService
    extends MastershipServiceAdapter {
        TestMastershipService() {
        }

        public boolean isLocalMaster(DeviceId deviceId) {
            return true;
        }
    }

    static class TestDeviceManager
    extends DeviceServiceAdapter {
        TestDeviceManager() {
        }

        public Iterable<Device> getAvailableDevices() {
            return ImmutableList.of((Object)dev1, (Object)dev2);
        }

        public List<Port> getPorts(DeviceId deviceId) {
            return ImmutableList.of((Object)new DefaultPort((Element)dev1, portNumber1, true, new Annotations[0]), (Object)new DefaultPort((Element)dev2, portNumber2, true, new Annotations[0]));
        }

        public void addListener(DeviceListener listener) {
            deviceListener = listener;
        }

        public Device getDevice(DeviceId deviceId) {
            if (deviceId.equals((Object)dev1.id())) {
                return dev1;
            }
            return dev2;
        }
    }
}

